/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.google.pubsub.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.google.pubsub.services.GooglePubSubInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.PubSubEmulatorContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=GooglePubSubInfraService.class, description="Google Cloud SDK Tool", serviceAlias={"google"}, serviceImplementationAlias={"pub-sub"})
public class GooglePubSubLocalContainerInfraService
implements GooglePubSubInfraService,
ContainerService<PubSubEmulatorContainer> {
    public static final String PROJECT_ID;
    private static final Logger LOG;
    private static final String DEFAULT_PROJECT_ID = "test-project";
    private static final int PORT = 8085;
    private final PubSubEmulatorContainer container;

    public GooglePubSubLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(GooglePubSubLocalContainerInfraService.class, (String)"google.pubsub.container"));
    }

    public GooglePubSubLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public GooglePubSubLocalContainerInfraService(PubSubEmulatorContainer container) {
        this.container = container;
    }

    protected PubSubEmulatorContainer initContainer(final String imageName) {
        class TestInfraPubSubEmulatorContainer
        extends PubSubEmulatorContainer {
            public TestInfraPubSubEmulatorContainer(boolean fixedPort) {
                super(DockerImageName.parse((String)string));
                if (fixedPort) {
                    this.addFixedExposedPort(8085, 8085);
                } else {
                    this.addExposedPort(8085);
                }
            }
        }
        return new TestInfraPubSubEmulatorContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    public void registerProperties() {
        System.setProperty("google.pubsub.service.address", this.getServiceAddress());
    }

    public void initialize() {
        LOG.info("Trying to start the GooglePubSub container");
        this.container.start();
        this.registerProperties();
        LOG.info("GooglePubSub instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the GooglePubSub container");
        this.container.stop();
    }

    public PubSubEmulatorContainer getContainer() {
        return this.container;
    }

    @Override
    public String getServiceAddress() {
        return String.format("%s:%d", this.container.getHost(), this.container.getFirstMappedPort());
    }

    static {
        LOG = LoggerFactory.getLogger(GooglePubSubLocalContainerInfraService.class);
        PROJECT_ID = System.getProperty("google.pubsub.project.id", DEFAULT_PROJECT_ID);
    }
}

