/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.docling.services;

import java.time.Duration;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.docling.services.DoclingInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=DoclingInfraService.class, description="Document processing and conversion service", serviceAlias={"docling"})
public class DoclingLocalContainerInfraService
implements DoclingInfraService,
ContainerService<GenericContainer<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(DoclingLocalContainerInfraService.class);
    private static final String DEFAULT_DOCLING_CONTAINER = "quay.io/docling-project/docling-serve:latest";
    private static final int DOCLING_PORT = 5001;
    private final GenericContainer<?> container;

    public DoclingLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(DoclingLocalContainerInfraService.class, (String)"docling.container"));
    }

    public DoclingLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public DoclingLocalContainerInfraService(GenericContainer<?> container) {
        this.container = container;
    }

    protected GenericContainer<?> initContainer(String imageName) {
        final String doclingImage = imageName != null ? imageName : DEFAULT_DOCLING_CONTAINER;
        class TestInfraDoclingContainer
        extends GenericContainer<TestInfraDoclingContainer> {
            public TestInfraDoclingContainer(boolean fixedPort) {
                super(DockerImageName.parse((String)string));
                ((TestInfraDoclingContainer)((TestInfraDoclingContainer)this.withExposedPorts(new Integer[]{5001})).waitingFor((WaitStrategy)Wait.forListeningPorts((int[])new int[]{5001}))).withStartupTimeout(Duration.ofMinutes(3L));
                if (fixedPort) {
                    this.addFixedExposedPort(5001, 5001);
                }
            }
        }
        return new TestInfraDoclingContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    public void registerProperties() {
        System.setProperty("docling.server.url", this.doclingServerUrl());
    }

    public void initialize() {
        LOG.info("Trying to start the Docling container");
        this.container.start();
        this.registerProperties();
        LOG.info("Docling instance running at {}", (Object)this.doclingServerUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the Docling container");
        this.container.stop();
    }

    public GenericContainer<?> getContainer() {
        return this.container;
    }

    @Override
    public String doclingServerUrl() {
        return String.format("http://%s:%d", this.container.getHost(), this.container.getMappedPort(5001));
    }
}

