// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: tensorflow/core/protobuf/config.proto

// Protobuf Java Version: 3.25.5
package org.tensorflow.framework;

/**
 * <pre>
 * Defines a subgraph in another `GraphDef` as a set of feed points and nodes
 * to be fetched or executed.
 *
 * Compare with the arguments to `Session::Run()`.
 * </pre>
 *
 * Protobuf type {@code tensorflow.CallableOptions}
 */
public final class CallableOptions extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:tensorflow.CallableOptions)
    CallableOptionsOrBuilder {
private static final long serialVersionUID = 0L;
  // Use CallableOptions.newBuilder() to construct.
  private CallableOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private CallableOptions() {
    feed_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    fetch_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    target_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    tensorConnection_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new CallableOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return org.tensorflow.framework.ConfigProtos.internal_static_tensorflow_CallableOptions_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetFeedDevices();
      case 7:
        return internalGetFetchDevices();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return org.tensorflow.framework.ConfigProtos.internal_static_tensorflow_CallableOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.tensorflow.framework.CallableOptions.class, org.tensorflow.framework.CallableOptions.Builder.class);
  }

  private int bitField0_;
  public static final int FEED_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList feed_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * Tensors to be fed in the callable. Each feed is the name of a tensor.
   * </pre>
   *
   * <code>repeated string feed = 1;</code>
   * @return A list containing the feed.
   */
  public com.google.protobuf.ProtocolStringList
      getFeedList() {
    return feed_;
  }
  /**
   * <pre>
   * Tensors to be fed in the callable. Each feed is the name of a tensor.
   * </pre>
   *
   * <code>repeated string feed = 1;</code>
   * @return The count of feed.
   */
  public int getFeedCount() {
    return feed_.size();
  }
  /**
   * <pre>
   * Tensors to be fed in the callable. Each feed is the name of a tensor.
   * </pre>
   *
   * <code>repeated string feed = 1;</code>
   * @param index The index of the element to return.
   * @return The feed at the given index.
   */
  public java.lang.String getFeed(int index) {
    return feed_.get(index);
  }
  /**
   * <pre>
   * Tensors to be fed in the callable. Each feed is the name of a tensor.
   * </pre>
   *
   * <code>repeated string feed = 1;</code>
   * @param index The index of the value to return.
   * @return The bytes of the feed at the given index.
   */
  public com.google.protobuf.ByteString
      getFeedBytes(int index) {
    return feed_.getByteString(index);
  }

  public static final int FETCH_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList fetch_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * Fetches. A list of tensor names. The caller of the callable expects a
   * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
   * order of specified fetches does not change the execution order.
   * </pre>
   *
   * <code>repeated string fetch = 2;</code>
   * @return A list containing the fetch.
   */
  public com.google.protobuf.ProtocolStringList
      getFetchList() {
    return fetch_;
  }
  /**
   * <pre>
   * Fetches. A list of tensor names. The caller of the callable expects a
   * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
   * order of specified fetches does not change the execution order.
   * </pre>
   *
   * <code>repeated string fetch = 2;</code>
   * @return The count of fetch.
   */
  public int getFetchCount() {
    return fetch_.size();
  }
  /**
   * <pre>
   * Fetches. A list of tensor names. The caller of the callable expects a
   * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
   * order of specified fetches does not change the execution order.
   * </pre>
   *
   * <code>repeated string fetch = 2;</code>
   * @param index The index of the element to return.
   * @return The fetch at the given index.
   */
  public java.lang.String getFetch(int index) {
    return fetch_.get(index);
  }
  /**
   * <pre>
   * Fetches. A list of tensor names. The caller of the callable expects a
   * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
   * order of specified fetches does not change the execution order.
   * </pre>
   *
   * <code>repeated string fetch = 2;</code>
   * @param index The index of the value to return.
   * @return The bytes of the fetch at the given index.
   */
  public com.google.protobuf.ByteString
      getFetchBytes(int index) {
    return fetch_.getByteString(index);
  }

  public static final int TARGET_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList target_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * Target Nodes. A list of node names. The named nodes will be run by the
   * callable but their outputs will not be returned.
   * </pre>
   *
   * <code>repeated string target = 3;</code>
   * @return A list containing the target.
   */
  public com.google.protobuf.ProtocolStringList
      getTargetList() {
    return target_;
  }
  /**
   * <pre>
   * Target Nodes. A list of node names. The named nodes will be run by the
   * callable but their outputs will not be returned.
   * </pre>
   *
   * <code>repeated string target = 3;</code>
   * @return The count of target.
   */
  public int getTargetCount() {
    return target_.size();
  }
  /**
   * <pre>
   * Target Nodes. A list of node names. The named nodes will be run by the
   * callable but their outputs will not be returned.
   * </pre>
   *
   * <code>repeated string target = 3;</code>
   * @param index The index of the element to return.
   * @return The target at the given index.
   */
  public java.lang.String getTarget(int index) {
    return target_.get(index);
  }
  /**
   * <pre>
   * Target Nodes. A list of node names. The named nodes will be run by the
   * callable but their outputs will not be returned.
   * </pre>
   *
   * <code>repeated string target = 3;</code>
   * @param index The index of the value to return.
   * @return The bytes of the target at the given index.
   */
  public com.google.protobuf.ByteString
      getTargetBytes(int index) {
    return target_.getByteString(index);
  }

  public static final int RUN_OPTIONS_FIELD_NUMBER = 4;
  private org.tensorflow.framework.RunOptions runOptions_;
  /**
   * <pre>
   * Options that will be applied to each run.
   * </pre>
   *
   * <code>.tensorflow.RunOptions run_options = 4;</code>
   * @return Whether the runOptions field is set.
   */
  @java.lang.Override
  public boolean hasRunOptions() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Options that will be applied to each run.
   * </pre>
   *
   * <code>.tensorflow.RunOptions run_options = 4;</code>
   * @return The runOptions.
   */
  @java.lang.Override
  public org.tensorflow.framework.RunOptions getRunOptions() {
    return runOptions_ == null ? org.tensorflow.framework.RunOptions.getDefaultInstance() : runOptions_;
  }
  /**
   * <pre>
   * Options that will be applied to each run.
   * </pre>
   *
   * <code>.tensorflow.RunOptions run_options = 4;</code>
   */
  @java.lang.Override
  public org.tensorflow.framework.RunOptionsOrBuilder getRunOptionsOrBuilder() {
    return runOptions_ == null ? org.tensorflow.framework.RunOptions.getDefaultInstance() : runOptions_;
  }

  public static final int TENSOR_CONNECTION_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private java.util.List<org.tensorflow.framework.TensorConnection> tensorConnection_;
  /**
   * <pre>
   * Tensors to be connected in the callable. Each TensorConnection denotes
   * a pair of tensors in the graph, between which an edge will be created
   * in the callable.
   * </pre>
   *
   * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
   */
  @java.lang.Override
  public java.util.List<org.tensorflow.framework.TensorConnection> getTensorConnectionList() {
    return tensorConnection_;
  }
  /**
   * <pre>
   * Tensors to be connected in the callable. Each TensorConnection denotes
   * a pair of tensors in the graph, between which an edge will be created
   * in the callable.
   * </pre>
   *
   * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends org.tensorflow.framework.TensorConnectionOrBuilder> 
      getTensorConnectionOrBuilderList() {
    return tensorConnection_;
  }
  /**
   * <pre>
   * Tensors to be connected in the callable. Each TensorConnection denotes
   * a pair of tensors in the graph, between which an edge will be created
   * in the callable.
   * </pre>
   *
   * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
   */
  @java.lang.Override
  public int getTensorConnectionCount() {
    return tensorConnection_.size();
  }
  /**
   * <pre>
   * Tensors to be connected in the callable. Each TensorConnection denotes
   * a pair of tensors in the graph, between which an edge will be created
   * in the callable.
   * </pre>
   *
   * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
   */
  @java.lang.Override
  public org.tensorflow.framework.TensorConnection getTensorConnection(int index) {
    return tensorConnection_.get(index);
  }
  /**
   * <pre>
   * Tensors to be connected in the callable. Each TensorConnection denotes
   * a pair of tensors in the graph, between which an edge will be created
   * in the callable.
   * </pre>
   *
   * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
   */
  @java.lang.Override
  public org.tensorflow.framework.TensorConnectionOrBuilder getTensorConnectionOrBuilder(
      int index) {
    return tensorConnection_.get(index);
  }

  public static final int FEED_DEVICES_FIELD_NUMBER = 6;
  private static final class FeedDevicesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, java.lang.String> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, java.lang.String>newDefaultInstance(
                org.tensorflow.framework.ConfigProtos.internal_static_tensorflow_CallableOptions_FeedDevicesEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.STRING,
                "");
  }
  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
      java.lang.String, java.lang.String> feedDevices_;
  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
  internalGetFeedDevices() {
    if (feedDevices_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          FeedDevicesDefaultEntryHolder.defaultEntry);
    }
    return feedDevices_;
  }
  public int getFeedDevicesCount() {
    return internalGetFeedDevices().getMap().size();
  }
  /**
   * <pre>
   * The Tensor objects fed in the callable and fetched from the callable
   * are expected to be backed by host (CPU) memory by default.
   *
   * The options below allow changing that - feeding tensors backed by
   * device memory, or returning tensors that are backed by device memory.
   *
   * The maps below map the name of a feed/fetch tensor (which appears in
   * 'feed' or 'fetch' fields above), to the fully qualified name of the device
   * owning the memory backing the contents of the tensor.
   *
   * For example, creating a callable with the following options:
   *
   * CallableOptions {
   *   feed: "a:0"
   *   feed: "b:0"
   *
   *   fetch: "x:0"
   *   fetch: "y:0"
   *
   *   feed_devices: {
   *     "a:0": "/job:localhost/replica:0/task:0/device:GPU:0"
   *   }
   *
   *   fetch_devices: {
   *     "y:0": "/job:localhost/replica:0/task:0/device:GPU:0"
   *  }
   * }
   *
   * means that the Callable expects:
   * - The first argument ("a:0") is a Tensor backed by GPU memory.
   * - The second argument ("b:0") is a Tensor backed by host memory.
   * and of its return values:
   * - The first output ("x:0") will be backed by host memory.
   * - The second output ("y:0") will be backed by GPU memory.
   *
   * FEEDS:
   * It is the responsibility of the caller to ensure that the memory of the fed
   * tensors will be correctly initialized and synchronized before it is
   * accessed by operations executed during the call to Session::RunCallable().
   *
   * This is typically ensured by using the TensorFlow memory allocators
   * (Device::GetAllocator()) to create the Tensor to be fed.
   *
   * Alternatively, for CUDA-enabled GPU devices, this typically means that the
   * operation that produced the contents of the tensor has completed, i.e., the
   * CUDA stream has been synchronized (e.g., via cuCtxSynchronize() or
   * cuStreamSynchronize()).
   * </pre>
   *
   * <code>map&lt;string, string&gt; feed_devices = 6;</code>
   */
  @java.lang.Override
  public boolean containsFeedDevices(
      java.lang.String key) {
    if (key == null) { throw new NullPointerException("map key"); }
    return internalGetFeedDevices().getMap().containsKey(key);
  }
  /**
   * Use {@link #getFeedDevicesMap()} instead.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getFeedDevices() {
    return getFeedDevicesMap();
  }
  /**
   * <pre>
   * The Tensor objects fed in the callable and fetched from the callable
   * are expected to be backed by host (CPU) memory by default.
   *
   * The options below allow changing that - feeding tensors backed by
   * device memory, or returning tensors that are backed by device memory.
   *
   * The maps below map the name of a feed/fetch tensor (which appears in
   * 'feed' or 'fetch' fields above), to the fully qualified name of the device
   * owning the memory backing the contents of the tensor.
   *
   * For example, creating a callable with the following options:
   *
   * CallableOptions {
   *   feed: "a:0"
   *   feed: "b:0"
   *
   *   fetch: "x:0"
   *   fetch: "y:0"
   *
   *   feed_devices: {
   *     "a:0": "/job:localhost/replica:0/task:0/device:GPU:0"
   *   }
   *
   *   fetch_devices: {
   *     "y:0": "/job:localhost/replica:0/task:0/device:GPU:0"
   *  }
   * }
   *
   * means that the Callable expects:
   * - The first argument ("a:0") is a Tensor backed by GPU memory.
   * - The second argument ("b:0") is a Tensor backed by host memory.
   * and of its return values:
   * - The first output ("x:0") will be backed by host memory.
   * - The second output ("y:0") will be backed by GPU memory.
   *
   * FEEDS:
   * It is the responsibility of the caller to ensure that the memory of the fed
   * tensors will be correctly initialized and synchronized before it is
   * accessed by operations executed during the call to Session::RunCallable().
   *
   * This is typically ensured by using the TensorFlow memory allocators
   * (Device::GetAllocator()) to create the Tensor to be fed.
   *
   * Alternatively, for CUDA-enabled GPU devices, this typically means that the
   * operation that produced the contents of the tensor has completed, i.e., the
   * CUDA stream has been synchronized (e.g., via cuCtxSynchronize() or
   * cuStreamSynchronize()).
   * </pre>
   *
   * <code>map&lt;string, string&gt; feed_devices = 6;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getFeedDevicesMap() {
    return internalGetFeedDevices().getMap();
  }
  /**
   * <pre>
   * The Tensor objects fed in the callable and fetched from the callable
   * are expected to be backed by host (CPU) memory by default.
   *
   * The options below allow changing that - feeding tensors backed by
   * device memory, or returning tensors that are backed by device memory.
   *
   * The maps below map the name of a feed/fetch tensor (which appears in
   * 'feed' or 'fetch' fields above), to the fully qualified name of the device
   * owning the memory backing the contents of the tensor.
   *
   * For example, creating a callable with the following options:
   *
   * CallableOptions {
   *   feed: "a:0"
   *   feed: "b:0"
   *
   *   fetch: "x:0"
   *   fetch: "y:0"
   *
   *   feed_devices: {
   *     "a:0": "/job:localhost/replica:0/task:0/device:GPU:0"
   *   }
   *
   *   fetch_devices: {
   *     "y:0": "/job:localhost/replica:0/task:0/device:GPU:0"
   *  }
   * }
   *
   * means that the Callable expects:
   * - The first argument ("a:0") is a Tensor backed by GPU memory.
   * - The second argument ("b:0") is a Tensor backed by host memory.
   * and of its return values:
   * - The first output ("x:0") will be backed by host memory.
   * - The second output ("y:0") will be backed by GPU memory.
   *
   * FEEDS:
   * It is the responsibility of the caller to ensure that the memory of the fed
   * tensors will be correctly initialized and synchronized before it is
   * accessed by operations executed during the call to Session::RunCallable().
   *
   * This is typically ensured by using the TensorFlow memory allocators
   * (Device::GetAllocator()) to create the Tensor to be fed.
   *
   * Alternatively, for CUDA-enabled GPU devices, this typically means that the
   * operation that produced the contents of the tensor has completed, i.e., the
   * CUDA stream has been synchronized (e.g., via cuCtxSynchronize() or
   * cuStreamSynchronize()).
   * </pre>
   *
   * <code>map&lt;string, string&gt; feed_devices = 6;</code>
   */
  @java.lang.Override
  public /* nullable */
java.lang.String getFeedDevicesOrDefault(
      java.lang.String key,
      /* nullable */
java.lang.String defaultValue) {
    if (key == null) { throw new NullPointerException("map key"); }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetFeedDevices().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * The Tensor objects fed in the callable and fetched from the callable
   * are expected to be backed by host (CPU) memory by default.
   *
   * The options below allow changing that - feeding tensors backed by
   * device memory, or returning tensors that are backed by device memory.
   *
   * The maps below map the name of a feed/fetch tensor (which appears in
   * 'feed' or 'fetch' fields above), to the fully qualified name of the device
   * owning the memory backing the contents of the tensor.
   *
   * For example, creating a callable with the following options:
   *
   * CallableOptions {
   *   feed: "a:0"
   *   feed: "b:0"
   *
   *   fetch: "x:0"
   *   fetch: "y:0"
   *
   *   feed_devices: {
   *     "a:0": "/job:localhost/replica:0/task:0/device:GPU:0"
   *   }
   *
   *   fetch_devices: {
   *     "y:0": "/job:localhost/replica:0/task:0/device:GPU:0"
   *  }
   * }
   *
   * means that the Callable expects:
   * - The first argument ("a:0") is a Tensor backed by GPU memory.
   * - The second argument ("b:0") is a Tensor backed by host memory.
   * and of its return values:
   * - The first output ("x:0") will be backed by host memory.
   * - The second output ("y:0") will be backed by GPU memory.
   *
   * FEEDS:
   * It is the responsibility of the caller to ensure that the memory of the fed
   * tensors will be correctly initialized and synchronized before it is
   * accessed by operations executed during the call to Session::RunCallable().
   *
   * This is typically ensured by using the TensorFlow memory allocators
   * (Device::GetAllocator()) to create the Tensor to be fed.
   *
   * Alternatively, for CUDA-enabled GPU devices, this typically means that the
   * operation that produced the contents of the tensor has completed, i.e., the
   * CUDA stream has been synchronized (e.g., via cuCtxSynchronize() or
   * cuStreamSynchronize()).
   * </pre>
   *
   * <code>map&lt;string, string&gt; feed_devices = 6;</code>
   */
  @java.lang.Override
  public java.lang.String getFeedDevicesOrThrow(
      java.lang.String key) {
    if (key == null) { throw new NullPointerException("map key"); }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetFeedDevices().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FETCH_DEVICES_FIELD_NUMBER = 7;
  private static final class FetchDevicesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, java.lang.String> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, java.lang.String>newDefaultInstance(
                org.tensorflow.framework.ConfigProtos.internal_static_tensorflow_CallableOptions_FetchDevicesEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.STRING,
                "");
  }
  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
      java.lang.String, java.lang.String> fetchDevices_;
  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
  internalGetFetchDevices() {
    if (fetchDevices_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          FetchDevicesDefaultEntryHolder.defaultEntry);
    }
    return fetchDevices_;
  }
  public int getFetchDevicesCount() {
    return internalGetFetchDevices().getMap().size();
  }
  /**
   * <code>map&lt;string, string&gt; fetch_devices = 7;</code>
   */
  @java.lang.Override
  public boolean containsFetchDevices(
      java.lang.String key) {
    if (key == null) { throw new NullPointerException("map key"); }
    return internalGetFetchDevices().getMap().containsKey(key);
  }
  /**
   * Use {@link #getFetchDevicesMap()} instead.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getFetchDevices() {
    return getFetchDevicesMap();
  }
  /**
   * <code>map&lt;string, string&gt; fetch_devices = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getFetchDevicesMap() {
    return internalGetFetchDevices().getMap();
  }
  /**
   * <code>map&lt;string, string&gt; fetch_devices = 7;</code>
   */
  @java.lang.Override
  public /* nullable */
java.lang.String getFetchDevicesOrDefault(
      java.lang.String key,
      /* nullable */
java.lang.String defaultValue) {
    if (key == null) { throw new NullPointerException("map key"); }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetFetchDevices().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <code>map&lt;string, string&gt; fetch_devices = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getFetchDevicesOrThrow(
      java.lang.String key) {
    if (key == null) { throw new NullPointerException("map key"); }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetFetchDevices().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FETCH_SKIP_SYNC_FIELD_NUMBER = 8;
  private boolean fetchSkipSync_ = false;
  /**
   * <pre>
   * By default, RunCallable() will synchronize the GPU stream before returning
   * fetched tensors on a GPU device, to ensure that the values in those tensors
   * have been produced. This simplifies interacting with the tensors, but
   * potentially incurs a performance hit.
   *
   * If this options is set to true, the caller is responsible for ensuring
   * that the values in the fetched tensors have been produced before they are
   * used. The caller can do this by invoking `Device::Sync()` on the underlying
   * device(s), or by feeding the tensors back to the same Session using
   * `feed_devices` with the same corresponding device name.
   * </pre>
   *
   * <code>bool fetch_skip_sync = 8;</code>
   * @return The fetchSkipSync.
   */
  @java.lang.Override
  public boolean getFetchSkipSync() {
    return fetchSkipSync_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    for (int i = 0; i < feed_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, feed_.getRaw(i));
    }
    for (int i = 0; i < fetch_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fetch_.getRaw(i));
    }
    for (int i = 0; i < target_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, target_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getRunOptions());
    }
    for (int i = 0; i < tensorConnection_.size(); i++) {
      output.writeMessage(5, tensorConnection_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetFeedDevices(),
        FeedDevicesDefaultEntryHolder.defaultEntry,
        6);
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetFetchDevices(),
        FetchDevicesDefaultEntryHolder.defaultEntry,
        7);
    if (fetchSkipSync_ != false) {
      output.writeBool(8, fetchSkipSync_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < feed_.size(); i++) {
        dataSize += computeStringSizeNoTag(feed_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFeedList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < fetch_.size(); i++) {
        dataSize += computeStringSizeNoTag(fetch_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFetchList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < target_.size(); i++) {
        dataSize += computeStringSizeNoTag(target_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTargetList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getRunOptions());
    }
    for (int i = 0; i < tensorConnection_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, tensorConnection_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry
         : internalGetFeedDevices().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
      feedDevices__ = FeedDevicesDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, feedDevices__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry
         : internalGetFetchDevices().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
      fetchDevices__ = FetchDevicesDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, fetchDevices__);
    }
    if (fetchSkipSync_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(8, fetchSkipSync_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof org.tensorflow.framework.CallableOptions)) {
      return super.equals(obj);
    }
    org.tensorflow.framework.CallableOptions other = (org.tensorflow.framework.CallableOptions) obj;

    if (!getFeedList()
        .equals(other.getFeedList())) return false;
    if (!getFetchList()
        .equals(other.getFetchList())) return false;
    if (!getTargetList()
        .equals(other.getTargetList())) return false;
    if (hasRunOptions() != other.hasRunOptions()) return false;
    if (hasRunOptions()) {
      if (!getRunOptions()
          .equals(other.getRunOptions())) return false;
    }
    if (!getTensorConnectionList()
        .equals(other.getTensorConnectionList())) return false;
    if (!internalGetFeedDevices().equals(
        other.internalGetFeedDevices())) return false;
    if (!internalGetFetchDevices().equals(
        other.internalGetFetchDevices())) return false;
    if (getFetchSkipSync()
        != other.getFetchSkipSync()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFeedCount() > 0) {
      hash = (37 * hash) + FEED_FIELD_NUMBER;
      hash = (53 * hash) + getFeedList().hashCode();
    }
    if (getFetchCount() > 0) {
      hash = (37 * hash) + FETCH_FIELD_NUMBER;
      hash = (53 * hash) + getFetchList().hashCode();
    }
    if (getTargetCount() > 0) {
      hash = (37 * hash) + TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getTargetList().hashCode();
    }
    if (hasRunOptions()) {
      hash = (37 * hash) + RUN_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRunOptions().hashCode();
    }
    if (getTensorConnectionCount() > 0) {
      hash = (37 * hash) + TENSOR_CONNECTION_FIELD_NUMBER;
      hash = (53 * hash) + getTensorConnectionList().hashCode();
    }
    if (!internalGetFeedDevices().getMap().isEmpty()) {
      hash = (37 * hash) + FEED_DEVICES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetFeedDevices().hashCode();
    }
    if (!internalGetFetchDevices().getMap().isEmpty()) {
      hash = (37 * hash) + FETCH_DEVICES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetFetchDevices().hashCode();
    }
    hash = (37 * hash) + FETCH_SKIP_SYNC_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getFetchSkipSync());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.tensorflow.framework.CallableOptions parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.tensorflow.framework.CallableOptions parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.tensorflow.framework.CallableOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.tensorflow.framework.CallableOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.tensorflow.framework.CallableOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.tensorflow.framework.CallableOptions parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.tensorflow.framework.CallableOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static org.tensorflow.framework.CallableOptions parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static org.tensorflow.framework.CallableOptions parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static org.tensorflow.framework.CallableOptions parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static org.tensorflow.framework.CallableOptions parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static org.tensorflow.framework.CallableOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(org.tensorflow.framework.CallableOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Defines a subgraph in another `GraphDef` as a set of feed points and nodes
   * to be fetched or executed.
   *
   * Compare with the arguments to `Session::Run()`.
   * </pre>
   *
   * Protobuf type {@code tensorflow.CallableOptions}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:tensorflow.CallableOptions)
      org.tensorflow.framework.CallableOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.tensorflow.framework.ConfigProtos.internal_static_tensorflow_CallableOptions_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetFeedDevices();
        case 7:
          return internalGetFetchDevices();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableFeedDevices();
        case 7:
          return internalGetMutableFetchDevices();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.tensorflow.framework.ConfigProtos.internal_static_tensorflow_CallableOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.tensorflow.framework.CallableOptions.class, org.tensorflow.framework.CallableOptions.Builder.class);
    }

    // Construct using org.tensorflow.framework.CallableOptions.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getRunOptionsFieldBuilder();
        getTensorConnectionFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      feed_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      fetch_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      target_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      runOptions_ = null;
      if (runOptionsBuilder_ != null) {
        runOptionsBuilder_.dispose();
        runOptionsBuilder_ = null;
      }
      if (tensorConnectionBuilder_ == null) {
        tensorConnection_ = java.util.Collections.emptyList();
      } else {
        tensorConnection_ = null;
        tensorConnectionBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableFeedDevices().clear();
      internalGetMutableFetchDevices().clear();
      fetchSkipSync_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return org.tensorflow.framework.ConfigProtos.internal_static_tensorflow_CallableOptions_descriptor;
    }

    @java.lang.Override
    public org.tensorflow.framework.CallableOptions getDefaultInstanceForType() {
      return org.tensorflow.framework.CallableOptions.getDefaultInstance();
    }

    @java.lang.Override
    public org.tensorflow.framework.CallableOptions build() {
      org.tensorflow.framework.CallableOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.tensorflow.framework.CallableOptions buildPartial() {
      org.tensorflow.framework.CallableOptions result = new org.tensorflow.framework.CallableOptions(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(org.tensorflow.framework.CallableOptions result) {
      if (tensorConnectionBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          tensorConnection_ = java.util.Collections.unmodifiableList(tensorConnection_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.tensorConnection_ = tensorConnection_;
      } else {
        result.tensorConnection_ = tensorConnectionBuilder_.build();
      }
    }

    private void buildPartial0(org.tensorflow.framework.CallableOptions result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        feed_.makeImmutable();
        result.feed_ = feed_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        fetch_.makeImmutable();
        result.fetch_ = fetch_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        target_.makeImmutable();
        result.target_ = target_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.runOptions_ = runOptionsBuilder_ == null
            ? runOptions_
            : runOptionsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.feedDevices_ = internalGetFeedDevices();
        result.feedDevices_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.fetchDevices_ = internalGetFetchDevices();
        result.fetchDevices_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.fetchSkipSync_ = fetchSkipSync_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof org.tensorflow.framework.CallableOptions) {
        return mergeFrom((org.tensorflow.framework.CallableOptions)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.tensorflow.framework.CallableOptions other) {
      if (other == org.tensorflow.framework.CallableOptions.getDefaultInstance()) return this;
      if (!other.feed_.isEmpty()) {
        if (feed_.isEmpty()) {
          feed_ = other.feed_;
          bitField0_ |= 0x00000001;
        } else {
          ensureFeedIsMutable();
          feed_.addAll(other.feed_);
        }
        onChanged();
      }
      if (!other.fetch_.isEmpty()) {
        if (fetch_.isEmpty()) {
          fetch_ = other.fetch_;
          bitField0_ |= 0x00000002;
        } else {
          ensureFetchIsMutable();
          fetch_.addAll(other.fetch_);
        }
        onChanged();
      }
      if (!other.target_.isEmpty()) {
        if (target_.isEmpty()) {
          target_ = other.target_;
          bitField0_ |= 0x00000004;
        } else {
          ensureTargetIsMutable();
          target_.addAll(other.target_);
        }
        onChanged();
      }
      if (other.hasRunOptions()) {
        mergeRunOptions(other.getRunOptions());
      }
      if (tensorConnectionBuilder_ == null) {
        if (!other.tensorConnection_.isEmpty()) {
          if (tensorConnection_.isEmpty()) {
            tensorConnection_ = other.tensorConnection_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureTensorConnectionIsMutable();
            tensorConnection_.addAll(other.tensorConnection_);
          }
          onChanged();
        }
      } else {
        if (!other.tensorConnection_.isEmpty()) {
          if (tensorConnectionBuilder_.isEmpty()) {
            tensorConnectionBuilder_.dispose();
            tensorConnectionBuilder_ = null;
            tensorConnection_ = other.tensorConnection_;
            bitField0_ = (bitField0_ & ~0x00000010);
            tensorConnectionBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getTensorConnectionFieldBuilder() : null;
          } else {
            tensorConnectionBuilder_.addAllMessages(other.tensorConnection_);
          }
        }
      }
      internalGetMutableFeedDevices().mergeFrom(
          other.internalGetFeedDevices());
      bitField0_ |= 0x00000020;
      internalGetMutableFetchDevices().mergeFrom(
          other.internalGetFetchDevices());
      bitField0_ |= 0x00000040;
      if (other.getFetchSkipSync() != false) {
        setFetchSkipSync(other.getFetchSkipSync());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureFeedIsMutable();
              feed_.add(s);
              break;
            } // case 10
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureFetchIsMutable();
              fetch_.add(s);
              break;
            } // case 18
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureTargetIsMutable();
              target_.add(s);
              break;
            } // case 26
            case 34: {
              input.readMessage(
                  getRunOptionsFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000008;
              break;
            } // case 34
            case 42: {
              org.tensorflow.framework.TensorConnection m =
                  input.readMessage(
                      org.tensorflow.framework.TensorConnection.parser(),
                      extensionRegistry);
              if (tensorConnectionBuilder_ == null) {
                ensureTensorConnectionIsMutable();
                tensorConnection_.add(m);
              } else {
                tensorConnectionBuilder_.addMessage(m);
              }
              break;
            } // case 42
            case 50: {
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
              feedDevices__ = input.readMessage(
                  FeedDevicesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              internalGetMutableFeedDevices().getMutableMap().put(
                  feedDevices__.getKey(), feedDevices__.getValue());
              bitField0_ |= 0x00000020;
              break;
            } // case 50
            case 58: {
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
              fetchDevices__ = input.readMessage(
                  FetchDevicesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              internalGetMutableFetchDevices().getMutableMap().put(
                  fetchDevices__.getKey(), fetchDevices__.getValue());
              bitField0_ |= 0x00000040;
              break;
            } // case 58
            case 64: {
              fetchSkipSync_ = input.readBool();
              bitField0_ |= 0x00000080;
              break;
            } // case 64
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList feed_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureFeedIsMutable() {
      if (!feed_.isModifiable()) {
        feed_ = new com.google.protobuf.LazyStringArrayList(feed_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     * <pre>
     * Tensors to be fed in the callable. Each feed is the name of a tensor.
     * </pre>
     *
     * <code>repeated string feed = 1;</code>
     * @return A list containing the feed.
     */
    public com.google.protobuf.ProtocolStringList
        getFeedList() {
      feed_.makeImmutable();
      return feed_;
    }
    /**
     * <pre>
     * Tensors to be fed in the callable. Each feed is the name of a tensor.
     * </pre>
     *
     * <code>repeated string feed = 1;</code>
     * @return The count of feed.
     */
    public int getFeedCount() {
      return feed_.size();
    }
    /**
     * <pre>
     * Tensors to be fed in the callable. Each feed is the name of a tensor.
     * </pre>
     *
     * <code>repeated string feed = 1;</code>
     * @param index The index of the element to return.
     * @return The feed at the given index.
     */
    public java.lang.String getFeed(int index) {
      return feed_.get(index);
    }
    /**
     * <pre>
     * Tensors to be fed in the callable. Each feed is the name of a tensor.
     * </pre>
     *
     * <code>repeated string feed = 1;</code>
     * @param index The index of the value to return.
     * @return The bytes of the feed at the given index.
     */
    public com.google.protobuf.ByteString
        getFeedBytes(int index) {
      return feed_.getByteString(index);
    }
    /**
     * <pre>
     * Tensors to be fed in the callable. Each feed is the name of a tensor.
     * </pre>
     *
     * <code>repeated string feed = 1;</code>
     * @param index The index to set the value at.
     * @param value The feed to set.
     * @return This builder for chaining.
     */
    public Builder setFeed(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFeedIsMutable();
      feed_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Tensors to be fed in the callable. Each feed is the name of a tensor.
     * </pre>
     *
     * <code>repeated string feed = 1;</code>
     * @param value The feed to add.
     * @return This builder for chaining.
     */
    public Builder addFeed(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFeedIsMutable();
      feed_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Tensors to be fed in the callable. Each feed is the name of a tensor.
     * </pre>
     *
     * <code>repeated string feed = 1;</code>
     * @param values The feed to add.
     * @return This builder for chaining.
     */
    public Builder addAllFeed(
        java.lang.Iterable<java.lang.String> values) {
      ensureFeedIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, feed_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Tensors to be fed in the callable. Each feed is the name of a tensor.
     * </pre>
     *
     * <code>repeated string feed = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearFeed() {
      feed_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Tensors to be fed in the callable. Each feed is the name of a tensor.
     * </pre>
     *
     * <code>repeated string feed = 1;</code>
     * @param value The bytes of the feed to add.
     * @return This builder for chaining.
     */
    public Builder addFeedBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureFeedIsMutable();
      feed_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList fetch_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureFetchIsMutable() {
      if (!fetch_.isModifiable()) {
        fetch_ = new com.google.protobuf.LazyStringArrayList(fetch_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     * <pre>
     * Fetches. A list of tensor names. The caller of the callable expects a
     * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
     * order of specified fetches does not change the execution order.
     * </pre>
     *
     * <code>repeated string fetch = 2;</code>
     * @return A list containing the fetch.
     */
    public com.google.protobuf.ProtocolStringList
        getFetchList() {
      fetch_.makeImmutable();
      return fetch_;
    }
    /**
     * <pre>
     * Fetches. A list of tensor names. The caller of the callable expects a
     * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
     * order of specified fetches does not change the execution order.
     * </pre>
     *
     * <code>repeated string fetch = 2;</code>
     * @return The count of fetch.
     */
    public int getFetchCount() {
      return fetch_.size();
    }
    /**
     * <pre>
     * Fetches. A list of tensor names. The caller of the callable expects a
     * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
     * order of specified fetches does not change the execution order.
     * </pre>
     *
     * <code>repeated string fetch = 2;</code>
     * @param index The index of the element to return.
     * @return The fetch at the given index.
     */
    public java.lang.String getFetch(int index) {
      return fetch_.get(index);
    }
    /**
     * <pre>
     * Fetches. A list of tensor names. The caller of the callable expects a
     * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
     * order of specified fetches does not change the execution order.
     * </pre>
     *
     * <code>repeated string fetch = 2;</code>
     * @param index The index of the value to return.
     * @return The bytes of the fetch at the given index.
     */
    public com.google.protobuf.ByteString
        getFetchBytes(int index) {
      return fetch_.getByteString(index);
    }
    /**
     * <pre>
     * Fetches. A list of tensor names. The caller of the callable expects a
     * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
     * order of specified fetches does not change the execution order.
     * </pre>
     *
     * <code>repeated string fetch = 2;</code>
     * @param index The index to set the value at.
     * @param value The fetch to set.
     * @return This builder for chaining.
     */
    public Builder setFetch(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFetchIsMutable();
      fetch_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fetches. A list of tensor names. The caller of the callable expects a
     * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
     * order of specified fetches does not change the execution order.
     * </pre>
     *
     * <code>repeated string fetch = 2;</code>
     * @param value The fetch to add.
     * @return This builder for chaining.
     */
    public Builder addFetch(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureFetchIsMutable();
      fetch_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fetches. A list of tensor names. The caller of the callable expects a
     * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
     * order of specified fetches does not change the execution order.
     * </pre>
     *
     * <code>repeated string fetch = 2;</code>
     * @param values The fetch to add.
     * @return This builder for chaining.
     */
    public Builder addAllFetch(
        java.lang.Iterable<java.lang.String> values) {
      ensureFetchIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, fetch_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fetches. A list of tensor names. The caller of the callable expects a
     * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
     * order of specified fetches does not change the execution order.
     * </pre>
     *
     * <code>repeated string fetch = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearFetch() {
      fetch_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fetches. A list of tensor names. The caller of the callable expects a
     * tensor to be returned for each fetch[i] (see RunStepResponse.tensor). The
     * order of specified fetches does not change the execution order.
     * </pre>
     *
     * <code>repeated string fetch = 2;</code>
     * @param value The bytes of the fetch to add.
     * @return This builder for chaining.
     */
    public Builder addFetchBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureFetchIsMutable();
      fetch_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList target_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureTargetIsMutable() {
      if (!target_.isModifiable()) {
        target_ = new com.google.protobuf.LazyStringArrayList(target_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     * <pre>
     * Target Nodes. A list of node names. The named nodes will be run by the
     * callable but their outputs will not be returned.
     * </pre>
     *
     * <code>repeated string target = 3;</code>
     * @return A list containing the target.
     */
    public com.google.protobuf.ProtocolStringList
        getTargetList() {
      target_.makeImmutable();
      return target_;
    }
    /**
     * <pre>
     * Target Nodes. A list of node names. The named nodes will be run by the
     * callable but their outputs will not be returned.
     * </pre>
     *
     * <code>repeated string target = 3;</code>
     * @return The count of target.
     */
    public int getTargetCount() {
      return target_.size();
    }
    /**
     * <pre>
     * Target Nodes. A list of node names. The named nodes will be run by the
     * callable but their outputs will not be returned.
     * </pre>
     *
     * <code>repeated string target = 3;</code>
     * @param index The index of the element to return.
     * @return The target at the given index.
     */
    public java.lang.String getTarget(int index) {
      return target_.get(index);
    }
    /**
     * <pre>
     * Target Nodes. A list of node names. The named nodes will be run by the
     * callable but their outputs will not be returned.
     * </pre>
     *
     * <code>repeated string target = 3;</code>
     * @param index The index of the value to return.
     * @return The bytes of the target at the given index.
     */
    public com.google.protobuf.ByteString
        getTargetBytes(int index) {
      return target_.getByteString(index);
    }
    /**
     * <pre>
     * Target Nodes. A list of node names. The named nodes will be run by the
     * callable but their outputs will not be returned.
     * </pre>
     *
     * <code>repeated string target = 3;</code>
     * @param index The index to set the value at.
     * @param value The target to set.
     * @return This builder for chaining.
     */
    public Builder setTarget(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureTargetIsMutable();
      target_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Target Nodes. A list of node names. The named nodes will be run by the
     * callable but their outputs will not be returned.
     * </pre>
     *
     * <code>repeated string target = 3;</code>
     * @param value The target to add.
     * @return This builder for chaining.
     */
    public Builder addTarget(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureTargetIsMutable();
      target_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Target Nodes. A list of node names. The named nodes will be run by the
     * callable but their outputs will not be returned.
     * </pre>
     *
     * <code>repeated string target = 3;</code>
     * @param values The target to add.
     * @return This builder for chaining.
     */
    public Builder addAllTarget(
        java.lang.Iterable<java.lang.String> values) {
      ensureTargetIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, target_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Target Nodes. A list of node names. The named nodes will be run by the
     * callable but their outputs will not be returned.
     * </pre>
     *
     * <code>repeated string target = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearTarget() {
      target_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Target Nodes. A list of node names. The named nodes will be run by the
     * callable but their outputs will not be returned.
     * </pre>
     *
     * <code>repeated string target = 3;</code>
     * @param value The bytes of the target to add.
     * @return This builder for chaining.
     */
    public Builder addTargetBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureTargetIsMutable();
      target_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private org.tensorflow.framework.RunOptions runOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
        org.tensorflow.framework.RunOptions, org.tensorflow.framework.RunOptions.Builder, org.tensorflow.framework.RunOptionsOrBuilder> runOptionsBuilder_;
    /**
     * <pre>
     * Options that will be applied to each run.
     * </pre>
     *
     * <code>.tensorflow.RunOptions run_options = 4;</code>
     * @return Whether the runOptions field is set.
     */
    public boolean hasRunOptions() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Options that will be applied to each run.
     * </pre>
     *
     * <code>.tensorflow.RunOptions run_options = 4;</code>
     * @return The runOptions.
     */
    public org.tensorflow.framework.RunOptions getRunOptions() {
      if (runOptionsBuilder_ == null) {
        return runOptions_ == null ? org.tensorflow.framework.RunOptions.getDefaultInstance() : runOptions_;
      } else {
        return runOptionsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Options that will be applied to each run.
     * </pre>
     *
     * <code>.tensorflow.RunOptions run_options = 4;</code>
     */
    public Builder setRunOptions(org.tensorflow.framework.RunOptions value) {
      if (runOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runOptions_ = value;
      } else {
        runOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Options that will be applied to each run.
     * </pre>
     *
     * <code>.tensorflow.RunOptions run_options = 4;</code>
     */
    public Builder setRunOptions(
        org.tensorflow.framework.RunOptions.Builder builderForValue) {
      if (runOptionsBuilder_ == null) {
        runOptions_ = builderForValue.build();
      } else {
        runOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Options that will be applied to each run.
     * </pre>
     *
     * <code>.tensorflow.RunOptions run_options = 4;</code>
     */
    public Builder mergeRunOptions(org.tensorflow.framework.RunOptions value) {
      if (runOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0) &&
          runOptions_ != null &&
          runOptions_ != org.tensorflow.framework.RunOptions.getDefaultInstance()) {
          getRunOptionsBuilder().mergeFrom(value);
        } else {
          runOptions_ = value;
        }
      } else {
        runOptionsBuilder_.mergeFrom(value);
      }
      if (runOptions_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Options that will be applied to each run.
     * </pre>
     *
     * <code>.tensorflow.RunOptions run_options = 4;</code>
     */
    public Builder clearRunOptions() {
      bitField0_ = (bitField0_ & ~0x00000008);
      runOptions_ = null;
      if (runOptionsBuilder_ != null) {
        runOptionsBuilder_.dispose();
        runOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Options that will be applied to each run.
     * </pre>
     *
     * <code>.tensorflow.RunOptions run_options = 4;</code>
     */
    public org.tensorflow.framework.RunOptions.Builder getRunOptionsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRunOptionsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Options that will be applied to each run.
     * </pre>
     *
     * <code>.tensorflow.RunOptions run_options = 4;</code>
     */
    public org.tensorflow.framework.RunOptionsOrBuilder getRunOptionsOrBuilder() {
      if (runOptionsBuilder_ != null) {
        return runOptionsBuilder_.getMessageOrBuilder();
      } else {
        return runOptions_ == null ?
            org.tensorflow.framework.RunOptions.getDefaultInstance() : runOptions_;
      }
    }
    /**
     * <pre>
     * Options that will be applied to each run.
     * </pre>
     *
     * <code>.tensorflow.RunOptions run_options = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        org.tensorflow.framework.RunOptions, org.tensorflow.framework.RunOptions.Builder, org.tensorflow.framework.RunOptionsOrBuilder> 
        getRunOptionsFieldBuilder() {
      if (runOptionsBuilder_ == null) {
        runOptionsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            org.tensorflow.framework.RunOptions, org.tensorflow.framework.RunOptions.Builder, org.tensorflow.framework.RunOptionsOrBuilder>(
                getRunOptions(),
                getParentForChildren(),
                isClean());
        runOptions_ = null;
      }
      return runOptionsBuilder_;
    }

    private java.util.List<org.tensorflow.framework.TensorConnection> tensorConnection_ =
      java.util.Collections.emptyList();
    private void ensureTensorConnectionIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        tensorConnection_ = new java.util.ArrayList<org.tensorflow.framework.TensorConnection>(tensorConnection_);
        bitField0_ |= 0x00000010;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        org.tensorflow.framework.TensorConnection, org.tensorflow.framework.TensorConnection.Builder, org.tensorflow.framework.TensorConnectionOrBuilder> tensorConnectionBuilder_;

    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public java.util.List<org.tensorflow.framework.TensorConnection> getTensorConnectionList() {
      if (tensorConnectionBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tensorConnection_);
      } else {
        return tensorConnectionBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public int getTensorConnectionCount() {
      if (tensorConnectionBuilder_ == null) {
        return tensorConnection_.size();
      } else {
        return tensorConnectionBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public org.tensorflow.framework.TensorConnection getTensorConnection(int index) {
      if (tensorConnectionBuilder_ == null) {
        return tensorConnection_.get(index);
      } else {
        return tensorConnectionBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public Builder setTensorConnection(
        int index, org.tensorflow.framework.TensorConnection value) {
      if (tensorConnectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTensorConnectionIsMutable();
        tensorConnection_.set(index, value);
        onChanged();
      } else {
        tensorConnectionBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public Builder setTensorConnection(
        int index, org.tensorflow.framework.TensorConnection.Builder builderForValue) {
      if (tensorConnectionBuilder_ == null) {
        ensureTensorConnectionIsMutable();
        tensorConnection_.set(index, builderForValue.build());
        onChanged();
      } else {
        tensorConnectionBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public Builder addTensorConnection(org.tensorflow.framework.TensorConnection value) {
      if (tensorConnectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTensorConnectionIsMutable();
        tensorConnection_.add(value);
        onChanged();
      } else {
        tensorConnectionBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public Builder addTensorConnection(
        int index, org.tensorflow.framework.TensorConnection value) {
      if (tensorConnectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTensorConnectionIsMutable();
        tensorConnection_.add(index, value);
        onChanged();
      } else {
        tensorConnectionBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public Builder addTensorConnection(
        org.tensorflow.framework.TensorConnection.Builder builderForValue) {
      if (tensorConnectionBuilder_ == null) {
        ensureTensorConnectionIsMutable();
        tensorConnection_.add(builderForValue.build());
        onChanged();
      } else {
        tensorConnectionBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public Builder addTensorConnection(
        int index, org.tensorflow.framework.TensorConnection.Builder builderForValue) {
      if (tensorConnectionBuilder_ == null) {
        ensureTensorConnectionIsMutable();
        tensorConnection_.add(index, builderForValue.build());
        onChanged();
      } else {
        tensorConnectionBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public Builder addAllTensorConnection(
        java.lang.Iterable<? extends org.tensorflow.framework.TensorConnection> values) {
      if (tensorConnectionBuilder_ == null) {
        ensureTensorConnectionIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, tensorConnection_);
        onChanged();
      } else {
        tensorConnectionBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public Builder clearTensorConnection() {
      if (tensorConnectionBuilder_ == null) {
        tensorConnection_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        tensorConnectionBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public Builder removeTensorConnection(int index) {
      if (tensorConnectionBuilder_ == null) {
        ensureTensorConnectionIsMutable();
        tensorConnection_.remove(index);
        onChanged();
      } else {
        tensorConnectionBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public org.tensorflow.framework.TensorConnection.Builder getTensorConnectionBuilder(
        int index) {
      return getTensorConnectionFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public org.tensorflow.framework.TensorConnectionOrBuilder getTensorConnectionOrBuilder(
        int index) {
      if (tensorConnectionBuilder_ == null) {
        return tensorConnection_.get(index);  } else {
        return tensorConnectionBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public java.util.List<? extends org.tensorflow.framework.TensorConnectionOrBuilder> 
         getTensorConnectionOrBuilderList() {
      if (tensorConnectionBuilder_ != null) {
        return tensorConnectionBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tensorConnection_);
      }
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public org.tensorflow.framework.TensorConnection.Builder addTensorConnectionBuilder() {
      return getTensorConnectionFieldBuilder().addBuilder(
          org.tensorflow.framework.TensorConnection.getDefaultInstance());
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public org.tensorflow.framework.TensorConnection.Builder addTensorConnectionBuilder(
        int index) {
      return getTensorConnectionFieldBuilder().addBuilder(
          index, org.tensorflow.framework.TensorConnection.getDefaultInstance());
    }
    /**
     * <pre>
     * Tensors to be connected in the callable. Each TensorConnection denotes
     * a pair of tensors in the graph, between which an edge will be created
     * in the callable.
     * </pre>
     *
     * <code>repeated .tensorflow.TensorConnection tensor_connection = 5;</code>
     */
    public java.util.List<org.tensorflow.framework.TensorConnection.Builder> 
         getTensorConnectionBuilderList() {
      return getTensorConnectionFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        org.tensorflow.framework.TensorConnection, org.tensorflow.framework.TensorConnection.Builder, org.tensorflow.framework.TensorConnectionOrBuilder> 
        getTensorConnectionFieldBuilder() {
      if (tensorConnectionBuilder_ == null) {
        tensorConnectionBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            org.tensorflow.framework.TensorConnection, org.tensorflow.framework.TensorConnection.Builder, org.tensorflow.framework.TensorConnectionOrBuilder>(
                tensorConnection_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        tensorConnection_ = null;
      }
      return tensorConnectionBuilder_;
    }

    private com.google.protobuf.MapField<
        java.lang.String, java.lang.String> feedDevices_;
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetFeedDevices() {
      if (feedDevices_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            FeedDevicesDefaultEntryHolder.defaultEntry);
      }
      return feedDevices_;
    }
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableFeedDevices() {
      if (feedDevices_ == null) {
        feedDevices_ = com.google.protobuf.MapField.newMapField(
            FeedDevicesDefaultEntryHolder.defaultEntry);
      }
      if (!feedDevices_.isMutable()) {
        feedDevices_ = feedDevices_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return feedDevices_;
    }
    public int getFeedDevicesCount() {
      return internalGetFeedDevices().getMap().size();
    }
    /**
     * <pre>
     * The Tensor objects fed in the callable and fetched from the callable
     * are expected to be backed by host (CPU) memory by default.
     *
     * The options below allow changing that - feeding tensors backed by
     * device memory, or returning tensors that are backed by device memory.
     *
     * The maps below map the name of a feed/fetch tensor (which appears in
     * 'feed' or 'fetch' fields above), to the fully qualified name of the device
     * owning the memory backing the contents of the tensor.
     *
     * For example, creating a callable with the following options:
     *
     * CallableOptions {
     *   feed: "a:0"
     *   feed: "b:0"
     *
     *   fetch: "x:0"
     *   fetch: "y:0"
     *
     *   feed_devices: {
     *     "a:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *   }
     *
     *   fetch_devices: {
     *     "y:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *  }
     * }
     *
     * means that the Callable expects:
     * - The first argument ("a:0") is a Tensor backed by GPU memory.
     * - The second argument ("b:0") is a Tensor backed by host memory.
     * and of its return values:
     * - The first output ("x:0") will be backed by host memory.
     * - The second output ("y:0") will be backed by GPU memory.
     *
     * FEEDS:
     * It is the responsibility of the caller to ensure that the memory of the fed
     * tensors will be correctly initialized and synchronized before it is
     * accessed by operations executed during the call to Session::RunCallable().
     *
     * This is typically ensured by using the TensorFlow memory allocators
     * (Device::GetAllocator()) to create the Tensor to be fed.
     *
     * Alternatively, for CUDA-enabled GPU devices, this typically means that the
     * operation that produced the contents of the tensor has completed, i.e., the
     * CUDA stream has been synchronized (e.g., via cuCtxSynchronize() or
     * cuStreamSynchronize()).
     * </pre>
     *
     * <code>map&lt;string, string&gt; feed_devices = 6;</code>
     */
    @java.lang.Override
    public boolean containsFeedDevices(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      return internalGetFeedDevices().getMap().containsKey(key);
    }
    /**
     * Use {@link #getFeedDevicesMap()} instead.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getFeedDevices() {
      return getFeedDevicesMap();
    }
    /**
     * <pre>
     * The Tensor objects fed in the callable and fetched from the callable
     * are expected to be backed by host (CPU) memory by default.
     *
     * The options below allow changing that - feeding tensors backed by
     * device memory, or returning tensors that are backed by device memory.
     *
     * The maps below map the name of a feed/fetch tensor (which appears in
     * 'feed' or 'fetch' fields above), to the fully qualified name of the device
     * owning the memory backing the contents of the tensor.
     *
     * For example, creating a callable with the following options:
     *
     * CallableOptions {
     *   feed: "a:0"
     *   feed: "b:0"
     *
     *   fetch: "x:0"
     *   fetch: "y:0"
     *
     *   feed_devices: {
     *     "a:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *   }
     *
     *   fetch_devices: {
     *     "y:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *  }
     * }
     *
     * means that the Callable expects:
     * - The first argument ("a:0") is a Tensor backed by GPU memory.
     * - The second argument ("b:0") is a Tensor backed by host memory.
     * and of its return values:
     * - The first output ("x:0") will be backed by host memory.
     * - The second output ("y:0") will be backed by GPU memory.
     *
     * FEEDS:
     * It is the responsibility of the caller to ensure that the memory of the fed
     * tensors will be correctly initialized and synchronized before it is
     * accessed by operations executed during the call to Session::RunCallable().
     *
     * This is typically ensured by using the TensorFlow memory allocators
     * (Device::GetAllocator()) to create the Tensor to be fed.
     *
     * Alternatively, for CUDA-enabled GPU devices, this typically means that the
     * operation that produced the contents of the tensor has completed, i.e., the
     * CUDA stream has been synchronized (e.g., via cuCtxSynchronize() or
     * cuStreamSynchronize()).
     * </pre>
     *
     * <code>map&lt;string, string&gt; feed_devices = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getFeedDevicesMap() {
      return internalGetFeedDevices().getMap();
    }
    /**
     * <pre>
     * The Tensor objects fed in the callable and fetched from the callable
     * are expected to be backed by host (CPU) memory by default.
     *
     * The options below allow changing that - feeding tensors backed by
     * device memory, or returning tensors that are backed by device memory.
     *
     * The maps below map the name of a feed/fetch tensor (which appears in
     * 'feed' or 'fetch' fields above), to the fully qualified name of the device
     * owning the memory backing the contents of the tensor.
     *
     * For example, creating a callable with the following options:
     *
     * CallableOptions {
     *   feed: "a:0"
     *   feed: "b:0"
     *
     *   fetch: "x:0"
     *   fetch: "y:0"
     *
     *   feed_devices: {
     *     "a:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *   }
     *
     *   fetch_devices: {
     *     "y:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *  }
     * }
     *
     * means that the Callable expects:
     * - The first argument ("a:0") is a Tensor backed by GPU memory.
     * - The second argument ("b:0") is a Tensor backed by host memory.
     * and of its return values:
     * - The first output ("x:0") will be backed by host memory.
     * - The second output ("y:0") will be backed by GPU memory.
     *
     * FEEDS:
     * It is the responsibility of the caller to ensure that the memory of the fed
     * tensors will be correctly initialized and synchronized before it is
     * accessed by operations executed during the call to Session::RunCallable().
     *
     * This is typically ensured by using the TensorFlow memory allocators
     * (Device::GetAllocator()) to create the Tensor to be fed.
     *
     * Alternatively, for CUDA-enabled GPU devices, this typically means that the
     * operation that produced the contents of the tensor has completed, i.e., the
     * CUDA stream has been synchronized (e.g., via cuCtxSynchronize() or
     * cuStreamSynchronize()).
     * </pre>
     *
     * <code>map&lt;string, string&gt; feed_devices = 6;</code>
     */
    @java.lang.Override
    public /* nullable */
java.lang.String getFeedDevicesOrDefault(
        java.lang.String key,
        /* nullable */
java.lang.String defaultValue) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetFeedDevices().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * The Tensor objects fed in the callable and fetched from the callable
     * are expected to be backed by host (CPU) memory by default.
     *
     * The options below allow changing that - feeding tensors backed by
     * device memory, or returning tensors that are backed by device memory.
     *
     * The maps below map the name of a feed/fetch tensor (which appears in
     * 'feed' or 'fetch' fields above), to the fully qualified name of the device
     * owning the memory backing the contents of the tensor.
     *
     * For example, creating a callable with the following options:
     *
     * CallableOptions {
     *   feed: "a:0"
     *   feed: "b:0"
     *
     *   fetch: "x:0"
     *   fetch: "y:0"
     *
     *   feed_devices: {
     *     "a:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *   }
     *
     *   fetch_devices: {
     *     "y:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *  }
     * }
     *
     * means that the Callable expects:
     * - The first argument ("a:0") is a Tensor backed by GPU memory.
     * - The second argument ("b:0") is a Tensor backed by host memory.
     * and of its return values:
     * - The first output ("x:0") will be backed by host memory.
     * - The second output ("y:0") will be backed by GPU memory.
     *
     * FEEDS:
     * It is the responsibility of the caller to ensure that the memory of the fed
     * tensors will be correctly initialized and synchronized before it is
     * accessed by operations executed during the call to Session::RunCallable().
     *
     * This is typically ensured by using the TensorFlow memory allocators
     * (Device::GetAllocator()) to create the Tensor to be fed.
     *
     * Alternatively, for CUDA-enabled GPU devices, this typically means that the
     * operation that produced the contents of the tensor has completed, i.e., the
     * CUDA stream has been synchronized (e.g., via cuCtxSynchronize() or
     * cuStreamSynchronize()).
     * </pre>
     *
     * <code>map&lt;string, string&gt; feed_devices = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getFeedDevicesOrThrow(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetFeedDevices().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }
    public Builder clearFeedDevices() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableFeedDevices().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * The Tensor objects fed in the callable and fetched from the callable
     * are expected to be backed by host (CPU) memory by default.
     *
     * The options below allow changing that - feeding tensors backed by
     * device memory, or returning tensors that are backed by device memory.
     *
     * The maps below map the name of a feed/fetch tensor (which appears in
     * 'feed' or 'fetch' fields above), to the fully qualified name of the device
     * owning the memory backing the contents of the tensor.
     *
     * For example, creating a callable with the following options:
     *
     * CallableOptions {
     *   feed: "a:0"
     *   feed: "b:0"
     *
     *   fetch: "x:0"
     *   fetch: "y:0"
     *
     *   feed_devices: {
     *     "a:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *   }
     *
     *   fetch_devices: {
     *     "y:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *  }
     * }
     *
     * means that the Callable expects:
     * - The first argument ("a:0") is a Tensor backed by GPU memory.
     * - The second argument ("b:0") is a Tensor backed by host memory.
     * and of its return values:
     * - The first output ("x:0") will be backed by host memory.
     * - The second output ("y:0") will be backed by GPU memory.
     *
     * FEEDS:
     * It is the responsibility of the caller to ensure that the memory of the fed
     * tensors will be correctly initialized and synchronized before it is
     * accessed by operations executed during the call to Session::RunCallable().
     *
     * This is typically ensured by using the TensorFlow memory allocators
     * (Device::GetAllocator()) to create the Tensor to be fed.
     *
     * Alternatively, for CUDA-enabled GPU devices, this typically means that the
     * operation that produced the contents of the tensor has completed, i.e., the
     * CUDA stream has been synchronized (e.g., via cuCtxSynchronize() or
     * cuStreamSynchronize()).
     * </pre>
     *
     * <code>map&lt;string, string&gt; feed_devices = 6;</code>
     */
    public Builder removeFeedDevices(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      internalGetMutableFeedDevices().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String>
        getMutableFeedDevices() {
      bitField0_ |= 0x00000020;
      return internalGetMutableFeedDevices().getMutableMap();
    }
    /**
     * <pre>
     * The Tensor objects fed in the callable and fetched from the callable
     * are expected to be backed by host (CPU) memory by default.
     *
     * The options below allow changing that - feeding tensors backed by
     * device memory, or returning tensors that are backed by device memory.
     *
     * The maps below map the name of a feed/fetch tensor (which appears in
     * 'feed' or 'fetch' fields above), to the fully qualified name of the device
     * owning the memory backing the contents of the tensor.
     *
     * For example, creating a callable with the following options:
     *
     * CallableOptions {
     *   feed: "a:0"
     *   feed: "b:0"
     *
     *   fetch: "x:0"
     *   fetch: "y:0"
     *
     *   feed_devices: {
     *     "a:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *   }
     *
     *   fetch_devices: {
     *     "y:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *  }
     * }
     *
     * means that the Callable expects:
     * - The first argument ("a:0") is a Tensor backed by GPU memory.
     * - The second argument ("b:0") is a Tensor backed by host memory.
     * and of its return values:
     * - The first output ("x:0") will be backed by host memory.
     * - The second output ("y:0") will be backed by GPU memory.
     *
     * FEEDS:
     * It is the responsibility of the caller to ensure that the memory of the fed
     * tensors will be correctly initialized and synchronized before it is
     * accessed by operations executed during the call to Session::RunCallable().
     *
     * This is typically ensured by using the TensorFlow memory allocators
     * (Device::GetAllocator()) to create the Tensor to be fed.
     *
     * Alternatively, for CUDA-enabled GPU devices, this typically means that the
     * operation that produced the contents of the tensor has completed, i.e., the
     * CUDA stream has been synchronized (e.g., via cuCtxSynchronize() or
     * cuStreamSynchronize()).
     * </pre>
     *
     * <code>map&lt;string, string&gt; feed_devices = 6;</code>
     */
    public Builder putFeedDevices(
        java.lang.String key,
        java.lang.String value) {
      if (key == null) { throw new NullPointerException("map key"); }
      if (value == null) { throw new NullPointerException("map value"); }
      internalGetMutableFeedDevices().getMutableMap()
          .put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     * <pre>
     * The Tensor objects fed in the callable and fetched from the callable
     * are expected to be backed by host (CPU) memory by default.
     *
     * The options below allow changing that - feeding tensors backed by
     * device memory, or returning tensors that are backed by device memory.
     *
     * The maps below map the name of a feed/fetch tensor (which appears in
     * 'feed' or 'fetch' fields above), to the fully qualified name of the device
     * owning the memory backing the contents of the tensor.
     *
     * For example, creating a callable with the following options:
     *
     * CallableOptions {
     *   feed: "a:0"
     *   feed: "b:0"
     *
     *   fetch: "x:0"
     *   fetch: "y:0"
     *
     *   feed_devices: {
     *     "a:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *   }
     *
     *   fetch_devices: {
     *     "y:0": "/job:localhost/replica:0/task:0/device:GPU:0"
     *  }
     * }
     *
     * means that the Callable expects:
     * - The first argument ("a:0") is a Tensor backed by GPU memory.
     * - The second argument ("b:0") is a Tensor backed by host memory.
     * and of its return values:
     * - The first output ("x:0") will be backed by host memory.
     * - The second output ("y:0") will be backed by GPU memory.
     *
     * FEEDS:
     * It is the responsibility of the caller to ensure that the memory of the fed
     * tensors will be correctly initialized and synchronized before it is
     * accessed by operations executed during the call to Session::RunCallable().
     *
     * This is typically ensured by using the TensorFlow memory allocators
     * (Device::GetAllocator()) to create the Tensor to be fed.
     *
     * Alternatively, for CUDA-enabled GPU devices, this typically means that the
     * operation that produced the contents of the tensor has completed, i.e., the
     * CUDA stream has been synchronized (e.g., via cuCtxSynchronize() or
     * cuStreamSynchronize()).
     * </pre>
     *
     * <code>map&lt;string, string&gt; feed_devices = 6;</code>
     */
    public Builder putAllFeedDevices(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableFeedDevices().getMutableMap()
          .putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, java.lang.String> fetchDevices_;
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetFetchDevices() {
      if (fetchDevices_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            FetchDevicesDefaultEntryHolder.defaultEntry);
      }
      return fetchDevices_;
    }
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableFetchDevices() {
      if (fetchDevices_ == null) {
        fetchDevices_ = com.google.protobuf.MapField.newMapField(
            FetchDevicesDefaultEntryHolder.defaultEntry);
      }
      if (!fetchDevices_.isMutable()) {
        fetchDevices_ = fetchDevices_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return fetchDevices_;
    }
    public int getFetchDevicesCount() {
      return internalGetFetchDevices().getMap().size();
    }
    /**
     * <code>map&lt;string, string&gt; fetch_devices = 7;</code>
     */
    @java.lang.Override
    public boolean containsFetchDevices(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      return internalGetFetchDevices().getMap().containsKey(key);
    }
    /**
     * Use {@link #getFetchDevicesMap()} instead.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getFetchDevices() {
      return getFetchDevicesMap();
    }
    /**
     * <code>map&lt;string, string&gt; fetch_devices = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getFetchDevicesMap() {
      return internalGetFetchDevices().getMap();
    }
    /**
     * <code>map&lt;string, string&gt; fetch_devices = 7;</code>
     */
    @java.lang.Override
    public /* nullable */
java.lang.String getFetchDevicesOrDefault(
        java.lang.String key,
        /* nullable */
java.lang.String defaultValue) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetFetchDevices().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <code>map&lt;string, string&gt; fetch_devices = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getFetchDevicesOrThrow(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetFetchDevices().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }
    public Builder clearFetchDevices() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableFetchDevices().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <code>map&lt;string, string&gt; fetch_devices = 7;</code>
     */
    public Builder removeFetchDevices(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      internalGetMutableFetchDevices().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String>
        getMutableFetchDevices() {
      bitField0_ |= 0x00000040;
      return internalGetMutableFetchDevices().getMutableMap();
    }
    /**
     * <code>map&lt;string, string&gt; fetch_devices = 7;</code>
     */
    public Builder putFetchDevices(
        java.lang.String key,
        java.lang.String value) {
      if (key == null) { throw new NullPointerException("map key"); }
      if (value == null) { throw new NullPointerException("map value"); }
      internalGetMutableFetchDevices().getMutableMap()
          .put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     * <code>map&lt;string, string&gt; fetch_devices = 7;</code>
     */
    public Builder putAllFetchDevices(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableFetchDevices().getMutableMap()
          .putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private boolean fetchSkipSync_ ;
    /**
     * <pre>
     * By default, RunCallable() will synchronize the GPU stream before returning
     * fetched tensors on a GPU device, to ensure that the values in those tensors
     * have been produced. This simplifies interacting with the tensors, but
     * potentially incurs a performance hit.
     *
     * If this options is set to true, the caller is responsible for ensuring
     * that the values in the fetched tensors have been produced before they are
     * used. The caller can do this by invoking `Device::Sync()` on the underlying
     * device(s), or by feeding the tensors back to the same Session using
     * `feed_devices` with the same corresponding device name.
     * </pre>
     *
     * <code>bool fetch_skip_sync = 8;</code>
     * @return The fetchSkipSync.
     */
    @java.lang.Override
    public boolean getFetchSkipSync() {
      return fetchSkipSync_;
    }
    /**
     * <pre>
     * By default, RunCallable() will synchronize the GPU stream before returning
     * fetched tensors on a GPU device, to ensure that the values in those tensors
     * have been produced. This simplifies interacting with the tensors, but
     * potentially incurs a performance hit.
     *
     * If this options is set to true, the caller is responsible for ensuring
     * that the values in the fetched tensors have been produced before they are
     * used. The caller can do this by invoking `Device::Sync()` on the underlying
     * device(s), or by feeding the tensors back to the same Session using
     * `feed_devices` with the same corresponding device name.
     * </pre>
     *
     * <code>bool fetch_skip_sync = 8;</code>
     * @param value The fetchSkipSync to set.
     * @return This builder for chaining.
     */
    public Builder setFetchSkipSync(boolean value) {

      fetchSkipSync_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * By default, RunCallable() will synchronize the GPU stream before returning
     * fetched tensors on a GPU device, to ensure that the values in those tensors
     * have been produced. This simplifies interacting with the tensors, but
     * potentially incurs a performance hit.
     *
     * If this options is set to true, the caller is responsible for ensuring
     * that the values in the fetched tensors have been produced before they are
     * used. The caller can do this by invoking `Device::Sync()` on the underlying
     * device(s), or by feeding the tensors back to the same Session using
     * `feed_devices` with the same corresponding device name.
     * </pre>
     *
     * <code>bool fetch_skip_sync = 8;</code>
     * @return This builder for chaining.
     */
    public Builder clearFetchSkipSync() {
      bitField0_ = (bitField0_ & ~0x00000080);
      fetchSkipSync_ = false;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:tensorflow.CallableOptions)
  }

  // @@protoc_insertion_point(class_scope:tensorflow.CallableOptions)
  private static final org.tensorflow.framework.CallableOptions DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new org.tensorflow.framework.CallableOptions();
  }

  public static org.tensorflow.framework.CallableOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CallableOptions>
      PARSER = new com.google.protobuf.AbstractParser<CallableOptions>() {
    @java.lang.Override
    public CallableOptions parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<CallableOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CallableOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.tensorflow.framework.CallableOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

