/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.telemetry.Tracer;

public class WrapPollsInterceptStrategy
implements InterceptStrategy {
    private Tracer tracer;

    public WrapPollsInterceptStrategy(Tracer tracer) {
        this.tracer = tracer;
    }

    public Processor wrapProcessorInInterceptors(CamelContext camelContext, NamedNode processorDefinition, Processor target, Processor nextTarget) throws Exception {
        return new DelegateAsyncProcessor((Processor)new TraceProcessor(target, processorDefinition));
    }

    private class TraceProcessor
    implements Processor {
        private final NamedNode processorDefinition;
        private final Processor target;

        public TraceProcessor(Processor target, NamedNode processorDefinition) {
            this.target = target;
            this.processorDefinition = processorDefinition;
        }

        public void process(Exchange exchange) throws Exception {
            String processor = this.processorDefinition.getId() + "-" + this.processorDefinition.getShortName();
            if (!WrapPollsInterceptStrategy.this.tracer.exclude(processor, exchange.getContext())) {
                this.target.process(exchange);
            }
        }
    }
}

