/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry.decorators;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.telemetry.Span;
import org.apache.camel.telemetry.decorators.AbstractHttpSpanDecorator;

public class RestSpanDecorator
extends AbstractHttpSpanDecorator {
    @Override
    public String getComponent() {
        return "rest";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.rest.RestComponent";
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        return RestSpanDecorator.clipMaxLength(RestSpanDecorator.getPath(endpoint.getEndpointUri()));
    }

    @Override
    public void beforeTracingEvent(Span span, Exchange exchange, Endpoint endpoint) {
        super.beforeTracingEvent(span, exchange, endpoint);
        RestSpanDecorator.getParameters(RestSpanDecorator.getPath(endpoint.getEndpointUri())).forEach(param -> {
            String val = (String)exchange.getIn().getHeader(param, String.class);
            if (val != null) {
                span.setTag((String)param, val);
            }
        });
    }

    protected static String getPath(String uri) {
        String path = null;
        int index = uri.indexOf(58);
        if (index != -1 && (index = uri.indexOf(58, index + 1)) != -1) {
            path = uri.substring(index + 1);
            if ((index = path.indexOf(63)) != -1) {
                path = path.substring(0, index);
            }
            path = path.replace(":", "");
            path = URLDecoder.decode(path, StandardCharsets.UTF_8);
        }
        return path;
    }

    protected static List<String> getParameters(String path) {
        ArrayList<String> parameters = null;
        int startIndex = path.indexOf(123);
        while (startIndex != -1) {
            int endIndex = path.indexOf(125, startIndex);
            if (endIndex != -1) {
                if (parameters == null) {
                    parameters = new ArrayList<String>();
                }
                parameters.add(path.substring(startIndex + 1, endIndex));
                startIndex = path.indexOf(123, endIndex);
                continue;
            }
            startIndex = -1;
        }
        return parameters == null ? Collections.emptyList() : parameters;
    }
}

