/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry.decorators;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.telemetry.Span;
import org.apache.camel.telemetry.decorators.AbstractSpanDecorator;

public class ElasticsearchSpanDecorator
extends AbstractSpanDecorator {
    public static final String ELASTICSEARCH_DB_TYPE = "elasticsearch";

    @Override
    public String getComponent() {
        return ELASTICSEARCH_DB_TYPE;
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.es.ElasticsearchComponent";
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        Map<String, String> queryParameters = ElasticsearchSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
        String answer = queryParameters.containsKey("operation") ? queryParameters.get("operation") : super.getOperationName(exchange, endpoint);
        return ElasticsearchSpanDecorator.clipMaxLength(answer);
    }

    @Override
    public void beforeTracingEvent(Span span, Exchange exchange, Endpoint endpoint) {
        super.beforeTracingEvent(span, exchange, endpoint);
        span.setTag("db.system", ELASTICSEARCH_DB_TYPE);
        Map<String, String> queryParameters = ElasticsearchSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
        if (queryParameters.containsKey("indexName")) {
            span.setTag("db.name", queryParameters.get("indexName"));
        }
    }
}

