/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import org.apache.camel.component.telegram.model.IncomingMessage;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MessageResult
implements Serializable {
    private static final long serialVersionUID = -4560342931918215225L;
    private boolean ok;
    private IncomingMessage message;
    private boolean result;

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public IncomingMessage getMessage() {
        return this.message;
    }

    public void setMessage(IncomingMessage message) {
        this.message = message;
    }

    @JsonSetter(value="result")
    public void setResult(JsonNode result) throws JsonProcessingException {
        if (result != null) {
            if (result.isBoolean()) {
                this.result = result.asBoolean();
            } else if (result.isObject()) {
                ObjectMapper objectMapper = new ObjectMapper();
                this.message = (IncomingMessage)objectMapper.treeToValue((TreeNode)result, IncomingMessage.class);
            }
        }
    }

    public boolean isResult() {
        return this.result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MessageResult{");
        sb.append("ok=").append(this.ok);
        sb.append(", message=").append(this.message);
        sb.append('}');
        return sb.toString();
    }
}

