/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultVoice
extends InlineQueryResult {
    private static final String TYPE = "voice";
    @JsonProperty(value="voice_url")
    private String voiceUrl;
    @JsonProperty(value="voice_duration")
    private Integer voiceDuration;
    private String title;
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContext;

    public InlineQueryResultVoice() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVoiceUrl() {
        return this.voiceUrl;
    }

    public Integer getVoiceDuration() {
        return this.voiceDuration;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputMessageContent getInputMessageContext() {
        return this.inputMessageContext;
    }

    public void setVoiceUrl(String voiceUrl) {
        this.voiceUrl = voiceUrl;
    }

    public void setVoiceDuration(Integer voiceDuration) {
        this.voiceDuration = voiceDuration;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setInputMessageContext(InputMessageContent inputMessageContext) {
        this.inputMessageContext = inputMessageContext;
    }

    public static final class Builder {
        private String id;
        private InlineKeyboardMarkup replyMarkup;
        private String voiceUrl;
        private Integer voiceDuration;
        private String title;
        private String caption;
        private String parseMode;
        private InputMessageContent inputMessageContext;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder voiceUrl(String voiceUrl) {
            this.voiceUrl = voiceUrl;
            return this;
        }

        public Builder voiceDuration(Integer voiceDuration) {
            this.voiceDuration = voiceDuration;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public Builder inputMessageContext(InputMessageContent inputMessageContext) {
            this.inputMessageContext = inputMessageContext;
            return this;
        }

        public InlineQueryResultVoice build() {
            InlineQueryResultVoice inlineQueryResultVoice = new InlineQueryResultVoice();
            inlineQueryResultVoice.setType(InlineQueryResultVoice.TYPE);
            inlineQueryResultVoice.setId(this.id);
            inlineQueryResultVoice.setReplyMarkup(this.replyMarkup);
            inlineQueryResultVoice.inputMessageContext = this.inputMessageContext;
            inlineQueryResultVoice.voiceDuration = this.voiceDuration;
            inlineQueryResultVoice.voiceUrl = this.voiceUrl;
            inlineQueryResultVoice.title = this.title;
            inlineQueryResultVoice.parseMode = this.parseMode;
            inlineQueryResultVoice.caption = this.caption;
            return inlineQueryResultVoice;
        }
    }
}

