/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.telegram.model.MessageResult;
import org.apache.camel.component.telegram.model.OutgoingMessage;
import org.apache.camel.component.telegram.service.TelegramAsyncHandler;
import org.apache.camel.component.telegram.service.TelegramBodyPublisher;

abstract class OutgoingMessageHandler<T extends OutgoingMessage> {
    protected final ObjectMapper mapper;
    protected final TelegramBodyPublisher bodyPublisher;
    private final HttpClient client;
    private final String contentType;
    private final String uri;
    private final Class<? extends MessageResult> resultClass;

    public OutgoingMessageHandler(HttpClient client, ObjectMapper mapper, String uri, String contentType, Class<? extends MessageResult> resultClass, int bufferSize) {
        this.client = client;
        this.mapper = mapper;
        this.uri = uri;
        this.contentType = contentType;
        this.resultClass = resultClass;
        this.bodyPublisher = new TelegramBodyPublisher(bufferSize);
    }

    public void sendMessage(Exchange exchange, AsyncCallback callback, T message) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(this.uri));
        this.addBody(message);
        if (this.bodyPublisher.getBodyParts().size() > 1) {
            builder.setHeader("Content-type", "multipart/form-data; boundary=\"" + this.bodyPublisher.getBoundary() + "\"");
        } else if (this.contentType != null) {
            builder.setHeader("Content-type", this.contentType);
        }
        builder.setHeader("Accept", "application/json");
        builder.POST(this.bodyPublisher.newPublisher());
        try {
            TelegramAsyncHandler telegramAsyncHandler = new TelegramAsyncHandler(this.uri, this.resultClass, this.mapper, exchange, callback);
            ((CompletableFuture)this.client.sendAsync(builder.build(), HttpResponse.BodyHandlers.ofInputStream()).thenApply(telegramAsyncHandler::handleCompressedResponse)).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void addBody(T var1);

    protected void fillCommonMediaParts(OutgoingMessage message) {
        this.buildTextPart("chat_id", message.getChatId());
        this.buildTextPart("reply_to_message_id", message.getReplyToMessageId());
        this.buildTextPart("disable_notification", message.getDisableNotification());
    }

    protected <T> void buildTextPart(String name, T value) {
        OutgoingMessageHandler.buildTextPart(this.bodyPublisher, name, value);
    }

    static <T> void buildTextPart(TelegramBodyPublisher bodyPublisher, String name, T value) {
        if (value != null) {
            TelegramBodyPublisher.MultilineBodyPart<T> bodyPart = new TelegramBodyPublisher.MultilineBodyPart<T>(name, value, "text/plain");
            bodyPublisher.addBodyPart(bodyPart);
        }
    }

    protected void buildMediaPart(String name, String fileNameWithExtension, byte[] value) {
        this.buildMediaPart(this.bodyPublisher, name, fileNameWithExtension, value);
    }

    void buildMediaPart(TelegramBodyPublisher bodyPublisher, String name, String fileNameWithExtension, byte[] value) {
        TelegramBodyPublisher.MultilineBodyPart<byte[]> bodyPart = new TelegramBodyPublisher.MultilineBodyPart<byte[]>(name, value, "application/octet-stream", null);
        bodyPart.addHeader("filename", fileNameWithExtension);
        bodyPublisher.addBodyPart(bodyPart);
    }
}

