/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram;

import org.apache.camel.spi.Metadata;

public final class TelegramConstants {
    @Metadata(label="producer", description="This header is used by the producer endpoint in order to\nresolve the chat id that will receive the message. The recipient chat id can be\nplaced (in order of priority) in message body, in the `CamelTelegramChatId` header\nor in the endpoint configuration (`chatId` option).\nThis header is also present in all incoming messages.", javaType="Object")
    public static final String TELEGRAM_CHAT_ID = "CamelTelegramChatId";
    @Metadata(description="This header is used to identify the media type when\nthe outgoing message is composed of pure binary data. Possible values are strings or enum values\nbelonging to the `org.apache.camel.component.telegram.TelegramMediaType` enumeration.", javaType="org.apache.camel.component.telegram.TelegramMediaType or String")
    public static final String TELEGRAM_MEDIA_TYPE = "CamelTelegramMediaType";
    @Metadata(description="This header is used to provide a caption or title\nfor outgoing binary messages.", javaType="String")
    public static final String TELEGRAM_MEDIA_TITLE_CAPTION = "CamelTelegramMediaTitleCaption";
    @Metadata(description="The reply markup.", javaType="org.apache.camel.component.telegram.model.ReplyMarkup")
    public static final String TELEGRAM_MEDIA_MARKUP = "CamelTelegramMediaMarkup";
    @Metadata(description="This header is used to format text messages using HTML or Markdown", javaType="org.apache.camel.component.telegram.TelegramParseMode")
    public static final String TELEGRAM_PARSE_MODE = "CamelTelegramParseMode";
    @Metadata(description="The message timestamp.", javaType="long")
    public static final String MESSAGE_TIMESTAMP = "CamelMessageTimestamp";

    private TelegramConstants() {
    }
}

