/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultCachedSticker
extends InlineQueryResult {
    private static final String TYPE = "sticker";
    @JsonProperty(value="sticker_file_id")
    private String stickerFileId;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContext;

    public InlineQueryResultCachedSticker() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStickerFileId() {
        return this.stickerFileId;
    }

    public InputMessageContent getInputMessageContext() {
        return this.inputMessageContext;
    }

    public void setStickerFileId(String stickerFileId) {
        this.stickerFileId = stickerFileId;
    }

    public void setInputMessageContext(InputMessageContent inputMessageContext) {
        this.inputMessageContext = inputMessageContext;
    }

    public static final class Builder {
        private String id;
        private String stickerFileId;
        private InlineKeyboardMarkup replyMarkup;
        private InputMessageContent inputMessageContext;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder stickerFileId(String stickerFileId) {
            this.stickerFileId = stickerFileId;
            return this;
        }

        public Builder inputMessageContext(InputMessageContent inputMessageContext) {
            this.inputMessageContext = inputMessageContext;
            return this;
        }

        public InlineQueryResultCachedSticker build() {
            InlineQueryResultCachedSticker inlineQueryResultDocument = new InlineQueryResultCachedSticker();
            inlineQueryResultDocument.setType(InlineQueryResultCachedSticker.TYPE);
            inlineQueryResultDocument.setId(this.id);
            inlineQueryResultDocument.setReplyMarkup(this.replyMarkup);
            inlineQueryResultDocument.inputMessageContext = this.inputMessageContext;
            inlineQueryResultDocument.stickerFileId = this.stickerFileId;
            return inlineQueryResultDocument;
        }
    }
}

