/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultCachedPhoto
extends InlineQueryResult {
    private static final String TYPE = "photo";
    @JsonProperty(value="photo_file_id")
    private String photoFileId;
    private String title;
    private String description;
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContext;

    public InlineQueryResultCachedPhoto() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPhotoFileId() {
        return this.photoFileId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputMessageContent getInputMessageContext() {
        return this.inputMessageContext;
    }

    public void setPhotoFileId(String photoFileId) {
        this.photoFileId = photoFileId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setInputMessageContext(InputMessageContent inputMessageContext) {
        this.inputMessageContext = inputMessageContext;
    }

    public static final class Builder {
        private String id;
        private InlineKeyboardMarkup replyMarkup;
        private String photoFileId;
        private String title;
        private String description;
        private String caption;
        private String parseMode;
        private InputMessageContent inputMessageContext;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder photoFileId(String photoFileId) {
            this.photoFileId = photoFileId;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public Builder inputMessageContext(InputMessageContent inputMessageContext) {
            this.inputMessageContext = inputMessageContext;
            return this;
        }

        public InlineQueryResultCachedPhoto build() {
            InlineQueryResultCachedPhoto inlineQueryResultPhoto = new InlineQueryResultCachedPhoto();
            inlineQueryResultPhoto.setType(InlineQueryResultCachedPhoto.TYPE);
            inlineQueryResultPhoto.setId(this.id);
            inlineQueryResultPhoto.setReplyMarkup(this.replyMarkup);
            inlineQueryResultPhoto.inputMessageContext = this.inputMessageContext;
            inlineQueryResultPhoto.description = this.description;
            inlineQueryResultPhoto.photoFileId = this.photoFileId;
            inlineQueryResultPhoto.caption = this.caption;
            inlineQueryResultPhoto.title = this.title;
            inlineQueryResultPhoto.parseMode = this.parseMode;
            return inlineQueryResultPhoto;
        }
    }
}

