/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.telegram.TelegramService;
import org.apache.camel.component.telegram.model.EditMessageCaptionMessage;
import org.apache.camel.component.telegram.model.EditMessageDelete;
import org.apache.camel.component.telegram.model.EditMessageLiveLocationMessage;
import org.apache.camel.component.telegram.model.EditMessageMediaMessage;
import org.apache.camel.component.telegram.model.EditMessageReplyMarkupMessage;
import org.apache.camel.component.telegram.model.EditMessageTextMessage;
import org.apache.camel.component.telegram.model.MessageResult;
import org.apache.camel.component.telegram.model.MessageResultGameScores;
import org.apache.camel.component.telegram.model.OutgoingAnswerInlineQuery;
import org.apache.camel.component.telegram.model.OutgoingAudioMessage;
import org.apache.camel.component.telegram.model.OutgoingCallbackQueryMessage;
import org.apache.camel.component.telegram.model.OutgoingDocumentMessage;
import org.apache.camel.component.telegram.model.OutgoingGameMessage;
import org.apache.camel.component.telegram.model.OutgoingGetGameHighScoresMessage;
import org.apache.camel.component.telegram.model.OutgoingMessage;
import org.apache.camel.component.telegram.model.OutgoingPhotoMessage;
import org.apache.camel.component.telegram.model.OutgoingSetGameScoreMessage;
import org.apache.camel.component.telegram.model.OutgoingStickerMessage;
import org.apache.camel.component.telegram.model.OutgoingTextMessage;
import org.apache.camel.component.telegram.model.OutgoingVideoMessage;
import org.apache.camel.component.telegram.model.SendLocationMessage;
import org.apache.camel.component.telegram.model.SendVenueMessage;
import org.apache.camel.component.telegram.model.StopMessageLiveLocationMessage;
import org.apache.camel.component.telegram.model.UpdateResult;
import org.apache.camel.component.telegram.model.WebhookInfo;
import org.apache.camel.component.telegram.model.WebhookResult;
import org.apache.camel.support.GZIPHelper;
import org.apache.camel.util.IOHelper;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.multipart.ByteArrayPart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.StringPart;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.MiscUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelegramServiceRestBotAPIAdapter
implements TelegramService {
    private static final Logger LOG = LoggerFactory.getLogger(TelegramServiceRestBotAPIAdapter.class);
    private final Map<Class<?>, OutgoingMessageHandler<?>> handlers;
    private final AsyncHttpClient asyncHttpClient;
    private final ObjectMapper mapper;
    private final String baseUri;

    public TelegramServiceRestBotAPIAdapter(AsyncHttpClient asyncHttpClient, int bufferSize, String telegramBaseUri, String authorizationToken) {
        this.asyncHttpClient = asyncHttpClient;
        this.baseUri = telegramBaseUri + "/bot" + authorizationToken;
        this.mapper = new ObjectMapper();
        HashMap m = new HashMap();
        m.put(OutgoingTextMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/sendMessage"));
        m.put(OutgoingPhotoMessage.class, new OutgoingPhotoMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri));
        m.put(OutgoingAudioMessage.class, new OutgoingAudioMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri));
        m.put(OutgoingVideoMessage.class, new OutgoingVideoMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri));
        m.put(OutgoingDocumentMessage.class, new OutgoingDocumentMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri));
        m.put(OutgoingStickerMessage.class, new OutgoingStickerMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri));
        m.put(OutgoingGameMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/sendGame"));
        m.put(SendLocationMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/sendLocation"));
        m.put(EditMessageLiveLocationMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/editMessageLiveLocation"));
        m.put(StopMessageLiveLocationMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/stopMessageLiveLocation"));
        m.put(SendVenueMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/sendVenue"));
        m.put(EditMessageTextMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/editMessageText"));
        m.put(EditMessageCaptionMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/editMessageCaption"));
        m.put(EditMessageMediaMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/editMessageMedia"));
        m.put(EditMessageDelete.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/deleteMessage"));
        m.put(EditMessageReplyMarkupMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/editMessageReplyMarkup"));
        m.put(OutgoingCallbackQueryMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/answerCallbackQuery"));
        m.put(OutgoingSetGameScoreMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/setGameScore"));
        m.put(OutgoingGetGameHighScoresMessage.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/getGameHighScores", MessageResultGameScores.class));
        m.put(OutgoingAnswerInlineQuery.class, new OutgoingPlainMessageHandler(asyncHttpClient, bufferSize, this.mapper, this.baseUri + "/answerInlineQuery"));
        this.handlers = m;
    }

    @Override
    public UpdateResult getUpdates(Long offset, Integer limit, Integer timeoutSeconds) {
        String uri = this.baseUri + "/getUpdates";
        RequestBuilder request = (RequestBuilder)new RequestBuilder("GET").setUrl(uri);
        if (offset != null) {
            request.addQueryParam("offset", String.valueOf(offset));
        }
        if (limit != null) {
            request.addQueryParam("limit", String.valueOf(limit));
        }
        if (timeoutSeconds != null) {
            request.addQueryParam("timeout", String.valueOf(timeoutSeconds));
        }
        return this.sendSyncRequest(request.build(), UpdateResult.class);
    }

    <T> T sendSyncRequest(Request request, Class<T> resultType) {
        try {
            Response response = (Response)this.asyncHttpClient.executeRequest(request).get();
            int code = response.getStatusCode();
            if (code >= 200 && code < 300) {
                try {
                    String responseBody = response.getResponseBody();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Received body for {} {}: {}", new Object[]{request.getMethod(), request.getUrl(), responseBody});
                    }
                    return (T)this.mapper.readValue(responseBody, resultType);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse the response from " + request.getMethod() + " " + request.getUrl(), e);
                }
            }
            throw new RuntimeException("Could not " + request.getMethod() + " " + request.getUrl() + ": " + response.getStatusCode() + " " + response.getStatusText());
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Could not request " + request.getMethod() + " " + request.getUrl(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean setWebhook(String url) {
        String uri = this.baseUri + "/setWebhook";
        RequestBuilder request = (RequestBuilder)new RequestBuilder("POST").setUrl(uri);
        WebhookInfo message = new WebhookInfo(url);
        try {
            String body = this.mapper.writeValueAsString((Object)message);
            request.setBody(body);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not serialize " + message);
        }
        WebhookResult res = this.sendSyncRequest(request.build(), WebhookResult.class);
        return res.isOk() && res.isResult();
    }

    @Override
    public boolean removeWebhook() {
        return this.setWebhook("");
    }

    @Override
    public void sendMessage(Exchange exchange, AsyncCallback callback, OutgoingMessage message) {
        OutgoingMessageHandler<?> handler = this.handlers.get(message.getClass());
        if (handler == null) {
            throw new IllegalArgumentException("Unsupported message type " + message.getClass().getName());
        }
        handler.sendMessage(exchange, callback, message);
    }

    private static final class TelegramAsyncHandler
    implements AsyncHandler<Exchange> {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final String url;
        private final ByteArrayOutputStream os;
        private final ObjectMapper mapper;
        private int statusCode;
        private String statusText;
        private String contentType;
        private String contentEncoding;
        private Charset charset;
        private Class<? extends MessageResult> onCompletedType;

        private TelegramAsyncHandler(Exchange exchange, AsyncCallback callback, String url, int bufferSize, ObjectMapper mapper, Class<? extends MessageResult> onCompletedType) {
            this.onCompletedType = onCompletedType;
            this.exchange = exchange;
            this.callback = callback;
            this.url = url;
            this.os = new ByteArrayOutputStream(bufferSize);
            this.mapper = mapper;
        }

        public void onThrowable(Throwable t) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} onThrowable {}", new Object[]{this.exchange.getExchangeId(), t.getMessage(), t});
            }
            this.exchange.setException(t);
            this.callback.done(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exchange onCompleted() throws Exception {
            block47: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} onCompleted", (Object)this.exchange.getExchangeId());
                }
                try {
                    this.os.flush();
                    this.os.close();
                    boolean success = this.statusCode >= 200 && this.statusCode < 300;
                    try (ByteArrayInputStream maybeGzStream = new ByteArrayInputStream(this.os.toByteArray());
                         InputStream is = GZIPHelper.uncompressGzip((String)this.contentEncoding, (InputStream)maybeGzStream);
                         InputStreamReader r = new InputStreamReader(is, this.charset);){
                        if (success) {
                            Object result;
                            if (LOG.isTraceEnabled()) {
                                String body = IOHelper.toString((Reader)r);
                                LOG.trace("Received body for {}: {}", (Object)this.url, (Object)body);
                                result = this.mapper.readValue(body, this.onCompletedType);
                            } else {
                                result = this.mapper.readValue((Reader)r, this.onCompletedType);
                            }
                            this.exchange.getMessage().setBody(result);
                            break block47;
                        }
                        throw new RuntimeException(this.url + " responded: " + this.statusCode + " " + this.statusText + " " + IOHelper.toString((Reader)r));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not parse the response from " + this.url, e);
                    }
                }
                catch (Exception e) {
                    this.exchange.setException((Throwable)e);
                }
                finally {
                    this.callback.done(false);
                }
            }
            return this.exchange;
        }

        public String toString() {
            return "AhcAsyncHandler for exchangeId: " + this.exchange.getExchangeId() + " -> " + this.url;
        }

        public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
            this.os.write(bodyPart.getBodyPartBytes());
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} onBodyPartReceived {} bytes", (Object)this.exchange.getExchangeId(), (Object)bodyPart.length());
            }
            return AsyncHandler.State.CONTINUE;
        }

        public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} onStatusReceived {}", (Object)this.exchange.getExchangeId(), (Object)responseStatus);
            }
            this.statusCode = responseStatus.getStatusCode();
            this.statusText = responseStatus.getStatusText();
            return AsyncHandler.State.CONTINUE;
        }

        public AsyncHandler.State onHeadersReceived(HttpHeaders headers) {
            this.contentEncoding = headers.get("Content-Encoding");
            this.contentType = headers.get("Content-Type");
            this.charset = (Charset)MiscUtils.withDefault((Object)HttpUtils.extractContentTypeCharsetAttribute((String)this.contentType), (Object)StandardCharsets.UTF_8);
            return AsyncHandler.State.CONTINUE;
        }
    }

    static abstract class OutgoingMessageHandler<T extends OutgoingMessage> {
        protected final ObjectMapper mapper;
        private final AsyncHttpClient asyncHttpClient;
        private final int bufferSize;
        private final String contentType;
        private final String uri;
        private final Class<? extends MessageResult> resultClass;

        public OutgoingMessageHandler(AsyncHttpClient asyncHttpClient, int bufferSize, ObjectMapper mapper, String uri, String contentType, Class<? extends MessageResult> resultClass) {
            this.resultClass = resultClass;
            this.asyncHttpClient = asyncHttpClient;
            this.bufferSize = bufferSize;
            this.mapper = mapper;
            this.uri = uri;
            this.contentType = contentType;
        }

        public void sendMessage(Exchange exchange, AsyncCallback callback, T message) {
            RequestBuilder builder = (RequestBuilder)new RequestBuilder("POST").setUrl(this.uri);
            if (this.contentType != null) {
                builder.setHeader((CharSequence)"Content-Type", this.contentType);
            }
            builder.setHeader((CharSequence)"Accept", "application/json");
            this.addBody(builder, message);
            this.asyncHttpClient.executeRequest(builder.build(), (AsyncHandler)new TelegramAsyncHandler(exchange, callback, this.uri, this.bufferSize, this.mapper, this.resultClass));
        }

        protected abstract void addBody(RequestBuilder var1, T var2);

        protected void fillCommonMediaParts(RequestBuilder builder, OutgoingMessage message) {
            this.buildTextPart(builder, "chat_id", message.getChatId());
            this.buildTextPart(builder, "reply_to_message_id", message.getReplyToMessageId());
            this.buildTextPart(builder, "disable_notification", message.getDisableNotification());
        }

        protected void buildTextPart(RequestBuilder builder, String name, Object value) {
            if (value != null) {
                builder.addBodyPart((Part)new StringPart(name, String.valueOf(value), "text/plain", StandardCharsets.UTF_8));
            }
        }

        protected void buildMediaPart(RequestBuilder builder, String name, String fileNameWithExtension, byte[] value) {
            builder.addBodyPart((Part)new ByteArrayPart(name, value, "application/octet-stream", StandardCharsets.UTF_8, fileNameWithExtension));
        }
    }

    static class OutgoingStickerMessageHandler
    extends OutgoingMessageHandler<OutgoingStickerMessage> {
        public OutgoingStickerMessageHandler(AsyncHttpClient asyncHttpClient, int bufferSize, ObjectMapper mapper, String baseUri) {
            super(asyncHttpClient, bufferSize, mapper, baseUri + "/sendSticker", null, MessageResult.class);
        }

        @Override
        protected void addBody(RequestBuilder builder, OutgoingStickerMessage message) {
            this.fillCommonMediaParts(builder, message);
            if (message.getSticker() != null) {
                this.buildTextPart(builder, "sticker", message.getSticker());
            } else {
                this.buildMediaPart(builder, "sticker", message.getFilenameWithExtension(), message.getStickerImage());
            }
        }
    }

    static class OutgoingPhotoMessageHandler
    extends OutgoingMessageHandler<OutgoingPhotoMessage> {
        public OutgoingPhotoMessageHandler(AsyncHttpClient asyncHttpClient, int bufferSize, ObjectMapper mapper, String baseUri) {
            super(asyncHttpClient, bufferSize, mapper, baseUri + "/sendPhoto", null, MessageResult.class);
        }

        @Override
        protected void addBody(RequestBuilder builder, OutgoingPhotoMessage message) {
            this.fillCommonMediaParts(builder, message);
            this.buildMediaPart(builder, "photo", message.getFilenameWithExtension(), message.getPhoto());
            this.buildTextPart(builder, "caption", message.getCaption());
            this.buildTextPart(builder, "reply_markup", message.replyMarkupJson());
        }
    }

    static class OutgoingDocumentMessageHandler
    extends OutgoingMessageHandler<OutgoingDocumentMessage> {
        public OutgoingDocumentMessageHandler(AsyncHttpClient asyncHttpClient, int bufferSize, ObjectMapper mapper, String baseUri) {
            super(asyncHttpClient, bufferSize, mapper, baseUri + "/sendDocument", null, MessageResult.class);
        }

        @Override
        protected void addBody(RequestBuilder builder, OutgoingDocumentMessage message) {
            this.fillCommonMediaParts(builder, message);
            this.buildMediaPart(builder, "document", message.getFilenameWithExtension(), message.getDocument());
            this.buildTextPart(builder, "caption", message.getCaption());
            this.buildTextPart(builder, "reply_markup", message.replyMarkupJson());
        }
    }

    static class OutgoingVideoMessageHandler
    extends OutgoingMessageHandler<OutgoingVideoMessage> {
        public OutgoingVideoMessageHandler(AsyncHttpClient asyncHttpClient, int bufferSize, ObjectMapper mapper, String baseUri) {
            super(asyncHttpClient, bufferSize, mapper, baseUri + "/sendVideo", null, MessageResult.class);
        }

        @Override
        protected void addBody(RequestBuilder builder, OutgoingVideoMessage message) {
            this.fillCommonMediaParts(builder, message);
            this.buildMediaPart(builder, "video", message.getFilenameWithExtension(), message.getVideo());
            this.buildTextPart(builder, "caption", message.getCaption());
            this.buildTextPart(builder, "duration", message.getDurationSeconds());
            this.buildTextPart(builder, "width", message.getWidth());
            this.buildTextPart(builder, "height", message.getHeight());
            this.buildTextPart(builder, "reply_markup", message.replyMarkupJson());
        }
    }

    static class OutgoingAudioMessageHandler
    extends OutgoingMessageHandler<OutgoingAudioMessage> {
        public OutgoingAudioMessageHandler(AsyncHttpClient asyncHttpClient, int bufferSize, ObjectMapper mapper, String baseUri) {
            super(asyncHttpClient, bufferSize, mapper, baseUri + "/sendAudio", null, MessageResult.class);
        }

        @Override
        protected void addBody(RequestBuilder builder, OutgoingAudioMessage message) {
            this.fillCommonMediaParts(builder, message);
            this.buildMediaPart(builder, "audio", message.getFilenameWithExtension(), message.getAudio());
            this.buildTextPart(builder, "title", message.getTitle());
            this.buildTextPart(builder, "duration", message.getDurationSeconds());
            this.buildTextPart(builder, "performer", message.getPerformer());
            this.buildTextPart(builder, "reply_markup", message.replyMarkupJson());
        }
    }

    static class OutgoingPlainMessageHandler
    extends OutgoingMessageHandler<OutgoingMessage> {
        public OutgoingPlainMessageHandler(AsyncHttpClient asyncHttpClient, int bufferSize, ObjectMapper mapper, String uri, Class<? extends MessageResult> returnType) {
            super(asyncHttpClient, bufferSize, mapper, uri, "application/json", returnType);
        }

        public OutgoingPlainMessageHandler(AsyncHttpClient asyncHttpClient, int bufferSize, ObjectMapper mapper, String uri) {
            this(asyncHttpClient, bufferSize, mapper, uri, MessageResult.class);
        }

        @Override
        protected void addBody(RequestBuilder builder, OutgoingMessage message) {
            try {
                String body = this.mapper.writeValueAsString((Object)message);
                builder.setBody(body);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Could not serialize " + message);
            }
        }
    }
}

