/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.tahu.TahuConfiguration;
import org.apache.camel.component.tahu.TahuDefaultEndpoint;
import org.apache.camel.component.tahu.handlers.TahuHostApplication;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.MessageType;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.model.MqttServerDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class TahuHostConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(TahuHostConsumer.class);
    private static final ConcurrentMap<String, TahuHostApplication> hostHandlers = new ConcurrentHashMap<String, TahuHostApplication>();
    private final TahuDefaultEndpoint endpoint;
    private final TahuHostApplication tahuHostApplication;
    private final Marker loggingMarker;
    private static final List<MessageType> HANDLED_MESSAGE_TYPES = List.of(MessageType.NBIRTH, MessageType.NDATA, MessageType.NDEATH, MessageType.DBIRTH, MessageType.DDATA, MessageType.DDEATH);

    TahuHostConsumer(TahuDefaultEndpoint endpoint, Processor processor, String hostId) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.loggingMarker = MarkerFactory.getMarker((String)hostId);
        TahuConfiguration configuration = endpoint.getConfiguration();
        this.tahuHostApplication = hostHandlers.computeIfAbsent(hostId, hId -> {
            List<MqttServerDefinition> serverDefinitions = configuration.getServerDefinitionList();
            TahuHostApplication thah = new TahuHostApplication.HostApplicationBuilder().hostId((String)hId).serverDefinitions(serverDefinitions).onMessageConsumer(this::onMessageConsumer).onMetricConsumer(this::onMetricConsumer).build();
            return thah;
        });
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.tahuHostApplication.startup();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.tahuHostApplication.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onMessageConsumer(EdgeNodeDescriptor edgeNodeDescriptor, org.eclipse.tahu.message.model.Message tahuMessage) {
        exchange = null;
        try {
            topic = tahuMessage.getTopic();
            payload = tahuMessage.getPayload();
            if (TahuHostConsumer.HANDLED_MESSAGE_TYPES.contains(topic.getType())) {
                exchange = this.createExchange(true);
                context = exchange.getContext();
                camelMessage = (Message)ObjectHelper.supplyIfEmpty((Object)exchange.getMessage(), (Supplier<Message>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$onMessageConsumer$1(org.apache.camel.CamelContext ), ()Lorg/apache/camel/Message;)((CamelContext)context));
                exchange.setMessage(camelMessage);
                camelMessage.setHeader("CamelTahuMessageType", (Object)topic.getType().name());
                camelMessage.setHeader("CamelTahuEdgeNodeDescriptor", (Object)edgeNodeDescriptor.getDescriptorString());
                if (payload.getTimestamp() != null) {
                    camelMessage.setHeader("CamelTahuMessageTimestamp", (Object)payload.getTimestamp().getTime());
                }
                if (payload.getSeq() != null) {
                    camelMessage.setHeader("CamelTahuMessageSequenceNumber", (Object)payload.getSeq());
                }
                if (payload.getUuid() != null) {
                    try {
                        camelMessage.setHeader("CamelTahuMessageUUID", (Object)UUID.fromString(payload.getUuid()));
                    }
                    catch (IllegalArgumentException iae) {
                        TahuHostConsumer.LOG.warn(this.loggingMarker, "Exception caught parsing Sparkplug message UUID {} - skipping", (Object)payload.getUuid());
                    }
                }
                if (payload.getBody() != null) {
                    camelMessage.setBody((Object)payload.getBody(), byte[].class);
                }
                if (!(payloadMetrics = payload.getMetrics().stream().map((Function<Metric, Object[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onMessageConsumer$2(org.eclipse.tahu.message.model.Metric ), (Lorg/eclipse/tahu/message/model/Metric;)[Ljava/lang/Object;)()).collect(Collectors.toMap((Function<Object[], String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onMessageConsumer$3(java.lang.Object[] ), ([Ljava/lang/Object;)Ljava/lang/String;)(), (Function<Object[], Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$onMessageConsumer$4(java.lang.Object[] ), ([Ljava/lang/Object;)Ljava/lang/Object;)()))).isEmpty()) {
                    camelMessage.setHeaders(payloadMetrics);
                }
                this.getProcessor().process(exchange);
            } else {
                TahuHostConsumer.LOG.warn(this.loggingMarker, "TahuHostAppConsumer onMessageConsumer: Unknown Message Type {} from {} - ignoring", (Object)topic.getType(), (Object)edgeNodeDescriptor);
            }
            if (exchange == null) return;
            ** GOTO lbl43
        }
        catch (Exception e) {
            try {
                TahuHostConsumer.LOG.debug(this.loggingMarker, "Exception caught processing exchange from Sparkplug Message", (Throwable)e);
                if (exchange != null) {
                    exchange.setException((Throwable)e);
                }
                if (exchange == null) return;
            }
            catch (Throwable var9_11) {
                if (exchange == null) throw var9_11;
                if (exchange.getException() == null) throw var9_11;
                this.getExceptionHandler().handleException("Exception caught processing exchange from Sparkplug Message", exchange, (Throwable)exchange.getException());
                throw var9_11;
            }
lbl43:
            // 1 sources

            if (exchange.getException() == null) return;
            this.getExceptionHandler().handleException("Exception caught processing exchange from Sparkplug Message", exchange, (Throwable)exchange.getException());
            return;
            if (exchange.getException() == null) return;
            this.getExceptionHandler().handleException("Exception caught processing exchange from Sparkplug Message", exchange, (Throwable)exchange.getException());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMetricConsumer(EdgeNodeDescriptor edgeNodeDescriptor, Metric metric) {
        Exchange exchange = null;
        try {
            exchange = this.createExchange(true);
            CamelContext context = exchange.getContext();
            Message camelMessage = (Message)ObjectHelper.supplyIfEmpty((Object)exchange.getMessage(), () -> new DefaultMessage(context));
            exchange.setMessage(camelMessage);
            camelMessage.setHeader("CamelTahuEdgeNodeDescriptor", (Object)edgeNodeDescriptor.getDescriptorString());
            camelMessage.setHeader("CamelTahuMetric." + metric.getName(), (Object)metric);
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOG.debug(this.loggingMarker, "Exception caught processing exchange from Sparkplug Metric", (Throwable)e);
            if (exchange != null) {
                exchange.setException((Throwable)e);
            }
        }
        finally {
            if (exchange != null && exchange.getException() != null) {
                this.getExceptionHandler().handleException("Exception caught processing exchange from Sparkplug Metric", exchange, (Throwable)exchange.getException());
            }
        }
    }

    private static /* synthetic */ Object lambda$onMessageConsumer$4(Object[] arr) {
        return arr[1];
    }

    private static /* synthetic */ String lambda$onMessageConsumer$3(Object[] arr) {
        return (String)arr[0];
    }
}

