/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.tahu.TahuConfiguration;
import org.apache.camel.component.tahu.TahuEdgeEndpoint;
import org.apache.camel.component.tahu.handlers.CamelBdSeqManager;
import org.apache.camel.component.tahu.handlers.TahuEdgeClient;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.tahu.message.BdSeqManager;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.message.model.SparkplugDescriptor;
import org.eclipse.tahu.model.MqttServerDefinition;

public abstract class TahuEdgeProducer
extends DefaultProducer {
    protected static final ConcurrentMap<EdgeNodeDescriptor, TahuEdgeClient> descriptorClients = new ConcurrentHashMap<EdgeNodeDescriptor, TahuEdgeClient>();
    protected static final ConcurrentMap<EdgeNodeDescriptor, Future<?>> descriptorFutures = new ConcurrentHashMap();
    private final CamelContext camelContext;
    protected final TahuEdgeClient tahuEdgeClient;
    protected ExecutorService clientExecutorService;
    protected final EdgeNodeDescriptor edgeNodeDescriptor;

    private TahuEdgeProducer(TahuEdgeEndpoint endpoint, EdgeNodeDescriptor edgeNodeDescriptor) {
        super((Endpoint)endpoint);
        this.camelContext = endpoint.getCamelContext();
        this.edgeNodeDescriptor = edgeNodeDescriptor;
        this.tahuEdgeClient = this.createClient(endpoint, edgeNodeDescriptor);
    }

    public void process(Exchange exchange) throws InvalidPayloadException {
        boolean messageHasNullBody;
        Message message = exchange.getMessage();
        boolean bl = messageHasNullBody = message.getBody() == null;
        if (messageHasNullBody) {
            message.setBody((Object)message, Message.class);
        }
        SparkplugBPayload payload = (SparkplugBPayload)message.getMandatoryBody(SparkplugBPayload.class);
        String messageType = this.edgeNodeDescriptor.isDeviceDescriptor() ? "DDATA" : "NDATA";
        message.setHeader("CamelTahuMessageType", (Object)messageType);
        message.setHeader("CamelTahuEdgeNodeDescriptor", (Object)this.edgeNodeDescriptor);
        Optional.ofNullable(payload.getUuid()).ifPresent(uuid -> message.setHeader("CamelTahuMessageUUID", uuid));
        Optional.ofNullable(payload.getTimestamp()).ifPresent(timestamp -> message.setHeader("CamelTahuMessageTimestamp", timestamp));
        Optional.ofNullable(payload.getSeq()).ifPresent(seq -> message.setHeader("CamelTahuMessageSequenceNumber", seq));
        try {
            this.tahuEdgeClient.publishData((SparkplugDescriptor)this.edgeNodeDescriptor, payload);
        }
        catch (Throwable t) {
            exchange.setException(t);
        }
        if (messageHasNullBody) {
            message.setBody(null);
        }
    }

    private TahuEdgeClient createClient(TahuEdgeEndpoint endpoint, EdgeNodeDescriptor edgeNodeDescriptor) {
        EdgeNodeDescriptor clientCreationDescriptor = edgeNodeDescriptor;
        if (edgeNodeDescriptor.isDeviceDescriptor()) {
            clientCreationDescriptor = ((DeviceDescriptor)edgeNodeDescriptor).getEdgeNodeDescriptor();
        }
        TahuEdgeClient tahuEdgeClient = descriptorClients.computeIfAbsent(clientCreationDescriptor, end -> {
            TahuConfiguration configuration = endpoint.getConfiguration();
            List<MqttServerDefinition> serverDefinitions = configuration.getServerDefinitionList();
            long rebirthDebounceDelay = configuration.getRebirthDebounceDelay();
            String primaryHostId = endpoint.getPrimaryHostId();
            List<String> deviceIds = endpoint.getDeviceIdList();
            boolean useAliases = endpoint.isUseAliases();
            this.clientExecutorService = this.camelContext.getExecutorServiceManager().newSingleThreadExecutor((Object)this, end.getDescriptorString());
            BdSeqManager bdSeqManager = Optional.ofNullable(endpoint.getBdSeqManager()).orElseGet(() -> new CamelBdSeqManager((EdgeNodeDescriptor)end, endpoint.getBdSeqNumPath()));
            TahuEdgeClient client = new TahuEdgeClient.ClientBuilder().edgeNodeDescriptor(edgeNodeDescriptor).deviceIds(deviceIds).primaryHostId(primaryHostId).useAliases(useAliases).rebirthDebounceDelay(rebirthDebounceDelay).serverDefinitions(serverDefinitions).bdSeqManager(bdSeqManager).clientExecutorService(this.clientExecutorService).build();
            return client;
        });
        tahuEdgeClient.addDeviceMetricDataPayloadMap((SparkplugDescriptor)edgeNodeDescriptor, endpoint.getMetricDataTypePayloadMap());
        return tahuEdgeClient;
    }

    static final class Builder {
        private final TahuEdgeEndpoint endpoint;
        private String groupId;
        private String edgeNode;
        private String deviceId;

        public Builder(TahuEdgeEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder edgeNode(String edgeNode) {
            this.edgeNode = edgeNode;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public TahuEdgeProducer build() {
            TahuEdgeProducer response = ObjectHelper.isNotEmpty((String)this.deviceId) ? new TahuEdgeDeviceProducer(this.endpoint, new DeviceDescriptor(this.groupId, this.edgeNode, this.deviceId)) : new TahuEdgeNodeProducer(this.endpoint, new EdgeNodeDescriptor(this.groupId, this.edgeNode));
            return response;
        }
    }

    static final class TahuEdgeDeviceProducer
    extends TahuEdgeProducer {
        private TahuEdgeDeviceProducer(TahuEdgeEndpoint endpoint, DeviceDescriptor deviceDescriptor) {
            super(endpoint, (EdgeNodeDescriptor)deviceDescriptor);
        }
    }

    static final class TahuEdgeNodeProducer
    extends TahuEdgeProducer {
        private TahuEdgeNodeProducer(TahuEdgeEndpoint endpoint, EdgeNodeDescriptor edgeNodeDescriptor) {
            super(endpoint, edgeNodeDescriptor);
        }

        protected void doStart() throws Exception {
            super.doStart();
            descriptorFutures.computeIfAbsent(this.edgeNodeDescriptor, end -> this.tahuEdgeClient.startup());
        }

        protected void doSuspend() throws Exception {
            super.doSuspend();
            this.tahuEdgeClient.suspend();
        }

        protected void doResume() throws Exception {
            super.doResume();
            this.tahuEdgeClient.resume();
        }

        protected void doStop() throws Exception {
            super.doStop();
            Future clientFuture = (Future)descriptorFutures.remove(this.edgeNodeDescriptor);
            if (clientFuture != null) {
                this.tahuEdgeClient.shutdown();
            }
        }
    }
}

