/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.tahu.TahuConfiguration;
import org.apache.camel.component.tahu.TahuDefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

public abstract class TahuDefaultComponent
extends DefaultComponent
implements SSLContextParametersAware {
    protected static final ConcurrentMap<String, TahuDefaultEndpoint> endpoints = new ConcurrentHashMap<String, TahuDefaultEndpoint>();
    @Metadata(label="advanced")
    TahuConfiguration configuration;
    @Metadata(label="security", defaultValue="false")
    boolean useGlobalSslContextParameters;

    protected TahuDefaultComponent() {
        this.configuration = this.createConfiguration();
    }

    protected TahuDefaultComponent(CamelContext camelContext) {
        super(camelContext);
        this.configuration = this.createConfiguration();
    }

    protected TahuDefaultComponent(TahuConfiguration configuration) {
        this.configuration = configuration;
    }

    protected abstract TahuDefaultEndpoint doCreateEndpoint(String var1, List<String> var2, TahuConfiguration var3) throws Exception;

    private List<String> getDescriptorSegments(String remaining) {
        return Arrays.stream(remaining.split("/", 3)).map(String::trim).filter(ObjectHelper::isNotEmpty).toList();
    }

    protected TahuDefaultEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (ObjectHelper.isEmpty((String)remaining)) {
            throw new ResolveEndpointFailedException(uri, "empty remaining segments");
        }
        TahuDefaultEndpoint answer = endpoints.computeIfAbsent(remaining, r -> {
            List<String> descriptorSegments = this.getDescriptorSegments(remaining);
            TahuConfiguration endpointConfig = this.getConfiguration().copy();
            if (endpointConfig.getSslContextParameters() == null) {
                endpointConfig.setSslContextParameters(this.retrieveGlobalSslContextParameters());
            }
            try {
                TahuDefaultEndpoint newEndpoint = this.doCreateEndpoint(uri, descriptorSegments, endpointConfig);
                this.setProperties((Endpoint)newEndpoint, parameters);
                return newEndpoint;
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, (Throwable)e);
            }
        });
        return answer;
    }

    public TahuConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TahuConfiguration configuration) {
        this.configuration = configuration;
    }

    TahuConfiguration createConfiguration() {
        return new TahuConfiguration();
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

