/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.tahu.model.MqttServerDefinition;
import org.eclipse.tahu.mqtt.MqttClientId;
import org.eclipse.tahu.mqtt.MqttServerName;
import org.eclipse.tahu.mqtt.MqttServerUrl;

@UriParams
public class TahuConfiguration
implements Cloneable {
    private static final Pattern SERVER_DEF_PATTERN = Pattern.compile("([^:]+):(?:(?!tcp|ssl)([^:]+):)?((?:tcp|ssl):(?://)?[\\p{Alnum}.-]+(?::\\d+)?),?");
    @UriParam(label="common")
    @Metadata(applicableFor={"tahu-edge", "tahu-host"}, required=true)
    private String servers;
    @UriParam(label="common")
    @Metadata(applicableFor={"tahu-edge", "tahu-host"}, required=true)
    private String clientId;
    @UriParam(label="common", defaultValue="false")
    @Metadata(applicableFor={"tahu-edge", "tahu-host"})
    private boolean checkClientIdLength = false;
    @UriParam(label="security", secret=true)
    @Metadata(applicableFor={"tahu-edge", "tahu-host"})
    private String username;
    @UriParam(label="security", secret=true)
    @Metadata(applicableFor={"tahu-edge", "tahu-host"})
    private String password;
    @UriParam(label="common", defaultValue="5000")
    @Metadata(applicableFor={"tahu-edge", "tahu-host"})
    private long rebirthDebounceDelay = 5000L;
    @UriParam(label="common", defaultValue="30")
    @Metadata(applicableFor={"tahu-edge", "tahu-host"})
    private int keepAliveTimeout = 30;
    @UriParam(label="security")
    @Metadata(applicableFor={"tahu-edge", "tahu-host"})
    private SSLContextParameters sslContextParameters;

    public String getServers() {
        return this.servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public List<MqttServerDefinition> getServerDefinitionList() {
        List<MqttServerDefinition> serverDefinitionList;
        if (ObjectHelper.isEmpty((String)this.servers)) {
            serverDefinitionList = List.of();
        } else {
            if (!SERVER_DEF_PATTERN.matcher(this.servers).find()) {
                throw new RuntimeCamelException("Server definition list has invalid syntax: " + this.servers);
            }
            Matcher serverDefMatcher = SERVER_DEF_PATTERN.matcher(this.servers);
            serverDefinitionList = serverDefMatcher.results().map(matchResult -> {
                String serverName = matchResult.group(1);
                String clientId = matchResult.group(2);
                String serverUrl = matchResult.group(3);
                return this.parseFromUrlString(serverName, clientId, serverUrl);
            }).toList();
        }
        return serverDefinitionList;
    }

    private MqttServerDefinition parseFromUrlString(String serverName, String clientId, String serverUrl) {
        try {
            MqttServerName mqttServerName = new MqttServerName(ObjectHelper.notNullOrEmpty((String)serverName, (String)"serverName"));
            clientId = Stream.of(clientId, this.clientId).filter(ObjectHelper::isNotEmpty).findFirst().orElse(MqttClientId.generate((String)"Camel"));
            MqttClientId mqttClientId = new MqttClientId(clientId, this.checkClientIdLength);
            return new MqttServerDefinition(mqttServerName, mqttClientId, new MqttServerUrl(ObjectHelper.notNullOrEmpty((String)serverUrl, (String)"serverUrl")), this.username, this.password, this.keepAliveTimeout, null);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isCheckClientIdLength() {
        return this.checkClientIdLength;
    }

    public void setCheckClientIdLength(boolean checkClientIdLength) {
        this.checkClientIdLength = checkClientIdLength;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getRebirthDebounceDelay() {
        return this.rebirthDebounceDelay;
    }

    public void setRebirthDebounceDelay(long rebirthDebounceDelay) {
        this.rebirthDebounceDelay = rebirthDebounceDelay;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public TahuConfiguration copy() {
        try {
            return (TahuConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

