/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.tahu.TahuConfiguration;
import org.apache.camel.component.tahu.TahuConstants;
import org.apache.camel.component.tahu.TahuDefaultEndpoint;
import org.apache.camel.component.tahu.TahuHostComponent;
import org.apache.camel.component.tahu.TahuHostConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="4.8.0", scheme="tahu-host", title="Tahu Host Application", syntax="tahu-host:hostId", consumerOnly=true, category={Category.MESSAGING, Category.IOT, Category.MONITORING}, headersClass=TahuConstants.class)
public class TahuHostEndpoint
extends TahuDefaultEndpoint {
    @UriPath(label="consumer", description="ID for the host application")
    @Metadata(applicableFor={"tahu-host"}, required=true)
    private final String hostId;

    TahuHostEndpoint(String uri, TahuHostComponent component, TahuConfiguration configuration, String hostId) {
        super(uri, component, configuration);
        this.hostId = hostId;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        TahuHostConsumer consumer = new TahuHostConsumer(this, processor, ObjectHelper.notNullOrEmpty((String)this.hostId, (String)"hostId"));
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Cannot produce from this endpoint");
    }

    public String getHostId() {
        return this.hostId;
    }
}

