/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.syslog;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.component.syslog.SyslogConverter;
import org.apache.camel.component.syslog.SyslogMessage;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;

public class SyslogDataFormat
implements DataFormat {
    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        SyslogMessage message = (SyslogMessage)ExchangeHelper.convertToMandatoryType((Exchange)exchange, SyslogMessage.class, (Object)body);
        stream.write(SyslogConverter.toString(message).getBytes());
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        String body = (String)ExchangeHelper.convertToMandatoryType((Exchange)exchange, String.class, (Object)inputStream);
        SyslogMessage message = SyslogConverter.parseMessage(body.getBytes());
        exchange.getOut().setHeader("CamelSyslogFacility", (Object)message.getFacility());
        exchange.getOut().setHeader("CamelSyslogSeverity", (Object)message.getSeverity());
        exchange.getOut().setHeader("CamelSyslogHostname", (Object)message.getHostname());
        exchange.getOut().setHeader("CamelSyslogTimestamp", (Object)message.getTimestamp());
        if (exchange.getIn().getHeader("CamelMinaLocalAddress") != null) {
            message.setLocalAddress((String)exchange.getIn().getHeader("CamelMinaLocalAddress", String.class));
            exchange.getOut().setHeader("CamelSyslogLocalAddress", (Object)message.getLocalAddress());
        }
        if (exchange.getIn().getHeader("CamelMinaRemoteAddress") != null) {
            message.setRemoteAddress((String)exchange.getIn().getHeader("CamelMinaRemoteAddress", String.class));
            exchange.getOut().setHeader("CamelSyslogRemoteAddress", (Object)message.getRemoteAddress());
        }
        if (exchange.getIn().getHeader("CamelNettyLocalAddress") != null) {
            message.setLocalAddress((String)exchange.getIn().getHeader("CamelNettyLocalAddress", String.class));
            exchange.getOut().setHeader("CamelSyslogLocalAddress", (Object)message.getLocalAddress());
        }
        if (exchange.getIn().getHeader("CamelNettyRemoteAddress") != null) {
            message.setRemoteAddress((String)exchange.getIn().getHeader("CamelNettyRemoteAddress", String.class));
            exchange.getOut().setHeader("CamelSyslogRemoteAddress", (Object)message.getRemoteAddress());
        }
        return message;
    }
}

