/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.swift.mx;

import com.prowidesoftware.JsonSerializable;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.MxReadConfiguration;
import com.prowidesoftware.swift.model.mx.MxWriteConfiguration;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="swiftMx")
@Metadata(firstVersion="3.20.0", title="SWIFT MX")
public class SwiftMxDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private MxWriteConfiguration writeConfig;
    private boolean writeInJson;
    private MxId readMessageId;
    private MxReadConfiguration readConfig;

    public SwiftMxDataFormat() {
    }

    public SwiftMxDataFormat(boolean writeInJson, MxId readMessageId, MxReadConfiguration readConfig) {
        this.writeInJson = writeInJson;
        this.readMessageId = readMessageId;
        this.readConfig = readConfig;
    }

    public SwiftMxDataFormat(MxWriteConfiguration writeConfig, MxId readMessageId, MxReadConfiguration readConfig) {
        this.writeConfig = writeConfig;
        this.readMessageId = readMessageId;
        this.readConfig = readConfig;
    }

    public String getDataFormatName() {
        return "swiftMx";
    }

    public void marshal(Exchange exchange, Object object, OutputStream stream) throws Exception {
        String output = this.writeInJson ? ((JsonSerializable)object).toJson() : ((AbstractMX)object).message(this.writeConfig);
        stream.write(output.getBytes(StandardCharsets.UTF_8));
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return AbstractMX.parse((String)new String((byte[])ExchangeHelper.convertToMandatoryType((Exchange)exchange, byte[].class, (Object)stream), StandardCharsets.UTF_8), (MxId)this.readMessageId, (MxReadConfiguration)this.readConfig);
    }

    public void init() {
        super.init();
        if (this.writeConfig == null) {
            this.writeConfig = new MxWriteConfiguration();
        }
        if (this.readConfig == null) {
            this.readConfig = new MxReadConfiguration();
        }
    }

    public MxId getReadMessageId() {
        return this.readMessageId;
    }

    public void setReadMessageId(MxId readMessageId) {
        this.readMessageId = readMessageId;
    }

    public MxReadConfiguration getReadConfig() {
        return this.readConfig;
    }

    public void setReadConfig(MxReadConfiguration readConfig) {
        this.readConfig = readConfig;
    }

    public MxWriteConfiguration getWriteConfig() {
        return this.writeConfig;
    }

    public void setWriteConfig(MxWriteConfiguration writeConfig) {
        this.writeConfig = writeConfig;
    }

    public boolean isWriteInJson() {
        return this.writeInJson;
    }

    public void setWriteInJson(boolean writeInJson) {
        this.writeInJson = writeInJson;
    }
}

