/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor.idempotent;

import java.util.Map;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

@Metadata(label="bean", description="A memory based IdempotentRepository.", annotations={"interfaceName=org.apache.camel.spi.IdempotentRepository"})
@Configurer(metadataOnly=true)
@ManagedResource(description="Memory based idempotent repository")
public class MemoryIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private static final int MAX_CACHE_SIZE = 1000;
    private Map<String, Object> cache;
    @Metadata(description="Maximum elements that can be stored in-memory", defaultValue="1000")
    private int cacheSize;

    public MemoryIdempotentRepository() {
    }

    public MemoryIdempotentRepository(Map<String, Object> set) {
        this.cache = set;
    }

    public static IdempotentRepository memoryIdempotentRepository() {
        return MemoryIdempotentRepository.memoryIdempotentRepository(1000);
    }

    public static IdempotentRepository memoryIdempotentRepository(int cacheSize) {
        MemoryIdempotentRepository answer = new MemoryIdempotentRepository();
        answer.setCacheSize(cacheSize);
        ServiceHelper.startService((Service)answer);
        return answer;
    }

    public static IdempotentRepository memoryIdempotentRepository(Map<String, Object> cache) {
        return new MemoryIdempotentRepository(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(key)) {
                return false;
            }
            this.cache.put(key, key);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            return this.cache.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            return this.cache.remove(key) != null;
        }
    }

    public boolean confirm(String key) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Clear the store")
    public void clear() {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    public Map<String, Object> getCache() {
        return this.cache;
    }

    @ManagedAttribute(description="The current cache size")
    public int getCacheSize() {
        return this.cache.size();
    }

    @ManagedAttribute(description="The maximum cache size")
    public int getMaxCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    protected void doStart() throws Exception {
        if (this.cache == null) {
            this.cache = LRUCacheFactory.newLRUCache(this.cacheSize <= 0 ? 1000 : this.cacheSize);
        }
    }

    protected void doStop() throws Exception {
        this.cache.clear();
    }
}

