/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Route;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;

@UriParams
@Configurer
public class DefaultExchangeFormatter
implements ExchangeFormatter {
    protected static final String LS = System.lineSeparator();
    private static final String SEPARATOR = "###REPLACE_ME###";
    @UriParam(label="formatting", description="Show route ID.")
    private boolean showRouteId;
    @UriParam(label="formatting", description="Show route Group.")
    private boolean showRouteGroup;
    @UriParam(label="formatting", description="Show the unique exchange ID.")
    private boolean showExchangeId;
    @UriParam(label="formatting", description="Shows the Message Exchange Pattern (or MEP for short).")
    private boolean showExchangePattern;
    @UriParam(label="formatting", description="Show the exchange properties (only custom).")
    private boolean showProperties;
    @UriParam(label="formatting", description="Show all the exchange properties (both internal and custom).")
    private boolean showAllProperties;
    @UriParam(label="formatting", description="Show the message headers.")
    private boolean showHeaders;
    @UriParam(label="formatting", defaultValue="true", description="Whether to skip line separators when logging the message body. This allows to log the message body in one line, setting this option to false will preserve any line separators from the body, which then will log the body as is.")
    private boolean skipBodyLineSeparator = true;
    @UriParam(label="formatting", defaultValue="true", description="Show the message body.")
    private boolean showBody = true;
    @UriParam(label="formatting", defaultValue="true", description="Show the body Java type.")
    private boolean showBodyType = true;
    @UriParam(label="formatting", description="If the exchange has an exception, show the exception message (no stacktrace)")
    private boolean showException;
    @UriParam(label="formatting", description="f the exchange has a caught exception, show the exception message (no stack trace). A caught exception is stored as a property on the exchange (using the key org.apache.camel.Exchange#EXCEPTION_CAUGHT) and for instance a doCatch can catch exceptions.")
    private boolean showCaughtException;
    @UriParam(label="formatting", description="Show the stack trace, if an exchange has an exception. Only effective if one of showAll, showException or showCaughtException are enabled.")
    private boolean showStackTrace;
    @UriParam(label="formatting", description="Quick option for turning all options on. (multiline, maxChars has to be manually set if to be used)")
    private boolean showAll;
    @UriParam(label="formatting", description="If enabled then each information is outputted on a newline.")
    private boolean multiline;
    @UriParam(label="formatting", description="If enabled Camel will on Future objects wait for it to complete to obtain the payload to be logged.")
    private boolean showFuture;
    @UriParam(label="formatting", defaultValue="true", description="Whether Camel should show cached stream bodies or not (org.apache.camel.StreamCache).")
    private boolean showCachedStreams = true;
    @UriParam(label="formatting", description="Whether Camel should show stream bodies or not (eg such as java.io.InputStream). Beware if you enable this option then you may not be able later to access the message body as the stream have already been read by this logger. To remedy this you will have to use Stream Caching.")
    private boolean showStreams;
    @UriParam(label="formatting", description="If enabled Camel will output files")
    private boolean showFiles;
    @UriParam(label="formatting", defaultValue="10000", description="Limits the number of characters logged per line.")
    private int maxChars = 10000;
    @UriParam(label="formatting", enums="Default,Tab,Fixed", defaultValue="Default", description="Sets the outputs style to use.")
    private OutputStyle style = OutputStyle.Default;
    @UriParam(defaultValue="false", description="If enabled only the body will be printed out")
    private boolean plain;

    private StringBuilder style(StringBuilder sb, String label) {
        if (this.style == OutputStyle.Default) {
            if (this.multiline) {
                sb.append("  ").append(label).append(": ");
            } else {
                sb.append(", ").append(label).append(": ");
            }
        } else if (this.style == OutputStyle.Tab) {
            sb.append("\t").append(label).append(": ");
        } else {
            String s = String.format("\t%-20s", label);
            sb.append(s);
        }
        return sb;
    }

    public String format(Exchange exchange) {
        Route route;
        Message in = exchange.getIn();
        StringBuilder sb = new StringBuilder();
        if (this.plain) {
            return this.getBodyAsString(in);
        }
        if (this.showAll || this.showExchangeId) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            this.style(sb, "Id").append(exchange.getExchangeId());
        }
        if (this.showAll || this.showRouteGroup) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            route = ExchangeHelper.getRoute(exchange);
            String group = "";
            if (route != null) {
                group = route.getGroup();
            }
            this.style(sb, "RouteGroup").append(group);
        }
        if (this.showAll || this.showRouteId) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            route = ExchangeHelper.getRoute(exchange);
            String id = "";
            if (route != null) {
                id = route.getRouteId();
            }
            this.style(sb, "RouteId").append(id);
        }
        if (this.showAll || this.showExchangePattern) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            this.style(sb, "ExchangePattern").append(exchange.getPattern());
        }
        if (this.showAll || this.showAllProperties) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            this.style(sb, "Properties").append(DefaultExchangeFormatter.sortMap(this.filterHeaderAndProperties(exchange.getAllProperties())));
        } else if (this.showProperties) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            this.style(sb, "Properties").append(DefaultExchangeFormatter.sortMap(this.filterHeaderAndProperties(exchange.getProperties())));
        }
        if (this.showAll || this.showHeaders) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            this.style(sb, "Headers").append(DefaultExchangeFormatter.sortMap(this.filterHeaderAndProperties(in.getHeaders())));
        }
        if (this.showAll || this.showBodyType) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            this.style(sb, "BodyType").append(this.getBodyTypeAsString(in));
        }
        if (this.showAll || this.showBody) {
            if (this.multiline) {
                sb.append(SEPARATOR);
            }
            String body = this.getBodyAsString(in);
            if (this.skipBodyLineSeparator && body != null) {
                body = body.replace(LS, "");
            }
            this.style(sb, "Body").append(body);
        }
        if (this.showAll || this.showException || this.showCaughtException) {
            Exception exception = exchange.getException();
            boolean caught = false;
            if ((this.showAll || this.showCaughtException) && exception == null) {
                exception = (Exception)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
                caught = true;
            }
            if (exception != null) {
                if (this.multiline) {
                    sb.append(SEPARATOR);
                }
                if (caught) {
                    this.style(sb, "CaughtExceptionType").append(exception.getClass().getCanonicalName());
                    this.style(sb, "CaughtExceptionMessage").append(exception.getMessage());
                } else {
                    this.style(sb, "ExceptionType").append(exception.getClass().getCanonicalName());
                    this.style(sb, "ExceptionMessage").append(exception.getMessage());
                }
                if (this.showAll || this.showStackTrace) {
                    StringWriter sw = new StringWriter();
                    exception.printStackTrace(new PrintWriter(sw));
                    this.style(sb, "StackTrace").append(sw);
                }
            }
        }
        if (this.multiline || this.maxChars > 0 && sb.length() > this.maxChars) {
            StringBuilder answer = new StringBuilder();
            for (String s : sb.toString().split(SEPARATOR)) {
                if (s == null) continue;
                if (s.length() > this.maxChars) {
                    s = s.substring(0, this.maxChars);
                    answer.append(s).append("...");
                } else {
                    answer.append(s);
                }
                if (!this.multiline) continue;
                answer.append(LS);
            }
            sb = answer;
        }
        if (!this.multiline && sb.length() > 1 && sb.charAt(0) == ',' && sb.charAt(1) == ' ') {
            sb.replace(0, 2, "");
        }
        sb.insert(0, "Exchange[");
        sb.append("]");
        return sb.toString();
    }

    protected Map<String, Object> filterHeaderAndProperties(Map<String, Object> map) {
        return map;
    }

    public boolean isShowRouteId() {
        return this.showRouteId;
    }

    public void setShowRouteId(boolean showRouteId) {
        this.showRouteId = showRouteId;
    }

    public boolean isShowRouteGroup() {
        return this.showRouteGroup;
    }

    public void setShowRouteGroup(boolean showRouteGroup) {
        this.showRouteGroup = showRouteGroup;
    }

    public boolean isShowExchangeId() {
        return this.showExchangeId;
    }

    public void setShowExchangeId(boolean showExchangeId) {
        this.showExchangeId = showExchangeId;
    }

    public boolean isShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(boolean showProperties) {
        this.showProperties = showProperties;
    }

    public boolean isShowAllProperties() {
        return this.showAllProperties;
    }

    public void setShowAllProperties(boolean showAllProperties) {
        this.showAllProperties = showAllProperties;
    }

    public boolean isShowHeaders() {
        return this.showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public boolean isSkipBodyLineSeparator() {
        return this.skipBodyLineSeparator;
    }

    public void setSkipBodyLineSeparator(boolean skipBodyLineSeparator) {
        this.skipBodyLineSeparator = skipBodyLineSeparator;
    }

    public boolean isShowBodyType() {
        return this.showBodyType;
    }

    public void setShowBodyType(boolean showBodyType) {
        this.showBodyType = showBodyType;
    }

    public boolean isShowBody() {
        return this.showBody;
    }

    public void setShowBody(boolean showBody) {
        this.showBody = showBody;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    public boolean isShowException() {
        return this.showException;
    }

    public void setShowException(boolean showException) {
        this.showException = showException;
    }

    public boolean isShowStackTrace() {
        return this.showStackTrace;
    }

    public void setShowStackTrace(boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
    }

    public boolean isShowCaughtException() {
        return this.showCaughtException;
    }

    public void setShowCaughtException(boolean showCaughtException) {
        this.showCaughtException = showCaughtException;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isShowFuture() {
        return this.showFuture;
    }

    public void setShowFuture(boolean showFuture) {
        this.showFuture = showFuture;
    }

    public boolean isShowExchangePattern() {
        return this.showExchangePattern;
    }

    public void setShowExchangePattern(boolean showExchangePattern) {
        this.showExchangePattern = showExchangePattern;
    }

    public boolean isShowCachedStreams() {
        return this.showCachedStreams;
    }

    public void setShowCachedStreams(boolean showCachedStreams) {
        this.showCachedStreams = showCachedStreams;
    }

    public boolean isShowStreams() {
        return this.showStreams;
    }

    public void setShowStreams(boolean showStreams) {
        this.showStreams = showStreams;
    }

    public boolean isShowFiles() {
        return this.showFiles;
    }

    public void setShowFiles(boolean showFiles) {
        this.showFiles = showFiles;
    }

    public OutputStyle getStyle() {
        return this.style;
    }

    public void setStyle(OutputStyle style) {
        this.style = style;
    }

    public boolean isPlain() {
        return this.plain;
    }

    public void setPlain(boolean plain) {
        this.plain = plain;
    }

    protected String getBodyAsString(Message message) {
        if (message.getBody() instanceof Future && !this.isShowFuture()) {
            return message.getBody().toString();
        }
        return MessageHelper.extractBodyForLogging(message, null, this.isShowCachedStreams(), this.isShowStreams(), this.isShowFiles(), this.getMaxChars(message));
    }

    private int getMaxChars(Message message) {
        String globalOption;
        int maxChars = this.getMaxChars();
        if (message.getExchange() != null && (globalOption = message.getExchange().getContext().getGlobalOption("CamelLogDebugBodyMaxChars")) != null) {
            maxChars = (Integer)message.getExchange().getContext().getTypeConverter().convertTo(Integer.class, (Object)globalOption);
        }
        return maxChars;
    }

    protected String getBodyTypeAsString(Message message) {
        String answer = ObjectHelper.classCanonicalName((Object)message.getBody());
        if (answer != null && answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        return answer;
    }

    private static Map<String, Object> sortMap(Map<String, Object> map) {
        TreeMap<String, Object> answer = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        answer.putAll(map);
        return answer;
    }

    public static enum OutputStyle {
        Default,
        Tab,
        Fixed;

    }
}

