/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.resume;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.resume.Cacheable;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.cache.ResumeCache;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdapterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AdapterHelper.class);
    private static final String ADAPTER_PROPERTIES = "/org/apache/camel/resume/adapter.properties";
    private static final String PROP_ADAPTER_CLASS = "adapterClass";

    private AdapterHelper() {
    }

    public static ResumeAdapter eval(CamelContext context, Consumer consumer) {
        assert (context != null);
        assert (consumer != null);
        Object adapterInstance = context.getRegistry().lookupByName("resumeAdapter");
        if (adapterInstance == null && (adapterInstance = AdapterHelper.resolveAdapter(context, consumer)) == null) {
            throw new RuntimeException("Cannot find a resume adapter class in the consumer classpath or in the registry");
        }
        if (adapterInstance instanceof ResumeAdapter) {
            ResumeAdapter resumeAdapter = (ResumeAdapter)adapterInstance;
            Object obj = context.getRegistry().lookupByName("resumeCache");
            if (resumeAdapter instanceof Cacheable && obj instanceof ResumeCache) {
                ((Cacheable)resumeAdapter).setCache((ResumeCache)obj);
            } else {
                LOG.debug("The resume adapter {} is not cacheable", (Object)resumeAdapter.getClass().getName());
            }
            return resumeAdapter;
        }
        LOG.error("Invalid resume adapter type: {}", AdapterHelper.getType(adapterInstance));
        throw new IllegalArgumentException("Invalid resume adapter type: " + AdapterHelper.getType(adapterInstance));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object resolveAdapter(CamelContext context, Consumer consumer) {
        try (InputStream adapterStream = consumer.getClass().getResourceAsStream(ADAPTER_PROPERTIES);){
            if (adapterStream == null) {
                LOG.error("Cannot find a resume adapter class in the consumer {} classpath", consumer.getClass());
                Object var3_5 = null;
                return var3_5;
            }
            Properties properties = new Properties();
            properties.load(adapterStream);
            String adapterClass = properties.getProperty(PROP_ADAPTER_CLASS);
            if (ObjectHelper.isEmpty((String)adapterClass)) {
                LOG.error("A resume adapter class is not defined in the adapter configuration");
                Object var5_10 = null;
                return var5_10;
            }
            LOG.debug("About to load an adapter class {} for consumer {}", (Object)adapterClass, consumer.getClass());
            Class clazz = context.getClassResolver().resolveClass(adapterClass);
            if (clazz == null) {
                LOG.error("Cannot find the resume adapter class in the classpath {}", (Object)adapterClass);
                Object var6_12 = null;
                return var6_12;
            }
            Object t = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return t;
        }
        catch (IOException e) {
            LOG.error("Unable to read the resolve the resume adapter due to I/O error: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Unable to create a resume adapter instance: {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private static Object getType(Object instance) {
        return instance == null ? "null" : instance.getClass();
    }
}

