/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.URISupport;

public class ScheduledPollConsumerHealthCheck
implements HealthCheck {
    private final ScheduledPollConsumer consumer;
    private final String id;
    private final String sanitizedBaseUri;
    private final String sanitizedUri;
    private boolean enabled = true;
    private boolean downBeforeFirstPoll = true;

    public ScheduledPollConsumerHealthCheck(ScheduledPollConsumer consumer, String id) {
        this.consumer = consumer;
        this.id = id;
        this.sanitizedBaseUri = URISupport.sanitizeUri((String)consumer.getEndpoint().getEndpointBaseUri());
        this.sanitizedUri = URISupport.sanitizeUri((String)consumer.getEndpoint().getEndpointUri());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public HealthCheck.Result call(Map<String, Object> options) {
        boolean healthy;
        HealthCheckResultBuilder builder = HealthCheckResultBuilder.on((HealthCheck)this);
        builder.detail("endpoint.uri", (Object)this.sanitizedUri);
        builder.detail("failure.endpoint.uri", (Object)this.sanitizedUri);
        if (!this.isEnabled()) {
            builder.message("Disabled");
            builder.detail("check.enabled", (Object)false);
            return builder.unknown().build();
        }
        long ec = this.consumer.getErrorCounter();
        boolean first = this.consumer.isFirstPollDone();
        Throwable cause = this.consumer.getLastError();
        boolean bl = healthy = this.downBeforeFirstPoll && first && ec == 0L || !this.downBeforeFirstPoll && ec == 0L;
        if (healthy) {
            builder.up();
        } else {
            builder.down();
            builder.detail("failure.error.count", (Object)ec);
            String rid = this.consumer.getRouteId();
            if (ec > 0L) {
                String msg = "Consumer failed polling %s times route: %s (%s)";
                builder.message(String.format(msg, ec, rid, this.sanitizedBaseUri));
            } else {
                String msg = "Consumer has not yet polled route: %s (%s)";
                builder.message(String.format(msg, rid, this.sanitizedBaseUri));
            }
            builder.error(cause);
            if (this.consumer.getLastErrorDetails() != null) {
                builder.details(this.consumer.getLastErrorDetails());
            }
        }
        return builder.build();
    }

    public boolean isDownBeforeFirstPoll() {
        return this.downBeforeFirstPoll;
    }

    public void setDownBeforeFirstPoll(boolean downBeforeFirstPoll) {
        this.downBeforeFirstPoll = downBeforeFirstPoll;
    }

    public String getGroup() {
        return "camel";
    }

    public String getId() {
        return this.id;
    }
}

