/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.startup;

import java.util.Arrays;
import org.apache.camel.StartupStep;
import org.apache.camel.support.startup.DefaultStartupStepRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingStartupStepRecorder
extends DefaultStartupStepRecorder {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingStartupStepRecorder.class);

    public LoggingStartupStepRecorder() {
        this.setEnabled(true);
    }

    @Override
    protected void onEndStep(StartupStep step) {
        if (LOG.isInfoEnabled()) {
            long delta = System.currentTimeMillis() - step.getBeginTime();
            String pad = LoggingStartupStepRecorder.padString(step.getLevel());
            String out = String.format("%s", pad + step.getType());
            String out2 = String.format("%6s ms", delta);
            String out3 = String.format("%s(%s)", step.getDescription(), step.getName());
            LOG.info("{} : {} - {}", new Object[]{out2, out, out3});
        }
    }

    public static String padString(int level) {
        if (level == 0) {
            return "";
        }
        byte[] arr = new byte[level * 2];
        byte space = 32;
        Arrays.fill(arr, space);
        return new String(arr);
    }

    public String toString() {
        return "logging";
    }
}

