/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.builder;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.GroupIterator;
import org.apache.camel.support.GroupTokenIterator;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.builder.Namespaces;
import org.apache.camel.support.builder.TokenPairExpressionIterator;
import org.apache.camel.support.builder.TokenXMLExpressionIterator;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.InetAddressUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.Scanner;
import org.apache.camel.util.StringHelper;

public class ExpressionBuilder {
    public static Expression headerExpression(final String headerName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = (String)ExpressionBuilder.simpleExpression(headerName).evaluate(exchange, String.class);
                Object header = exchange.getIn().getHeader(name);
                if (header == null) {
                    header = exchange.getProperty(name);
                }
                return header;
            }

            public String toString() {
                return "header(" + headerName + ")";
            }
        };
    }

    public static <T> Expression headerExpression(final String headerName, final Class<T> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = (String)ExpressionBuilder.simpleExpression(headerName).evaluate(exchange, String.class);
                Object header = exchange.getIn().getHeader(name, type);
                if (header == null) {
                    header = exchange.getProperty(name, type);
                }
                return header;
            }

            public String toString() {
                return "headerAs(" + headerName + ", " + type + ")";
            }
        };
    }

    public static Expression headerExpression(final String headerName, final String typeName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Class type;
                String text;
                try {
                    text = (String)ExpressionBuilder.simpleExpression(typeName).evaluate(exchange, String.class);
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
                }
                text = (String)ExpressionBuilder.simpleExpression(headerName).evaluate(exchange, String.class);
                Object header = exchange.getIn().getHeader(text, type);
                if (header == null) {
                    header = exchange.getProperty(text, type);
                }
                return header;
            }

            public String toString() {
                return "headerAs(" + headerName + ", " + typeName + ")";
            }
        };
    }

    public static Expression headersExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeaders();
            }

            public String toString() {
                return "headers";
            }
        };
    }

    public static Expression exchangePatternExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getPattern();
            }

            public String toString() {
                return "exchangePattern";
            }
        };
    }

    public static Expression exchangeExceptionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                return exception;
            }

            public String toString() {
                return "exchangeException";
            }
        };
    }

    public static Expression exchangeExceptionExpression(final Class<Exception> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = (Exception)exchange.getException(type);
                if (exception == null) {
                    exception = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
                    return ObjectHelper.getException((Class)type, (Throwable)exception);
                }
                return exception;
            }

            public String toString() {
                return "exchangeException[" + type + "]";
            }
        };
    }

    public static Expression typeConverterExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getTypeConverter();
            }

            public String toString() {
                return "typeConverter";
            }
        };
    }

    public static Expression registryExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getRegistry();
            }

            public String toString() {
                return "registry";
            }
        };
    }

    public static Expression refExpression(final String ref) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = (String)ExpressionBuilder.simpleExpression(ref).evaluate(exchange, String.class);
                return exchange.getContext().getRegistry().lookupByName(text);
            }

            public String toString() {
                return "ref(" + ref + ")";
            }
        };
    }

    public static Expression camelContextExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext();
            }

            public String toString() {
                return "camelContext";
            }
        };
    }

    public static Expression camelContextNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getName();
            }

            public String toString() {
                return "camelContextName";
            }
        };
    }

    public static Expression exchangeExceptionMessageExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                return exception != null ? exception.getMessage() : null;
            }

            public String toString() {
                return "exchangeExceptionMessage";
            }
        };
    }

    public static Expression exchangeExceptionStackTraceExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
                }
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    IOHelper.close((Closeable[])new Closeable[]{pw, sw});
                    return sw.toString();
                }
                return null;
            }

            public String toString() {
                return "exchangeExceptionStackTrace";
            }
        };
    }

    public static Expression exchangePropertyExpression(final String propertyName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = (String)ExpressionBuilder.simpleExpression(propertyName).evaluate(exchange, String.class);
                return exchange.getProperty(text);
            }

            public String toString() {
                return "exchangeProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression exchangePropertiesExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getProperties();
            }

            public String toString() {
                return "exchangeProperties";
            }
        };
    }

    public static Expression camelContextPropertiesExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getContext().getGlobalOptions();
            }

            public String toString() {
                return "camelContextProperties";
            }
        };
    }

    public static Expression camelContextPropertyExpression(final String propertyName) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = (String)ExpressionBuilder.simpleExpression(propertyName).evaluate(exchange, String.class);
                return exchange.getContext().getGlobalOption(text);
            }

            public String toString() {
                return "camelContextProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression systemPropertyExpression(String propertyName) {
        return ExpressionBuilder.systemPropertyExpression(propertyName, null);
    }

    public static Expression systemPropertyExpression(final String propertyName, final String defaultValue) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = (String)ExpressionBuilder.simpleExpression(propertyName).evaluate(exchange, String.class);
                String text2 = (String)ExpressionBuilder.simpleExpression(defaultValue).evaluate(exchange, String.class);
                return System.getProperty(text, text2);
            }

            public String toString() {
                return "systemProperty(" + propertyName + ")";
            }
        };
    }

    public static Expression systemEnvironmentExpression(String propertyName) {
        return ExpressionBuilder.systemEnvironmentExpression(propertyName, null);
    }

    public static Expression systemEnvironmentExpression(final String propertyName, final String defaultValue) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = (String)ExpressionBuilder.simpleExpression(propertyName).evaluate(exchange, String.class);
                String answer = null;
                if (text != null && (answer = System.getenv(text = text.toUpperCase())) == null) {
                    String noDashKey = text.replace('-', '_');
                    answer = System.getenv(noDashKey);
                }
                if (answer == null) {
                    answer = (String)ExpressionBuilder.simpleExpression(defaultValue).evaluate(exchange, String.class);
                }
                return answer;
            }

            public String toString() {
                return "systemEnvironment(" + propertyName + ")";
            }
        };
    }

    public static Expression constantExpression(final Object value) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return value;
            }

            public String toString() {
                return "" + value;
            }
        };
    }

    public static Expression languageExpression(final String language, final String expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Language lan = exchange.getContext().resolveLanguage(language);
                if (lan != null) {
                    return lan.createExpression(expression).evaluate(exchange, Object.class);
                }
                throw new NoSuchLanguageException(language);
            }

            @Override
            public boolean matches(Exchange exchange) {
                Language lan = exchange.getContext().resolveLanguage(language);
                if (lan != null) {
                    return lan.createPredicate(expression).matches(exchange);
                }
                throw new NoSuchLanguageException(language);
            }

            public String toString() {
                return "language[" + language + ":" + expression + "]";
            }
        };
    }

    public static Expression bodyExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody();
            }

            public String toString() {
                return "body";
            }
        };
    }

    public static Expression bodyExpression(final Function<Object, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody());
            }

            public String toString() {
                return "bodyExpression";
            }
        };
    }

    public static Expression bodyExpression(final BiFunction<Object, Map<String, Object>, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(), exchange.getIn().getHeaders());
            }

            public String toString() {
                return "bodyExpression";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> bodyType, final Function<T, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(bodyType));
            }

            public String toString() {
                return "bodyExpression (" + bodyType + ")";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> bodyType, final BiFunction<T, Map<String, Object>, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(bodyType), exchange.getIn().getHeaders());
            }

            public String toString() {
                return "bodyExpression (" + bodyType + ")";
            }
        };
    }

    public static <T> Expression bodyExpression(final Class<T> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody(type);
            }

            public String toString() {
                return "bodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression bodyExpression(final String name) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Class type;
                String text = (String)ExpressionBuilder.simpleExpression(name).evaluate(exchange, String.class);
                try {
                    type = exchange.getContext().getClassResolver().resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
                }
                return exchange.getIn().getBody(type);
            }

            public String toString() {
                return "bodyAs[" + name + "]";
            }
        };
    }

    public static Expression threadNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return Thread.currentThread().getName();
            }

            public String toString() {
                return "threadName";
            }
        };
    }

    public static Expression hostnameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return InetAddressUtil.getLocalHostNameSafe();
            }

            public String toString() {
                return "hostname";
            }
        };
    }

    public static Expression stepIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getProperty("CamelStepId");
            }

            public String toString() {
                return "stepId";
            }
        };
    }

    public static <T> Expression mandatoryBodyExpression(Class<T> type) {
        return ExpressionBuilder.mandatoryBodyExpression(type, false);
    }

    public static <T> Expression mandatoryBodyExpression(final Class<T> type, final boolean nullBodyAllowed) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (nullBodyAllowed && exchange.getIn().getBody() == null) {
                    return null;
                }
                try {
                    return exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
                }
            }

            public String toString() {
                return "mandatoryBodyAs[" + type.getName() + "]";
            }
        };
    }

    public static Expression bodyTypeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getBody().getClass();
            }

            public String toString() {
                return "bodyType";
            }
        };
    }

    public static Expression exchangeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange;
            }

            public String toString() {
                return "exchange";
            }
        };
    }

    public static Expression exchangeExpression(final Function<Exchange, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange);
            }

            public String toString() {
                return "exchangeExpression";
            }
        };
    }

    public static Expression messageExpression() {
        return ExpressionBuilder.inMessageExpression();
    }

    public static Expression messageExpression(Function<Message, Object> function) {
        return ExpressionBuilder.inMessageExpression(function);
    }

    public static Expression inMessageExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn();
            }

            public String toString() {
                return "inMessage";
            }
        };
    }

    public static Expression inMessageExpression(final Function<Message, Object> function) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn());
            }

            public String toString() {
                return "inMessageExpression";
            }
        };
    }

    public static Expression convertToExpression(final Expression expression, final Class<?> type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (type != null) {
                    return expression.evaluate(exchange, type);
                }
                return expression;
            }

            public String toString() {
                return "" + expression;
            }
        };
    }

    public static Expression convertToExpression(final Expression expression, final Expression type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object result = type.evaluate(exchange, Object.class);
                if (result != null) {
                    return expression.evaluate(exchange, result.getClass());
                }
                return expression;
            }

            public String toString() {
                return "" + expression;
            }
        };
    }

    public static Expression tokenizeExpression(final Expression expression, final String token) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = (String)ExpressionBuilder.simpleExpression(token).evaluate(exchange, String.class);
                Object value = expression.evaluate(exchange, Object.class);
                Scanner scanner = ExchangeHelper.getScanner(exchange, value, text);
                return scanner;
            }

            public String toString() {
                return "tokenize(" + expression + ", " + token + ")";
            }
        };
    }

    public static Expression skipFirstExpression(final Expression expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                Iterator it = (Iterator)exchange.getContext().getTypeConverter().tryConvertTo(Iterator.class, exchange, value);
                if (it != null) {
                    it.next();
                    return it;
                }
                return value;
            }

            public String toString() {
                return "skipFirst(" + expression + ")";
            }
        };
    }

    public static Expression regexTokenizeExpression(final Expression expression, final String regexTokenizer) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                Scanner scanner = ExchangeHelper.getScanner(exchange, value, regexTokenizer);
                return scanner;
            }

            public String toString() {
                return "regexTokenize(" + expression + ", " + regexTokenizer + ")";
            }
        };
    }

    public static Expression groupXmlIteratorExpression(final Expression expression, final String group) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Iterator it = (Iterator)expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull((Object)it, (String)("expression: " + expression + " evaluated on " + exchange + " must return an java.util.Iterator"));
                Integer parts = (Integer)exchange.getContext().resolveLanguage("simple").createExpression(group).evaluate(exchange, Integer.class);
                if (parts == null) {
                    throw new RuntimeExchangeException("Group evaluated as null, must be evaluated as a positive Integer value from expression: " + group, exchange);
                }
                if (parts <= 0) {
                    throw new RuntimeExchangeException("Group must be a positive number, was: " + parts, exchange);
                }
                return new GroupTokenIterator(exchange, it, null, parts, false);
            }

            public String toString() {
                return "group " + expression + " " + group + " times";
            }
        };
    }

    public static Expression groupIteratorExpression(final Expression expression, final String token, final String group, final boolean skipFirst) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Iterator it = (Iterator)expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull((Object)it, (String)("expression: " + expression + " evaluated on " + exchange + " must return an java.util.Iterator"));
                Integer parts = (Integer)exchange.getContext().resolveLanguage("simple").createExpression(group).evaluate(exchange, Integer.class);
                if (parts == null) {
                    throw new RuntimeExchangeException("Group evaluated as null, must be evaluated as a positive Integer value from expression: " + group, exchange);
                }
                if (parts <= 0) {
                    throw new RuntimeExchangeException("Group must be a positive number, was: " + parts, exchange);
                }
                if (token != null) {
                    return new GroupTokenIterator(exchange, it, token, parts, skipFirst);
                }
                return new GroupIterator(exchange, it, parts, skipFirst);
            }

            public String toString() {
                return "group " + expression + " " + group + " times";
            }
        };
    }

    public static Expression sortExpression(final Expression expression, final Comparator comparator) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                List list = (List)expression.evaluate(exchange, List.class);
                list.sort(comparator);
                return list;
            }

            public String toString() {
                return "sort(" + expression + " by: " + comparator + ")";
            }
        };
    }

    public static Expression regexReplaceAll(final Expression expression, String regex, final String replacement) {
        final Pattern pattern = Pattern.compile(regex);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = (String)expression.evaluate(exchange, String.class);
                if (text == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression regexReplaceAll(final Expression expression, String regex, final Expression replacementExpression) {
        final Pattern pattern = Pattern.compile(regex);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = (String)expression.evaluate(exchange, String.class);
                String replacement = (String)replacementExpression.evaluate(exchange, String.class);
                if (text == null || replacement == null) {
                    return null;
                }
                return pattern.matcher(text).replaceAll(replacement);
            }

            public String toString() {
                return "regexReplaceAll(" + expression + ", " + pattern.pattern() + ")";
            }
        };
    }

    public static Expression append(final Expression left, final Expression right) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return (String)left.evaluate(exchange, String.class) + (String)right.evaluate(exchange, String.class);
            }

            public String toString() {
                return "append(" + left + ", " + right + ")";
            }
        };
    }

    public static Expression prepend(final Expression left, final Expression right) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return (String)right.evaluate(exchange, String.class) + (String)left.evaluate(exchange, String.class);
            }

            public String toString() {
                return "prepend(" + left + ", " + right + ")";
            }
        };
    }

    public static Expression concatExpression(Collection<Expression> expressions) {
        return ExpressionBuilder.concatExpression(expressions, null);
    }

    public static Expression concatExpression(final Collection<Expression> expressions, final String description) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                StringBuilder buffer = new StringBuilder();
                for (Expression expression : expressions) {
                    String text = (String)expression.evaluate(exchange, String.class);
                    if (text == null) continue;
                    buffer.append(text);
                }
                return buffer.toString();
            }

            public String toString() {
                if (description != null) {
                    return description;
                }
                return "concat" + expressions;
            }
        };
    }

    public static Expression messageIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getMessageId();
            }

            public String toString() {
                return "messageId";
            }
        };
    }

    public static Expression exchangeIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getExchangeId();
            }

            public String toString() {
                return "exchangeId";
            }
        };
    }

    public static Expression routeIdExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                RouteContext rc;
                String answer = null;
                UnitOfWork uow = exchange.getUnitOfWork();
                RouteContext routeContext = rc = uow != null ? uow.getRouteContext() : null;
                if (rc != null) {
                    answer = rc.getRouteId();
                }
                if (answer == null) {
                    answer = exchange.getFromRouteId();
                }
                return answer;
            }

            public String toString() {
                return "routeId";
            }
        };
    }

    public static Expression simpleExpression(final String expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if (LanguageSupport.hasSimpleFunction(expression)) {
                    Language language = exchange.getContext().resolveLanguage("simple");
                    return language.createExpression(expression).evaluate(exchange, Object.class);
                }
                return expression;
            }

            public String toString() {
                return "simple(" + expression + ")";
            }
        };
    }

    public static Expression beanExpression(final String expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Language language = exchange.getContext().resolveLanguage("bean");
                return language.createExpression(expression).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "bean(" + expression + ")";
            }
        };
    }

    public static Expression beanExpression(final Object bean, final String expression) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Language language = exchange.getContext().resolveLanguage("bean");
                ExpressionBuilder.setProperty(exchange.getContext(), language, "bean", bean);
                ExpressionBuilder.setProperty(exchange.getContext(), language, "method", expression);
                return language.createExpression(null).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "bean(" + bean + ", " + expression + ")";
            }
        };
    }

    public static Expression parseSimpleOrFallbackToConstantExpression(String str, CamelContext camelContext) {
        if (StringHelper.hasStartToken((String)str, (String)"simple")) {
            return camelContext.resolveLanguage("simple").createExpression(str);
        }
        return ExpressionBuilder.constantExpression(str);
    }

    public static Expression propertiesComponentExpression(final String key, final String defaultValue) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String text = (String)ExpressionBuilder.simpleExpression(key).evaluate(exchange, String.class);
                try {
                    PropertiesComponent pc = exchange.getContext().getPropertiesComponent();
                    return pc.parseUri("{{" + text + "}}");
                }
                catch (Exception e) {
                    if (defaultValue != null) {
                        return defaultValue;
                    }
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }

            public String toString() {
                return "properties(" + key + ")";
            }
        };
    }

    public static Expression tokenizePairExpression(String startToken, String endToken, boolean includeTokens) {
        return new TokenPairExpressionIterator(startToken, endToken, includeTokens);
    }

    public static Expression tokenizeXMLExpression(String tagName, String inheritNamespaceTagName) {
        StringHelper.notEmpty((String)tagName, (String)"tagName");
        return new TokenXMLExpressionIterator(tagName, inheritNamespaceTagName);
    }

    public static Expression tokenizeXMLAwareExpression(String path, char mode) {
        return ExpressionBuilder.tokenizeXMLAwareExpression(null, path, mode, 1, null);
    }

    public static Expression tokenizeXMLAwareExpression(String path, char mode, int group) {
        return ExpressionBuilder.tokenizeXMLAwareExpression(null, path, mode, group, null);
    }

    public static Expression tokenizeXMLAwareExpression(String path, char mode, int group, Namespaces namespaces) {
        return ExpressionBuilder.tokenizeXMLAwareExpression(null, path, mode, group, namespaces);
    }

    public static Expression tokenizeXMLAwareExpression(final String headerName, final String path, final char mode, final int group, final Namespaces namespaces) {
        StringHelper.notEmpty((String)path, (String)"path");
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Language language = exchange.getContext().resolveLanguage("xtokenize");
                if (headerName != null) {
                    ExpressionBuilder.setProperty(exchange.getContext(), language, "headerName", headerName);
                }
                if (mode != 'i') {
                    ExpressionBuilder.setProperty(exchange.getContext(), language, "mode", Character.valueOf(mode));
                }
                if (group > 1) {
                    ExpressionBuilder.setProperty(exchange.getContext(), language, "group", group);
                }
                if (namespaces != null) {
                    ExpressionBuilder.setProperty(exchange.getContext(), language, "namespaces", namespaces);
                }
                ExpressionBuilder.setProperty(exchange.getContext(), language, "path", path);
                return language.createExpression(null).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "xtokenize(" + path + ")";
            }
        };
    }

    public static Expression bodyOneLine() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String body = (String)exchange.getIn().getBody(String.class);
                if (body == null) {
                    return null;
                }
                body = StringHelper.replaceAll((String)body, (String)System.lineSeparator(), (String)"");
                return body;
            }

            public String toString() {
                return "bodyOneLine()";
            }
        };
    }

    protected static void setProperty(CamelContext camelContext, Object bean, String name, Object value) {
        try {
            ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection().setProperty(camelContext, bean, name, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to set property " + name + " on " + bean + ". Reason: " + e, e);
        }
    }
}

