/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CatalogCamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.LoadPropertiesException;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.support.JSonSchemaHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelContextHelper {
    public static final String COMPONENT_BASE = "META-INF/services/org/apache/camel/component/";
    public static final String COMPONENT_DESCRIPTOR = "META-INF/services/org/apache/camel/component.properties";
    public static final String COMPONENT_DOCUMENTATION_PREFIX = "org/apache/camel/component/";
    public static final String MODEL_DESCRIPTOR = "META-INF/services/org/apache/camel/model.properties";
    public static final String MODEL_DOCUMENTATION_PREFIX = "org/apache/camel/model/";
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextHelper.class);

    private CamelContextHelper() {
    }

    public static Endpoint getMandatoryEndpoint(CamelContext camelContext, String uri) throws NoSuchEndpointException {
        Endpoint endpoint = camelContext.getEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public static <T extends Endpoint> T getMandatoryEndpoint(CamelContext camelContext, String uri, Class<T> type) {
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(camelContext, uri);
        return (T)((Endpoint)ObjectHelper.cast(type, (Object)endpoint));
    }

    public static <T> T convertTo(CamelContext context, Class<T> type, Object value) {
        ObjectHelper.notNull((Object)context, (String)"camelContext");
        return (T)context.getTypeConverter().convertTo(type, value);
    }

    public static <T> T tryConvertTo(CamelContext context, Class<T> type, Object value) {
        ObjectHelper.notNull((Object)context, (String)"camelContext");
        return (T)context.getTypeConverter().tryConvertTo(type, value);
    }

    public static <T> T mandatoryConvertTo(CamelContext context, Class<T> type, Object value) {
        T answer = CamelContextHelper.convertTo(context, type, value);
        if (answer == null) {
            throw new IllegalArgumentException("Value " + value + " converted to " + type.getName() + " cannot be null");
        }
        return answer;
    }

    public static <T> T newInstance(CamelContext context, Class<T> beanType) {
        return (T)context.getInjector().newInstance(beanType);
    }

    public static Object lookup(CamelContext context, String name) {
        return context.getRegistry().lookupByName(name);
    }

    public static <T> T lookup(CamelContext context, String name, Class<T> beanType) {
        return (T)context.getRegistry().lookupByNameAndType(name, beanType);
    }

    public static <T> T lookupAndConvert(CamelContext context, String name, Class<T> beanType) {
        return CamelContextHelper.tryConvertTo(context, beanType, CamelContextHelper.lookup(context, name));
    }

    public static <T> T findByType(CamelContext camelContext, Class<T> type) {
        Set set = camelContext.getRegistry().findByType(type);
        if (set.size() == 1) {
            return (T)set.iterator().next();
        }
        return null;
    }

    public static Object mandatoryLookup(CamelContext context, String name) {
        Object answer = CamelContextHelper.lookup(context, name);
        if (answer == null) {
            throw new NoSuchBeanException(name);
        }
        return answer;
    }

    public static <T> T mandatoryLookup(CamelContext context, String name, Class<T> beanType) {
        T answer = CamelContextHelper.lookup(context, name, beanType);
        if (answer == null) {
            throw new NoSuchBeanException(name, beanType.getName());
        }
        return answer;
    }

    public static <T> T mandatoryLookupAndConvert(CamelContext context, String name, Class<T> beanType) {
        Object value = CamelContextHelper.lookup(context, name);
        if (value == null) {
            throw new NoSuchBeanException(name, beanType.getName());
        }
        return CamelContextHelper.convertTo(context, beanType, value);
    }

    public static Endpoint getEndpointInjection(CamelContext camelContext, String uri, String injectionPointName, boolean mandatory) {
        Endpoint endpoint = ObjectHelper.isNotEmpty((Object)uri) ? camelContext.getEndpoint(uri) : (mandatory ? CamelContextHelper.mandatoryLookup(camelContext, injectionPointName, Endpoint.class) : CamelContextHelper.lookup(camelContext, injectionPointName, Endpoint.class));
        return endpoint;
    }

    public static int getMaximumCachePoolSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumCachePoolSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumCachePoolSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumCachePoolSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumEndpointCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumEndpointCacheSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumEndpointCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumEndpointCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumSimpleCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumSimpleCacheSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumSimpleCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumSimpleCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumTransformerCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumTransformerCacheSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumTransformerCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumTransformerCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static int getMaximumValidatorCacheSize(CamelContext camelContext) throws IllegalArgumentException {
        String s;
        if (camelContext != null && (s = camelContext.getGlobalOption("CamelMaximumValidatorCacheSize")) != null) {
            try {
                Integer size = Integer.valueOf(s);
                if (size == null || size <= 0) {
                    throw new IllegalArgumentException("Property CamelMaximumValidatorCacheSize must be a positive number, was: " + s);
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Property CamelMaximumValidatorCacheSize must be a positive number, was: " + s, e);
            }
        }
        return 1000;
    }

    public static String parseText(CamelContext camelContext, String text) throws Exception {
        return camelContext.resolvePropertyPlaceholders(text);
    }

    public static Integer parseInteger(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return (Integer)camelContext.getTypeConverter().mandatoryConvertTo(Integer.class, (Object)s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as an Integer.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as an Integer.", e);
            }
        }
        return null;
    }

    public static Long parseLong(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return (Long)camelContext.getTypeConverter().mandatoryConvertTo(Long.class, (Object)s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as a Long.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as a Long.", e);
            }
        }
        return null;
    }

    public static Double parseDouble(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            try {
                return (Double)camelContext.getTypeConverter().mandatoryConvertTo(Double.class, (Object)s);
            }
            catch (NumberFormatException e) {
                if (s.equals(text)) {
                    throw new IllegalArgumentException("Error parsing [" + s + "] as an Integer.", e);
                }
                throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as an Integer.", e);
            }
        }
        return null;
    }

    public static Boolean parseBoolean(CamelContext camelContext, String text) throws Exception {
        String s = camelContext.resolvePropertyPlaceholders(text);
        if (s != null) {
            if ((s = s.trim().toLowerCase(Locale.ENGLISH)).equals("true") || s.equals("false")) {
                return "true".equals(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (s.equals(text)) {
                throw new IllegalArgumentException("Error parsing [" + s + "] as a Boolean.");
            }
            throw new IllegalArgumentException("Error parsing [" + s + "] from property " + text + " as a Boolean.");
        }
        return null;
    }

    public static SortedMap<String, Properties> findComponents(CamelContext camelContext) throws LoadPropertiesException {
        ClassResolver resolver = camelContext.getClassResolver();
        LOG.debug("Finding all components using class resolver: {} -> {}", (Object)resolver);
        Enumeration iter = resolver.loadAllResourcesAsURL(COMPONENT_DESCRIPTOR);
        return CamelContextHelper.findComponents(camelContext, iter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedMap<String, Properties> findComponents(CamelContext camelContext, Enumeration<URL> componentDescriptionIter) throws LoadPropertiesException {
        TreeMap<String, Properties> map = new TreeMap<String, Properties>();
        while (componentDescriptionIter != null && componentDescriptionIter.hasMoreElements()) {
            URL url = componentDescriptionIter.nextElement();
            LOG.trace("Finding components in url: {}", (Object)url);
            try {
                Properties properties = new Properties();
                properties.load(url.openStream());
                String names = properties.getProperty("components");
                if (names == null) continue;
                StringTokenizer tok = new StringTokenizer(names);
                while (tok.hasMoreTokens()) {
                    String name = tok.nextToken();
                    String className = null;
                    InputStream is = null;
                    try {
                        Enumeration urls = camelContext.getClassResolver().loadAllResourcesAsURL(COMPONENT_BASE + name);
                        if (urls != null && urls.hasMoreElements()) {
                            is = ((URL)urls.nextElement()).openStream();
                        }
                        if (is != null) {
                            Properties compProperties = new Properties();
                            compProperties.load(is);
                            if (!compProperties.isEmpty()) {
                                className = compProperties.getProperty("class");
                            }
                        }
                    }
                    catch (Exception urls) {
                    }
                    finally {
                        IOHelper.close(is);
                    }
                    Properties prop = new Properties();
                    prop.putAll((Map<?, ?>)properties);
                    if (camelContext.hasComponent(name) != null) {
                        prop.put("component", camelContext.getComponent(name));
                    }
                    if (className != null) {
                        prop.put("class", className);
                    }
                    prop.put("name", name);
                    map.put(name, prop);
                }
            }
            catch (IOException e) {
                throw new LoadPropertiesException(url, (Exception)e);
            }
        }
        List names = camelContext.getComponentNames();
        for (String name : names) {
            Component component;
            if (map.containsKey(name) || (component = camelContext.getComponent(name)) == null) continue;
            Properties properties = new Properties();
            properties.put("component", component);
            properties.put("class", component.getClass().getName());
            properties.put("name", name);
            map.put(name, properties);
        }
        Map beanMap = camelContext.getRegistry().findByTypeWithName(Component.class);
        Set entries = beanMap.entrySet();
        for (Map.Entry entry : entries) {
            Component component;
            String name = (String)entry.getKey();
            if (map.containsKey(name) || (component = (Component)entry.getValue()) == null) continue;
            Properties properties = new Properties();
            properties.put("component", component);
            properties.put("class", component.getClass().getName());
            properties.put("name", name);
            map.put(name, properties);
        }
        return map;
    }

    public static SortedMap<String, Properties> findEips(CamelContext camelContext) throws LoadPropertiesException {
        TreeMap<String, Properties> answer = new TreeMap<String, Properties>();
        ClassResolver resolver = camelContext.getClassResolver();
        LOG.debug("Finding all EIPs using class resolver: {} -> {}", (Object)resolver);
        URL url = resolver.loadResourceAsURL(MODEL_DESCRIPTOR);
        if (url != null) {
            InputStream is = null;
            try {
                String[] lines;
                is = url.openStream();
                String all = IOHelper.loadText((InputStream)is);
                for (String line : lines = all.split("\n")) {
                    if (line.startsWith("#")) continue;
                    Properties prop = new Properties();
                    prop.put("name", line);
                    String description = null;
                    String label = null;
                    String javaType = null;
                    String title = null;
                    String json = ((CatalogCamelContext)camelContext.adapt(CatalogCamelContext.class)).explainEipJson(line, false);
                    if (json != null) {
                        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
                        for (Map<String, String> row : rows) {
                            if (row.get("title") != null) {
                                title = row.get("title");
                            }
                            if (row.get("description") != null) {
                                description = row.get("description");
                            }
                            if (row.get("label") != null) {
                                label = row.get("label");
                            }
                            if (row.get("javaType") == null) continue;
                            javaType = row.get("javaType");
                        }
                    }
                    if (title != null) {
                        prop.put("title", title);
                    }
                    if (description != null) {
                        prop.put("description", description);
                    }
                    if (label != null) {
                        prop.put("label", label);
                    }
                    if (javaType != null) {
                        prop.put("class", javaType);
                    }
                    answer.put(line, prop);
                }
            }
            catch (IOException e) {
                throw new LoadPropertiesException(url, (Exception)e);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
        return answer;
    }

    public static int getRouteStartupOrder(CamelContext camelContext, String routeId) {
        for (RouteStartupOrder order : camelContext.getRouteStartupOrder()) {
            if (!order.getRoute().getId().equals(routeId)) continue;
            return order.getStartupOrder();
        }
        return 0;
    }

    public static Properties getCamelPropertiesWithPrefix(String prefix, CamelContext camelContext) {
        Properties answer = new Properties();
        Map camelProperties = camelContext.getGlobalOptions();
        if (camelProperties != null) {
            for (Map.Entry entry : camelProperties.entrySet()) {
                String key = (String)entry.getKey();
                if (key == null || !key.startsWith(prefix)) continue;
                answer.put(key.substring(prefix.length()), entry.getValue());
            }
        }
        return answer;
    }
}

