/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.BytesSource;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.StringSource;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.StreamCacheConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

public class StreamCacheConverterLoader
implements TypeConverterLoader {
    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap(11);

    private void registerConverters() {
        this.converters.put(byte[].class, StreamCache.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToByteArray((StreamCache)value, exchange);
            }
        });
        this.converters.put(Serializable.class, StreamCache.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToSerializable((StreamCache)value, exchange);
            }
        });
        this.converters.put(ByteBuffer.class, StreamCache.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToByteBuffer((StreamCache)value, exchange);
            }
        });
        this.converters.put(StreamCache.class, ByteArrayInputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((ByteArrayInputStream)value, exchange);
            }
        });
        this.converters.put(StreamCache.class, InputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((InputStream)value, exchange);
            }
        });
        this.converters.put(StreamCache.class, Reader.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((Reader)value, exchange);
            }
        });
        this.converters.put(StreamCache.class, SAXSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((SAXSource)value, exchange);
            }
        });
        this.converters.put(StreamCache.class, BytesSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((BytesSource)value);
            }
        });
        this.converters.put(StreamCache.class, StringSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((StringSource)value);
            }
        });
        this.converters.put(StreamCache.class, StreamSource.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((StreamSource)value, exchange);
            }
        });
        this.converters.put(StreamCache.class, CachedOutputStream.class, (Object)new BaseTypeConverter(false){

            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return StreamCacheConverter.convertToStreamCache((CachedOutputStream)value, exchange);
            }
        });
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters();
        this.converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, (TypeConverter)c));
    }

    static abstract class BaseTypeConverter
    extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        @Override
        public boolean allowNull() {
            return this.allowNull;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T)this.doConvert(exchange, value);
            }
            catch (TypeConversionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TypeConversionException(value, type, (Throwable)e);
            }
        }

        protected abstract Object doConvert(Exchange var1, Object var2) throws Exception;
    }
}

