/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.support.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyPlaceholdersHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyPlaceholdersHelper.class);

    private PropertyPlaceholdersHelper() {
    }

    public static void resolvePropertyPlaceholders(CamelContext camelContext, Object object) throws Exception {
        LOG.trace("Resolving property placeholders for: {}", object);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        IntrospectionSupport.getProperties(object, properties, null);
        if (!properties.isEmpty()) {
            LOG.trace("There are {} properties on: {}", (Object)properties.size(), object);
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof String)) continue;
                String text = (String)value;
                if ((text = camelContext.resolvePropertyPlaceholders(text)) == value) continue;
                boolean changed = IntrospectionSupport.setProperty(camelContext.getTypeConverter(), object, name, (Object)text);
                if (!changed) {
                    throw new IllegalArgumentException("No setter to set property: " + name + " to: " + text + " on: " + object);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Changed property [{}] from: {} to: {}", new Object[]{name, value, text});
            }
        }
    }
}

