/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stub;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.component.seda.BlockingQueueFactory;
import org.apache.camel.component.stub.StubEndpoint;
import org.apache.camel.component.vm.VmComponent;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.NormalizedUri;

@org.apache.camel.spi.annotations.Component(value="stub")
public class StubComponent
extends VmComponent {
    @Metadata
    private boolean shadow;

    protected void validateURI(String uri, String path, Map<String, Object> parameters) {
    }

    protected void validateParameters(String uri, Map<String, Object> parameters, String optionPrefix) {
    }

    protected StubEndpoint createEndpoint(String endpointUri, Component component, BlockingQueueFactory<Exchange> queueFactory, int concurrentConsumers) {
        return new StubEndpoint(endpointUri, component, queueFactory, concurrentConsumers);
    }

    protected StubEndpoint createEndpoint(String endpointUri, Component component, BlockingQueue<Exchange> queue, int concurrentConsumers) {
        return new StubEndpoint(endpointUri, component, queue, concurrentConsumers);
    }

    protected String resolveShadowUri(String uri) {
        if (uri.startsWith("stub://")) {
            uri = uri.substring(7);
        } else if (uri.startsWith("stub:")) {
            uri = uri.substring(5);
        }
        return uri;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.shadow) {
            EndpointRegistry registry = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getEndpointRegistry();
            ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).registerEndpointCallback((uri, endpoint) -> {
                String shadowUri = this.resolveShadowUri(uri);
                if (!uri.equals(shadowUri)) {
                    NormalizedUri nuri = NormalizedUri.newNormalizedUri((String)shadowUri, (boolean)false);
                    registry.put((Object)nuri, (Object)endpoint);
                }
                return endpoint;
            });
        }
    }
}

