/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch.client;

import org.apache.camel.component.stitch.client.StitchClientImpl;
import org.apache.camel.component.stitch.client.StitchRegion;
import org.apache.camel.util.ObjectHelper;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

public final class StitchClientBuilder {
    private HttpClient httpClient;
    private String token;
    private ConnectionProvider connectionProvider;
    private StitchRegion region;

    private StitchClientBuilder() {
    }

    public static StitchClientBuilder builder() {
        return new StitchClientBuilder();
    }

    public StitchClientBuilder withHttpClient(HttpClient httpClient) {
        if (ObjectHelper.isNotEmpty((Object)httpClient)) {
            this.httpClient = httpClient;
        }
        return this;
    }

    public StitchClientBuilder withToken(String token) {
        if (ObjectHelper.isNotEmpty((String)token)) {
            this.token = token;
        }
        return this;
    }

    public StitchClientBuilder withConnectionProvider(ConnectionProvider connectionProvider) {
        if (ObjectHelper.isNotEmpty((Object)connectionProvider)) {
            this.connectionProvider = connectionProvider;
        }
        return this;
    }

    public StitchClientBuilder withRegion(StitchRegion region) {
        if (ObjectHelper.isNotEmpty((Object)((Object)region))) {
            this.region = region;
        }
        return this;
    }

    public StitchClientImpl build() {
        if (ObjectHelper.isEmpty((String)this.token) || ObjectHelper.isEmpty((Object)((Object)this.region))) {
            throw new IllegalArgumentException("Token or Region cannot be empty!");
        }
        if (ObjectHelper.isNotEmpty((Object)this.httpClient)) {
            return new StitchClientImpl(this.httpClient, this.getBaseUrl(this.region), this.token);
        }
        if (ObjectHelper.isNotEmpty((Object)this.connectionProvider)) {
            return new StitchClientImpl(HttpClient.create((ConnectionProvider)this.connectionProvider), this.getBaseUrl(this.region), this.token);
        }
        return new StitchClientImpl(HttpClient.create(), this.getBaseUrl(this.region), this.token);
    }

    private String getBaseUrl(StitchRegion stitchRegion) {
        return "https://" + stitchRegion.getUrl();
    }
}

