/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch.client.models;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.component.stitch.client.models.StitchModel;
import org.apache.camel.util.ObjectHelper;

public final class StitchSchema
implements StitchModel {
    private final Map<String, Object> keywords;

    private StitchSchema(Map<String, Object> keywords) {
        this.keywords = keywords;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Object> getKeywords() {
        return this.keywords;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.getKeywords();
    }

    public static final class Builder {
        private Map<String, Object> keywords = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public Builder addKeywords(Map<String, Object> keywords) {
            if (ObjectHelper.isNotEmpty(keywords)) {
                this.keywords.putAll(keywords);
            }
            return this;
        }

        public Builder addKeyword(String key, Object value) {
            if (ObjectHelper.isNotEmpty((String)key)) {
                this.keywords.put(key, value);
            }
            return this;
        }

        public StitchSchema build() {
            return new StitchSchema(this.keywords);
        }
    }
}

