/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch;

import org.apache.camel.spi.Metadata;

public final class StitchConstants {
    private static final String HEADER_PREFIX = "CamelStitch";
    @Metadata(label="producer", description="The name of the destination table the data is being pushed to. Table names must be unique in each destination schema, or loading issues will occur. Note: The number of characters in the table name should be within the destinations allowed limits or data will rejected.", javaType="String")
    public static final String TABLE_NAME = "CamelStitchTableName";
    @Metadata(label="producer", description="The schema that describes the Stitch message", javaType="StitchSchema or Map")
    public static final String SCHEMA = "CamelStitchSchema";
    @Metadata(label="producer", description="A collection of strings representing the Primary Key fields in the source table. Stitch use these Primary Keys to de-dupe data during loading If not provided, the table will be loaded in an append-only manner.", javaType="Collection<String>")
    public static final String KEY_NAMES = "CamelStitchKeyNames";
    @Metadata(label="producer", description="HTTP Status code that is returned from Stitch Import HTTP API.", javaType="Integer")
    public static final String CODE = "CamelStitchCode";
    @Metadata(label="producer", description="HTTP headers that are returned from Stitch Import HTTP API.", javaType="Map<String, Object>")
    public static final String HEADERS = "CamelStitchHeaders";
    @Metadata(label="producer", description="The status message that Stitch returns after sending the data through Stitch Import API.", javaType="String")
    public static final String STATUS = "CamelStitchStatus";

    private StitchConstants() {
    }
}

