/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored;

import java.sql.SQLException;
import org.apache.camel.component.sql.stored.BatchCallableStatementCreatorFactory;
import org.apache.camel.component.sql.stored.CallableStatementWrapper;
import org.apache.camel.component.sql.stored.StatementWrapper;
import org.apache.camel.component.sql.stored.TemplateStoredProcedure;
import org.apache.camel.component.sql.stored.template.TemplateParser;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.LRUCache;
import org.springframework.jdbc.core.JdbcTemplate;

public class CallableStatementWrapperFactory
extends ServiceSupport {
    public static final int TEMPLATE_CACHE_DEFAULT_SIZE = 200;
    public static final int BATCH_TEMPLATE_CACHE_DEFAULT_SIZE = 200;
    final JdbcTemplate jdbcTemplate;
    final TemplateParser templateParser;
    private final LRUCache<String, TemplateStoredProcedure> templateCache = new LRUCache(200);
    private final LRUCache<String, BatchCallableStatementCreatorFactory> batchTemplateCache = new LRUCache(200);

    public CallableStatementWrapperFactory(JdbcTemplate jdbcTemplate, TemplateParser templateParser) {
        this.jdbcTemplate = jdbcTemplate;
        this.templateParser = templateParser;
    }

    public StatementWrapper create(String sql) throws SQLException {
        return new CallableStatementWrapper(sql, this);
    }

    public BatchCallableStatementCreatorFactory getTemplateForBatch(String sql) {
        BatchCallableStatementCreatorFactory template = (BatchCallableStatementCreatorFactory)this.batchTemplateCache.get((Object)sql);
        if (template != null) {
            return template;
        }
        template = new BatchCallableStatementCreatorFactory(this.templateParser.parseTemplate(sql));
        this.batchTemplateCache.put((Object)sql, (Object)template);
        return template;
    }

    public TemplateStoredProcedure getTemplateStoredProcedure(String sql) {
        TemplateStoredProcedure templateStoredProcedure = (TemplateStoredProcedure)((Object)this.templateCache.get((Object)sql));
        if (templateStoredProcedure != null) {
            return templateStoredProcedure;
        }
        templateStoredProcedure = new TemplateStoredProcedure(this.jdbcTemplate, this.templateParser.parseTemplate(sql));
        this.templateCache.put((Object)sql, (Object)templateStoredProcedure);
        return templateStoredProcedure;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        try {
            this.templateCache.clear();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.batchTemplateCache.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

