/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.Dictionary;
import java.util.EventObject;
import java.util.Hashtable;
import org.apache.camel.support.EventNotifierSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiEventAdminNotifier
extends EventNotifierSupport {
    public static final String TYPE = "type";
    public static final String EVENT = "event";
    public static final String TIMESTAMP = "timestamp";
    public static final String BUNDLE = "bundle";
    public static final String BUNDLE_ID = "bundle.id";
    public static final String BUNDLE_SYMBOLICNAME = "bundle.symbolicName";
    public static final String BUNDLE_VERSION = "bundle.version";
    public static final String CAUSE = "cause";
    public static final String TOPIC_CAMEL_EVENTS = "org/apache/camel/";
    public static final String TOPIC_CAMEL_CONTEXT_EVENTS = "org/apache/camel/context/";
    public static final String TOPIC_CAMEL_EXCHANGE_EVENTS = "org/apache/camel/exchange/";
    public static final String TOPIC_CAMEL_SERVICE_EVENTS = "org/apache/camel/service/";
    public static final String TOPIC_CAMEL_ROUTE_EVENTS = "org/apache/camel/route/";
    private final BundleContext bundleContext;
    private final ServiceTracker tracker;

    public OsgiEventAdminNotifier(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.tracker = new ServiceTracker(bundleContext, EventAdmin.class.getName(), null);
        this.setIgnoreExchangeEvents(true);
    }

    public void notify(EventObject event) throws Exception {
        EventAdmin eventAdmin = (EventAdmin)this.tracker.getService();
        if (eventAdmin == null) {
            return;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put(TYPE, OsgiEventAdminNotifier.getType(event));
        ((Dictionary)props).put(EVENT, event);
        ((Dictionary)props).put(TIMESTAMP, System.currentTimeMillis());
        ((Dictionary)props).put(BUNDLE, this.bundleContext.getBundle());
        ((Dictionary)props).put(BUNDLE_SYMBOLICNAME, this.bundleContext.getBundle().getSymbolicName());
        ((Dictionary)props).put(BUNDLE_ID, this.bundleContext.getBundle().getBundleId());
        ((Dictionary)props).put(BUNDLE_VERSION, OsgiEventAdminNotifier.getBundleVersion(this.bundleContext.getBundle()));
        try {
            ((Dictionary)props).put(CAUSE, event.getClass().getMethod("getCause", new Class[0]).invoke((Object)event, new Object[0]));
        }
        catch (Throwable t) {
            // empty catch block
        }
        eventAdmin.postEvent(new Event(OsgiEventAdminNotifier.getTopic(event), props));
    }

    public boolean isEnabled(EventObject event) {
        return true;
    }

    protected void doStart() throws Exception {
        this.tracker.open();
    }

    protected void doStop() throws Exception {
        this.tracker.close();
    }

    public static String toUpper(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isUpperCase(c) && sb.length() > 0) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }

    public static String getType(EventObject event) {
        String type = event.getClass().getSimpleName();
        if (type.endsWith("Event")) {
            type = type.substring(0, type.length() - "Event".length());
        }
        return type;
    }

    public static String getTopic(EventObject event) {
        String topic;
        String type = OsgiEventAdminNotifier.getType(event);
        if (type.startsWith("CamelContext")) {
            topic = TOPIC_CAMEL_CONTEXT_EVENTS;
            type = type.substring("CamelContext".length());
        } else if (type.startsWith("Exchange")) {
            topic = TOPIC_CAMEL_EXCHANGE_EVENTS;
            type = type.substring("Exchange".length());
        } else if (type.startsWith("Route")) {
            topic = TOPIC_CAMEL_ROUTE_EVENTS;
            type = type.substring("Route".length());
        } else if (type.startsWith("Service")) {
            topic = TOPIC_CAMEL_SERVICE_EVENTS;
            type = type.substring("Service".length());
        } else {
            topic = "org/apache/camel/unknown/";
        }
        topic = topic + OsgiEventAdminNotifier.toUpper(type);
        return topic;
    }

    public static Version getBundleVersion(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String version = (String)headers.get("Bundle-Version");
        return version != null ? Version.parseVersion((String)version) : Version.emptyVersion;
    }
}

