/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.FactoryBean;

@XmlRootElement(name="endpoint")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EndpointFactoryBean
extends IdentifiedType
implements FactoryBean,
CamelContextAware {
    @XmlAttribute
    private String uri;
    @XmlTransient
    private CamelContext context;
    @XmlTransient
    private Endpoint endpoint;
    @XmlTransient
    private boolean singleton;

    public Object getObject() throws Exception {
        if (this.endpoint == null) {
            this.endpoint = this.createEndpoint();
        }
        return this.endpoint;
    }

    public Class getObjectType() {
        return Endpoint.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext context) {
        this.context = context;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    protected Endpoint createEndpoint() {
        ObjectHelper.notNull((Object)this.context, (String)"context");
        ObjectHelper.notNull((Object)this.uri, (String)"uri");
        Endpoint endpoint = this.context.getEndpoint(this.uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(this.uri);
        }
        return endpoint;
    }
}

