/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Routes;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.model.RouteType;
import org.apache.camel.processor.interceptor.Debugger;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.view.RouteDotGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
extends ServiceSupport {
    private static final Log LOG = LogFactory.getLog(Main.class);
    private String applicationContextUri = "META-INF/spring/*.xml";
    private String fileApplicationContextUri;
    private AbstractApplicationContext applicationContext;
    private List<Option> options = new ArrayList<Option>();
    private CountDownLatch latch = new CountDownLatch(1);
    private AtomicBoolean completed = new AtomicBoolean(false);
    private long duration = -1L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private String dotOutputDir;
    private boolean aggregateDot;
    private boolean debug;
    private boolean trace;
    private List<RouteBuilder> routeBuilders = new ArrayList<RouteBuilder>();
    private List<SpringCamelContext> camelContexts = new ArrayList<SpringCamelContext>();
    private AbstractApplicationContext parentApplicationContext;
    private String parentApplicationContextUri;
    private ProducerTemplate camelTemplate;

    public Main() {
        this.addOption(new Option("h", "help", "Displays the help screen"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                Main.this.showOptions();
                Main.this.completed();
            }
        });
        this.addOption(new ParameterOption("a", "applicationContext", "Sets the classpath based spring ApplicationContext", "applicationContext"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setApplicationContextUri(parameter);
            }
        });
        this.addOption(new ParameterOption("fa", "fileApplicationContext", "Sets the filesystem based spring ApplicationContext", "fileApplicationContext"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setFileApplicationContextUri(parameter);
            }
        });
        this.addOption(new ParameterOption("o", "outdir", "Sets the DOT output directory where the visual representations of the routes are generated", "dot"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setDotOutputDir(parameter);
            }
        });
        this.addOption(new ParameterOption("ad", "aggregate-dot", "Aggregates all routes (in addition to individual route generation) into one context to create one monolithic DOT file for visual representations the entire system.", "aggregate-dot"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setAggregateDot("true".equals(parameter));
            }
        });
        this.addOption(new ParameterOption("d", "duration", "Sets the time duration that the applicaiton will run for, by default in milliseconds. You can use '10s' for 10 seconds etc", "duration"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                String value = parameter.toUpperCase();
                if (value.endsWith("S")) {
                    value = value.substring(0, value.length() - 1);
                    Main.this.setTimeUnit(TimeUnit.SECONDS);
                }
                Main.this.setDuration(Integer.parseInt(value));
            }
        });
        this.addOption(new Option("x", "debug", "Enables the debugger"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                Main.this.enableDebug();
            }
        });
        this.addOption(new Option("t", "trace", "Enables tracing"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                Main.this.enableTrace();
            }
        });
    }

    public static void main(String ... args) {
        new Main().run(args);
    }

    public void run(String[] args) {
        this.parseArguments(args);
        this.run();
    }

    public void run() {
        if (!this.completed.get()) {
            try {
                this.start();
                this.waitUntilCompleted();
                this.stop();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed: " + e), (Throwable)e);
            }
        }
    }

    public void completed() {
        this.completed.set(true);
        this.latch.countDown();
    }

    public void addRouteBuilder(RouteBuilder routeBuilder) {
        this.getRouteBuilders().add(routeBuilder);
    }

    public void showOptions() {
        System.out.println("Apache Camel Runner takes the following options");
        System.out.println();
        for (Option option : this.options) {
            System.out.println("  " + option.getAbbreviation() + " or " + option.getFullName() + " = " + option.getDescription());
        }
    }

    public void parseArguments(String[] arguments) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        boolean valid = true;
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            boolean handled = false;
            for (Option option : this.options) {
                if (!option.processOption(arg, args)) continue;
                handled = true;
                break;
            }
            if (handled) continue;
            System.out.println("Unknown option: " + arg);
            System.out.println();
            valid = false;
            break;
        }
        if (!valid) {
            this.showOptions();
            this.completed();
        }
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    public AbstractApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(AbstractApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getApplicationContextUri() {
        return this.applicationContextUri;
    }

    public void setApplicationContextUri(String applicationContextUri) {
        this.applicationContextUri = applicationContextUri;
    }

    public String getFileApplicationContextUri() {
        return this.fileApplicationContextUri;
    }

    public void setFileApplicationContextUri(String fileApplicationContextUri) {
        this.fileApplicationContextUri = fileApplicationContextUri;
    }

    public AbstractApplicationContext getParentApplicationContext() {
        if (this.parentApplicationContext == null && this.parentApplicationContextUri != null) {
            this.parentApplicationContext = new ClassPathXmlApplicationContext(this.parentApplicationContextUri);
            this.parentApplicationContext.start();
        }
        return this.parentApplicationContext;
    }

    public void setParentApplicationContext(AbstractApplicationContext parentApplicationContext) {
        this.parentApplicationContext = parentApplicationContext;
    }

    public String getParentApplicationContextUri() {
        return this.parentApplicationContextUri;
    }

    public void setParentApplicationContextUri(String parentApplicationContextUri) {
        this.parentApplicationContextUri = parentApplicationContextUri;
    }

    public List<SpringCamelContext> getCamelContexts() {
        return this.camelContexts;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getDotOutputDir() {
        return this.dotOutputDir;
    }

    public void setDotOutputDir(String dotOutputDir) {
        this.dotOutputDir = dotOutputDir;
    }

    public List<RouteBuilder> getRouteBuilders() {
        return this.routeBuilders;
    }

    public void setRouteBuilders(List<RouteBuilder> routeBuilders) {
        this.routeBuilders = routeBuilders;
    }

    public void setAggregateDot(boolean aggregateDot) {
        this.aggregateDot = aggregateDot;
    }

    public boolean isAggregateDot() {
        return this.aggregateDot;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void enableDebug() {
        this.debug = true;
        this.setParentApplicationContextUri("/META-INF/services/org/apache/camel/spring/debug.xml");
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void enableTrace() {
        this.trace = true;
        this.setParentApplicationContextUri("/META-INF/services/org/apache/camel/spring/trace.xml");
    }

    public Debugger getDebugger() {
        for (SpringCamelContext camelContext : this.camelContexts) {
            Debugger debugger = Debugger.getDebugger((CamelContext)camelContext);
            if (debugger == null) continue;
            return debugger;
        }
        return null;
    }

    public List<RouteType> getRouteDefinitions() {
        ArrayList<RouteType> answer = new ArrayList<RouteType>();
        for (SpringCamelContext camelContext : this.camelContexts) {
            answer.addAll(camelContext.getRouteDefinitions());
        }
        return answer;
    }

    public ProducerTemplate getCamelTemplate() {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.findOrCreateCamelTemplate();
        }
        return this.camelTemplate;
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        String[] names = this.getApplicationContext().getBeanNamesForType(ProducerTemplate.class);
        if (names != null && names.length > 0) {
            return (ProducerTemplate)this.getApplicationContext().getBean(names[0], ProducerTemplate.class);
        }
        Iterator<SpringCamelContext> i$ = this.camelContexts.iterator();
        if (i$.hasNext()) {
            SpringCamelContext camelContext = i$.next();
            return camelContext.createProducerTemplate();
        }
        throw new IllegalArgumentException("No CamelContexts are available so cannot create a ProducerTemplate!");
    }

    protected void doStart() throws Exception {
        LOG.info((Object)("Apache Camel " + this.getVersion() + " starting"));
        if (this.applicationContext == null) {
            this.applicationContext = this.createDefaultApplicationContext();
        }
        this.applicationContext.start();
        this.postProcessContext();
    }

    protected AbstractApplicationContext createDefaultApplicationContext() {
        if (this.getFileApplicationContextUri() != null) {
            String[] args = this.getFileApplicationContextUri().split(";");
            AbstractApplicationContext parentContext = this.getParentApplicationContext();
            if (parentContext != null) {
                return new FileSystemXmlApplicationContext(args, (ApplicationContext)parentContext);
            }
            return new FileSystemXmlApplicationContext(args);
        }
        String[] args = this.getApplicationContextUri().split(";");
        AbstractApplicationContext parentContext = this.getParentApplicationContext();
        if (parentContext != null) {
            return new ClassPathXmlApplicationContext(args, (ApplicationContext)parentContext);
        }
        return new ClassPathXmlApplicationContext(args);
    }

    protected void doStop() throws Exception {
        LOG.info((Object)"Apache Camel terminating");
        if (this.applicationContext != null) {
            this.applicationContext.close();
        }
    }

    protected void waitUntilCompleted() {
        while (!this.completed.get()) {
            try {
                if (this.duration > 0L) {
                    TimeUnit unit = this.getTimeUnit();
                    LOG.info((Object)("Waiting for: " + this.duration + " " + (Object)((Object)unit)));
                    this.latch.await(this.duration, unit);
                    this.completed.set(true);
                    continue;
                }
                this.latch.await();
            }
            catch (InterruptedException e) {
                LOG.debug((Object)("Caught: " + e));
            }
        }
    }

    protected void postProcessContext() throws Exception {
        Map map = this.applicationContext.getBeansOfType(SpringCamelContext.class);
        Set entries = map.entrySet();
        int size = entries.size();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            SpringCamelContext camelContext = (SpringCamelContext)((Object)entry.getValue());
            this.camelContexts.add(camelContext);
            this.generateDot(name, camelContext, size);
            this.postProcesCamelContext((CamelContext)camelContext);
        }
        if (this.isAggregateDot()) {
            this.generateDot("aggregate", Main.aggregateSpringCamelContext((ApplicationContext)this.applicationContext), 1);
        }
    }

    protected void generateDot(String name, SpringCamelContext camelContext, int size) throws IOException {
        String outputDir = this.dotOutputDir;
        if (ObjectHelper.isNotNullAndNonEmpty((String)outputDir)) {
            if (size > 1) {
                outputDir = outputDir + "/" + name;
            }
            RouteDotGenerator generator = new RouteDotGenerator(outputDir);
            LOG.info((Object)("Generating DOT file for routes: " + outputDir + " for: " + (Object)((Object)camelContext) + " with name: " + name));
            generator.drawRoutes((CamelContext)camelContext);
        }
    }

    private static SpringCamelContext aggregateSpringCamelContext(ApplicationContext applicationContext) throws Exception {
        String[] names;
        SpringCamelContext aggregateCamelContext = new SpringCamelContext(){

            protected boolean shouldStartRoutes() {
                return false;
            }
        };
        for (String name : names = applicationContext.getBeanNamesForType(SpringCamelContext.class)) {
            SpringCamelContext next = (SpringCamelContext)((Object)applicationContext.getBean(name, SpringCamelContext.class));
            aggregateCamelContext.addRouteDefinitions(next.getRouteDefinitions());
        }
        return aggregateCamelContext;
    }

    protected void postProcesCamelContext(CamelContext camelContext) throws Exception {
        for (RouteBuilder routeBuilder : this.routeBuilders) {
            camelContext.addRoutes((Routes)routeBuilder);
        }
    }

    protected String getVersion() {
        Package aPackage = Package.getPackage("org.apache.camel");
        if (aPackage != null) {
            String version = aPackage.getImplementationVersion();
            if (version == null && (version = aPackage.getSpecificationVersion()) == null) {
                version = "";
            }
            return version;
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ParameterOption
    extends Option {
        private String parameterName;

        protected ParameterOption(String abbreviation, String fullName, String description, String parameterName) {
            super(abbreviation, fullName, description);
            this.parameterName = parameterName;
        }

        @Override
        protected void doProcess(String arg, LinkedList<String> remainingArgs) {
            if (remainingArgs.isEmpty()) {
                System.err.println("Expected fileName for ");
                Main.this.showOptions();
                Main.this.completed();
            } else {
                String parameter = remainingArgs.removeFirst();
                this.doProcess(arg, parameter, remainingArgs);
            }
        }

        protected abstract void doProcess(String var1, String var2, LinkedList<String> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Option {
        private String abbreviation;
        private String fullName;
        private String description;

        protected Option(String abbreviation, String fullName, String description) {
            this.abbreviation = "-" + abbreviation;
            this.fullName = "-" + fullName;
            this.description = description;
        }

        public boolean processOption(String arg, LinkedList<String> remainingArgs) {
            if (arg.equalsIgnoreCase(this.abbreviation) || this.fullName.startsWith(arg)) {
                this.doProcess(arg, remainingArgs);
                return true;
            }
            return false;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        protected abstract void doProcess(String var1, LinkedList<String> var2);
    }
}

