/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerConsumer
extends DefaultConsumer<Exchange> {
    private static final transient Log LOG = LogFactory.getLog(TimerConsumer.class);
    private final TimerEndpoint endpoint;
    private TimerTask task;

    public TimerConsumer(TimerEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.task = new TimerTask(){

            public void run() {
                TimerConsumer.this.sendTimerExchange();
            }
        };
        Timer timer = this.endpoint.getTimer();
        this.configureTask(this.task, timer);
    }

    protected void doStop() throws Exception {
        this.task.cancel();
    }

    protected void configureTask(TimerTask task, Timer timer) {
        if (this.endpoint.isFixedRate()) {
            if (this.endpoint.getTime() != null) {
                timer.scheduleAtFixedRate(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                timer.scheduleAtFixedRate(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
            }
        } else if (this.endpoint.getTime() != null) {
            if (this.endpoint.getPeriod() >= 0L) {
                timer.schedule(task, this.endpoint.getTime(), this.endpoint.getPeriod());
            } else {
                timer.schedule(task, this.endpoint.getTime());
            }
        } else if (this.endpoint.getPeriod() >= 0L) {
            timer.schedule(task, this.endpoint.getDelay(), this.endpoint.getPeriod());
        } else {
            timer.schedule(task, this.endpoint.getDelay());
        }
    }

    protected void sendTimerExchange() {
        Exchange exchange = this.endpoint.createExchange();
        exchange.setProperty("org.apache.camel.timer.name", (Object)this.endpoint.getTimerName());
        exchange.setProperty("org.apache.camel.timer.time", (Object)this.endpoint.getTime());
        exchange.setProperty("org.apache.camel.timer.period", (Object)this.endpoint.getPeriod());
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOG.error((Object)("Caught: " + e), (Throwable)e);
        }
    }
}

