/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ResolverUtil;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteBuilderFinder {
    private final SpringCamelContext camelContext;
    private final String[] packages;
    private ApplicationContext applicationContext;
    private ResolverUtil resolver = new ResolverUtil();

    public RouteBuilderFinder(SpringCamelContext camelContext, String[] packages) {
        this.camelContext = camelContext;
        this.applicationContext = camelContext.getApplicationContext();
        this.packages = packages;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void appendBuilders(List<RouteBuilder> list) throws IllegalAccessException, InstantiationException {
        this.resolver.findImplementations(RouteBuilder.class, this.packages);
        Set classes = this.resolver.getClasses();
        for (Class aClass : classes) {
            if (this.shouldIgnoreBean(aClass) || !this.isValidClass(aClass)) continue;
            RouteBuilder builder = this.instantiateBuilder(aClass);
            list.add(builder);
        }
    }

    public void destroy() throws Exception {
    }

    protected boolean shouldIgnoreBean(Class type) {
        Map beans = this.applicationContext.getBeansOfType(type, true, true);
        return beans != null && !beans.isEmpty();
    }

    protected boolean isValidClass(Class type) {
        return !Modifier.isAbstract(type.getModifiers()) && !type.isInterface();
    }

    protected RouteBuilder instantiateBuilder(Class type) throws IllegalAccessException, InstantiationException {
        return (RouteBuilder)this.camelContext.getInjector().newInstance(type);
    }
}

