/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.xml;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Expression;
import org.apache.camel.builder.Fluent;
import org.apache.camel.builder.FluentArg;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.spring.xml.BuilderAction;
import org.apache.camel.spring.xml.BuilderStatement;
import org.apache.camel.spring.xml.CamelNamespaceHandler;
import org.apache.camel.spring.xml.IllegalActionException;
import org.apache.camel.spring.xml.MethodInfo;
import org.apache.camel.spring.xml.RouteBuilderFactoryBean;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private final CamelNamespaceHandler namespaceHandler;
    private int counter;

    public CamelBeanDefinitionParser(CamelNamespaceHandler namespaceHandler) {
        this.namespaceHandler = namespaceHandler;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(RouteBuilderFactoryBean.class);
        List childElements = DomUtils.getChildElementsByTagName((Element)element, (String)"route");
        ArrayList<BuilderStatement> routes = new ArrayList<BuilderStatement>(childElements.size());
        if (childElements != null && childElements.size() > 0) {
            for (int i = 0; i < childElements.size(); ++i) {
                Element routeElement = (Element)childElements.get(i);
                ArrayList<BuilderAction> actions = new ArrayList<BuilderAction>();
                Class type = this.parseBuilderElement(parserContext, routeElement, RouteBuilder.class, actions);
                BuilderStatement statement = new BuilderStatement();
                statement.setReturnType(type);
                statement.setActions(actions);
                routes.add(statement);
            }
        }
        factory.addPropertyValue("routes", routes);
        return factory.getBeanDefinition();
    }

    private Class parseBuilderElement(ParserContext parserContext, Element element, Class<RouteBuilder> builder, ArrayList<BuilderAction> actions) {
        Class<?> currentBuilder = builder;
        NodeList childElements = element.getChildNodes();
        Element previousElement = null;
        for (int i = 0; i < childElements.getLength(); ++i) {
            Node node = childElements.item(i);
            if (node.getNodeType() != 1) continue;
            currentBuilder = this.parseAction(parserContext, currentBuilder, actions, (Element)node, previousElement);
            previousElement = (Element)node;
            BuilderAction action = actions.get(actions.size() - 1);
            if (action.getMethodInfo().methodAnnotation.nestedActions()) {
                currentBuilder = this.parseBuilderElement(parserContext, (Element)node, (Class<RouteBuilder>)currentBuilder, actions);
                continue;
            }
            if (!this.hasChildElements(node)) continue;
            throw new IllegalArgumentException("The element " + node.getLocalName() + " should not have any child elements.");
        }
        if (currentBuilder != null) {
            Method[] methods = currentBuilder.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                Fluent annotation = method.getAnnotation(Fluent.class);
                if (annotation == null || !annotation.callOnElementEnd()) continue;
                if (method.getParameterTypes().length > 0) {
                    throw new RuntimeException("Only methods with no parameters can annotated with @Fluent(callOnElementEnd=true): " + method);
                }
                MethodInfo methodInfo = new MethodInfo(method, annotation, new LinkedHashMap<String, Class>(), new LinkedHashMap<String, FluentArg>());
                actions.add(new BuilderAction(methodInfo, new HashMap<String, Object>()));
                currentBuilder = method.getReturnType();
            }
        }
        return currentBuilder;
    }

    private boolean hasChildElements(Node node) {
        NodeList nl = node.getChildNodes();
        for (int j = 0; j < nl.getLength(); ++j) {
            if (nl.item(j).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    private Class parseAction(ParserContext parserContext, Class currentBuilder, ArrayList<BuilderAction> actions, Element element, Element previousElement) {
        String actionName = element.getLocalName();
        ArrayList<MethodInfo> methods = this.findFluentMethodsWithName(currentBuilder, element.getLocalName());
        if (methods.isEmpty()) {
            throw new IllegalActionException(actionName, previousElement == null ? null : previousElement.getLocalName());
        }
        Collections.sort(methods, new Comparator<MethodInfo>(){

            @Override
            public int compare(MethodInfo m1, MethodInfo m2) {
                return m1.method.getParameterTypes().length - m2.method.getParameterTypes().length;
            }
        });
        HashMap<String, Object> attributeArguments = this.getArugmentsFromAttributes(element);
        LinkedHashMap<String, ArrayList<Element>> elementArguments = this.getArgumentsFromElements(element);
        MethodInfo match = null;
        match = this.findMethodMatch(methods, attributeArguments.keySet(), ((HashMap)elementArguments).keySet());
        if (match == null) {
            throw new IllegalActionException(actionName, previousElement == null ? null : previousElement.getLocalName());
        }
        Set<Map.Entry<String, Object>> attributeEntries = attributeArguments.entrySet();
        for (Map.Entry<String, Object> entry : attributeEntries) {
            Object value;
            String name = entry.getKey();
            FluentArg arg = match.parameterAnnotations.get(name);
            if (arg == null || !arg.reference() && !name.equals("ref") || !((value = entry.getValue()) instanceof String)) continue;
            entry.setValue(new RuntimeBeanReference(value.toString()));
        }
        HashSet<String> parameterNames = new HashSet<String>(match.parameters.keySet());
        parameterNames.removeAll(attributeArguments.keySet());
        for (String key : parameterNames) {
            ArrayList<Element> elements = (ArrayList<Element>)((HashMap)elementArguments).get(key);
            if (elements == null) {
                elements = this.getFirstChildElements(element);
            }
            Class clazz = match.parameters.get(key);
            Object value = this.convertTo(parserContext, elements, clazz);
            attributeArguments.put(key, value);
            for (Element el : elements) {
                el.getParentNode().removeChild(el);
            }
        }
        actions.add(new BuilderAction(match, attributeArguments));
        return match.method.getReturnType();
    }

    private ArrayList<Element> getFirstChildElements(Element element) {
        ArrayList<Element> answer = new ArrayList<Element>();
        NodeList list = element.getChildNodes();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            answer.add((Element)node);
            break;
        }
        return answer;
    }

    private Object convertTo(ParserContext parserContext, ArrayList<Element> elements, Class clazz) {
        if (clazz.isArray() || elements.size() > 1) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < elements.size(); ++i) {
                ArrayList<Element> e = new ArrayList<Element>(1);
                e.add(elements.get(i));
                Object value = this.convertTo(parserContext, e, clazz.getComponentType());
                list.add(value);
            }
            return list;
        }
        Element element = elements.get(0);
        String ref = element.getAttribute("ref");
        if (StringUtils.hasText((String)ref)) {
            return new RuntimeBeanReference(ref);
        }
        if (this.hasChildElements(element)) {
            ArrayList<BuilderAction> actions = new ArrayList<BuilderAction>();
            Class<Expression> type = this.parseBuilderElement(parserContext, element, RouteBuilder.class, actions);
            if (type == ValueBuilder.class && clazz == Expression.class) {
                Method method;
                try {
                    method = ValueBuilder.class.getMethod("getExpression", new Class[0]);
                }
                catch (Throwable e) {
                    throw new RuntimeException(ValueBuilder.class.getName() + " does not have the getExpression() method.");
                }
                MethodInfo methodInfo = new MethodInfo(method, null, new LinkedHashMap<String, Class>(), new LinkedHashMap<String, FluentArg>());
                actions.add(new BuilderAction(methodInfo, new HashMap<String, Object>()));
                type = Expression.class;
            }
            BuilderStatement statement = new BuilderStatement();
            statement.setReturnType(type);
            statement.setActions(actions);
            if (!clazz.isAssignableFrom(statement.getReturnType())) {
                throw new IllegalStateException("Builder does not produce object of expected type: " + clazz.getName() + ", it produced: " + statement.getReturnType());
            }
            return statement;
        }
        String name = element.getLocalName();
        if (this.namespaceHandler.getParserElementNames().contains(name)) {
            String id = this.createBeanId(name);
            element.setAttribute("id", id);
            this.namespaceHandler.parse(element, parserContext);
            return new RuntimeBeanReference(id);
        }
        SimpleTypeConverter converter = new SimpleTypeConverter();
        return converter.convertIfNecessary((Object)element.getTextContent(), clazz);
    }

    protected synchronized String createBeanId(String name) {
        return "_internal:camel:bean:" + name + ++this.counter;
    }

    private MethodInfo findMethodMatch(ArrayList<MethodInfo> methods, Set<String> attributeNames, Set<String> elementNames) {
        for (MethodInfo method : methods) {
            boolean miss = false;
            for (String key : attributeNames) {
                FluentArg arg = method.parameterAnnotations.get(key);
                if (arg != null && arg.attribute()) continue;
                miss = true;
                break;
            }
            if (miss) continue;
            HashSet<String> parameterNames = new HashSet<String>(method.parameters.keySet());
            parameterNames.removeAll(attributeNames);
            if (parameterNames.isEmpty()) {
                return method;
            }
            return method;
        }
        return null;
    }

    private LinkedHashMap<String, ArrayList<Element>> getArgumentsFromElements(Element element) {
        LinkedHashMap<String, ArrayList<Element>> elements = new LinkedHashMap<String, ArrayList<Element>>();
        NodeList childNodes = element.getChildNodes();
        String lastTag = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            String tag = el.getLocalName();
            ArrayList<Element> els = elements.get(tag);
            if (els == null) {
                els = new ArrayList();
                elements.put(el.getLocalName(), els);
                els.add(el);
                lastTag = tag;
                continue;
            }
            if (!tag.equals(lastTag)) continue;
            els.add(el);
            lastTag = tag;
        }
        return elements;
    }

    private HashMap<String, Object> getArugmentsFromAttributes(Element element) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        NamedNodeMap childNodes = element.getAttributes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String str;
            Node node = childNodes.item(i);
            if (node.getNodeType() != 2) continue;
            Attr attr = (Attr)node;
            String value = str = attr.getValue();
            if (str.startsWith("#") && !(str = str.substring(1)).startsWith("#")) {
                value = new RuntimeBeanReference(str);
            }
            attributes.put(attr.getName(), value);
        }
        return attributes;
    }

    private ArrayList<MethodInfo> findFluentMethodsWithName(Class clazz, String name) {
        ArrayList<MethodInfo> rc = new ArrayList<MethodInfo>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Fluent fluentAnnotation;
            Method method = methods[i];
            if (!method.isAnnotationPresent(Fluent.class) || !(StringUtils.hasText((String)(fluentAnnotation = method.getAnnotation(Fluent.class)).value()) ? name.equals(fluentAnnotation.value()) : name.equals(method.getName()))) continue;
            LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
            LinkedHashMap<String, FluentArg> amap = new LinkedHashMap<String, FluentArg>();
            Class<?>[] parameters = method.getParameterTypes();
            for (int j = 0; j < parameters.length; ++j) {
                Class<?> parameter = parameters[j];
                FluentArg annotation = this.getParameterAnnotation(FluentArg.class, method, j);
                if (annotation == null) break;
                map.put(annotation.value(), parameter);
                amap.put(annotation.value(), annotation);
            }
            if (parameters.length != map.size()) continue;
            rc.add(new MethodInfo(method, fluentAnnotation, map, amap));
        }
        return rc;
    }

    private <T> T getParameterAnnotation(Class<T> annotationClass, Method method, int index) {
        Annotation[] annotations = method.getParameterAnnotations()[index];
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotationClass.isAssignableFrom(annotations[i].getClass())) continue;
            return (T)annotations[i];
        }
        return null;
    }
}

