/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws.type;

public enum EndpointMappingType {
    ROOT_QNAME("rootqname:"),
    ACTION("action:"),
    TO("to:"),
    SOAP_ACTION("soapaction:"),
    XPATHRESULT("xpathresult:"),
    URI("uri:"),
    URI_PATH("uripath:"),
    BEANNAME("beanname:");

    private final String prefix;

    private EndpointMappingType(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static EndpointMappingType getTypeFromUriPrefix(String uri) {
        if (uri != null) {
            for (EndpointMappingType type : EndpointMappingType.values()) {
                String prefix = type.getPrefix();
                if (!uri.regionMatches(true, 0, prefix, 0, prefix.length())) continue;
                return type;
            }
        }
        return null;
    }
}

