/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.redis.ExchangeConverter;
import org.apache.camel.component.redis.RedisClient;
import org.apache.camel.spi.InvokeOnHeader;
import org.apache.camel.support.HeaderSelectorProducer;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;

public class RedisProducer
extends HeaderSelectorProducer {
    private final ExchangeConverter exchangeConverter = new ExchangeConverter();
    private final RedisClient client;

    public RedisProducer(Endpoint endpoint, String header, String defaultHeaderValue, RedisClient redisClient) {
        super(endpoint, header, defaultHeaderValue);
        this.client = redisClient;
    }

    @InvokeOnHeader(value="ECHO")
    public String invokeEcho(Exchange exchange) {
        return this.client.echo(this.exchangeConverter.getStringValue(exchange));
    }

    @InvokeOnHeader(value="PING")
    public String invokePing(Exchange exchange) {
        return this.client.ping();
    }

    @InvokeOnHeader(value="QUIT")
    public void invokeQuit(Exchange exchange) {
        this.client.quit();
    }

    @InvokeOnHeader(value="HDEL")
    public void invokeHdel(Exchange exchange) {
        this.client.hdel(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getField(exchange));
    }

    @InvokeOnHeader(value="HEXISTS")
    public Boolean invokeHexists(Exchange exchange) {
        return this.client.hexists(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getField(exchange));
    }

    @InvokeOnHeader(value="HGET")
    public Object invokeHget(Exchange exchange) {
        return this.client.hget(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getField(exchange));
    }

    @InvokeOnHeader(value="HGETALL")
    public Map<String, Object> invokeHgetAll(Exchange exchange) {
        return this.client.hgetAll(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="HINCRBY")
    public Long invokeHincrBy(Exchange exchange) {
        return this.client.hincrBy(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getField(exchange), this.exchangeConverter.getValueAsLong(exchange));
    }

    @InvokeOnHeader(value="HKEYS")
    public Set<String> invokeHkeys(Exchange exchange) {
        return this.client.hkeys(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="HLEN")
    public Long invokeHlen(Exchange exchange) {
        return this.client.hlen(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="HMGET")
    public Collection<Object> invokeHmget(Exchange exchange) {
        return this.client.hmget(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getFields(exchange));
    }

    @InvokeOnHeader(value="HMSET")
    public void invokeHmset(Exchange exchange) {
        this.client.hmset(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValuesAsMap(exchange));
    }

    @InvokeOnHeader(value="HSET")
    public void invokeHset(Exchange exchange) {
        this.client.hset(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getField(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="HSETNX")
    public Boolean invokeHsetnx(Exchange exchange) {
        return this.client.hsetnx(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getField(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="HVALS")
    public Collection<Object> invokeHvals(Exchange exchange) {
        return this.client.hvals(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="DEL")
    public void invokeDel(Exchange exchange) {
        this.client.del(this.exchangeConverter.getKeys(exchange));
    }

    @InvokeOnHeader(value="EXISTS")
    public Boolean invokeExists(Exchange exchange) {
        return this.client.exists(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="EXPIRE")
    public Boolean invokeExpire(Exchange exchange) {
        return this.client.expire(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getTimeout(exchange));
    }

    @InvokeOnHeader(value="EXPIREAT")
    public Boolean invokeExpireat(Exchange exchange) {
        return this.client.expireat(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getTimestamp(exchange));
    }

    @InvokeOnHeader(value="KEYS")
    public Collection<String> invokeKeys(Exchange exchange) {
        return this.client.keys(this.exchangeConverter.getPattern(exchange));
    }

    @InvokeOnHeader(value="MOVE")
    public Boolean invokeMove(Exchange exchange) {
        return this.client.move(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getDb(exchange));
    }

    @InvokeOnHeader(value="PERSIST")
    public Boolean invokePersist(Exchange exchange) {
        return this.client.persist(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="PEXPIRE")
    public Boolean invokePexpire(Exchange exchange) {
        return this.client.pexpire(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getTimeout(exchange));
    }

    @InvokeOnHeader(value="PEXPIREAT")
    public Boolean invokePexpireat(Exchange exchange) {
        return this.client.pexpireat(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getTimestamp(exchange));
    }

    @InvokeOnHeader(value="RANDOMKEY")
    public String invokeRandomkey(Exchange exchange) {
        return this.client.randomkey();
    }

    @InvokeOnHeader(value="RENAME")
    public void invokeRename(Exchange exchange) {
        this.client.rename(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getStringValue(exchange));
    }

    @InvokeOnHeader(value="RENAMENX")
    public Boolean invokeRenamenx(Exchange exchange) {
        return this.client.renamenx(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getStringValue(exchange));
    }

    @InvokeOnHeader(value="SORT")
    public List<Object> invokeSort(Exchange exchange) {
        return this.client.sort(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="TTL")
    public Long invokeTtl(Exchange exchange) {
        return this.client.ttl(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="TYPE")
    public String invokeType(Exchange exchange) {
        return this.client.type(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="BLPOP")
    public Object invokeBlpop(Exchange exchange) {
        return this.client.blpop(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getTimeout(exchange));
    }

    @InvokeOnHeader(value="BRPOP")
    public Object invokeBrpop(Exchange exchange) {
        return this.client.brpop(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getTimeout(exchange));
    }

    @InvokeOnHeader(value="BRPOPLPUSH")
    public Object invokeBrpoplpush(Exchange exchange) {
        return this.client.brpoplpush(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getDestination(exchange), this.exchangeConverter.getTimeout(exchange));
    }

    @InvokeOnHeader(value="LINDEX")
    public Object invokeLindex(Exchange exchange) {
        return this.client.lindex(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getIndex(exchange));
    }

    @InvokeOnHeader(value="LINSERT")
    public Object invokeLinsert(Exchange exchange) {
        return this.client.linsert(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange), this.exchangeConverter.getPivot(exchange), this.exchangeConverter.getPosition(exchange));
    }

    @InvokeOnHeader(value="LLEN")
    public Long invokeLlen(Exchange exchange) {
        return this.client.llen(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="LPOP")
    public Object invokeLpop(Exchange exchange) {
        return this.client.lpop(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="LPUSH")
    public Long invokeLpush(Exchange exchange) {
        return this.client.lpush(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="LPUSHX")
    public Long invokeLpushx(Exchange exchange) {
        return this.client.lpushx(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="LRANGE")
    public List<Object> invokeLrange(Exchange exchange) {
        return this.client.lrange(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getStart(exchange), this.exchangeConverter.getEnd(exchange));
    }

    @InvokeOnHeader(value="LREM")
    public Long invokeLrem(Exchange exchange) {
        return this.client.lrem(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange), this.exchangeConverter.getCount(exchange));
    }

    @InvokeOnHeader(value="LSET")
    public void invokeLset(Exchange exchange) {
        this.client.lset(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange), this.exchangeConverter.getIndex(exchange));
    }

    @InvokeOnHeader(value="LTRIM")
    public void invokeLtrim(Exchange exchange) {
        this.client.ltrim(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getStart(exchange), this.exchangeConverter.getEnd(exchange));
    }

    @InvokeOnHeader(value="RPOP")
    public Object invokeRpop(Exchange exchange) {
        return this.client.rpop(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="RPOPLPUSH")
    public Object invokeRpoplpush(Exchange exchange) {
        return this.client.rpoplpush(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getDestination(exchange));
    }

    @InvokeOnHeader(value="RPUSH")
    public Long invokeRpush(Exchange exchange) {
        return this.client.rpush(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="RPUSHX")
    public Long invokeRpushx(Exchange exchange) {
        return this.client.rpushx(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="PUBLISH")
    public void invokePublish(Exchange exchange) {
        this.client.publish(this.exchangeConverter.getChannel(exchange), this.exchangeConverter.getMessage(exchange));
    }

    @InvokeOnHeader(value="SADD")
    public Long invokeSadd(Exchange exchange) {
        return this.client.sadd(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="SCARD")
    public Long invokeScard(Exchange exchange) {
        return this.client.scard(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="SDIFF")
    public Set<Object> invokeSdiff(Exchange exchange) {
        return this.client.sdiff(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getKeys(exchange));
    }

    @InvokeOnHeader(value="SDIFFSTORE")
    public void invokeSdiffstore(Exchange exchange) {
        this.client.sdiffstore(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getKeys(exchange), this.exchangeConverter.getDestination(exchange));
    }

    @InvokeOnHeader(value="SINTER")
    public Set<Object> invokeSinter(Exchange exchange) {
        return this.client.sinter(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getKeys(exchange));
    }

    @InvokeOnHeader(value="SINTERSTORE")
    public void invokeSinterstore(Exchange exchange) {
        this.client.sinterstore(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getKeys(exchange), this.exchangeConverter.getDestination(exchange));
    }

    @InvokeOnHeader(value="SISMEMBER")
    public Boolean invokeSismember(Exchange exchange) {
        return this.client.sismember(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="SMEMBERS")
    public Set<Object> invokeSmembers(Exchange exchange) {
        return this.client.smembers(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="SMOVE")
    public Boolean invokeSmove(Exchange exchange) {
        return this.client.smove(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange), this.exchangeConverter.getDestination(exchange));
    }

    @InvokeOnHeader(value="SPOP")
    public Object invokeSpop(Exchange exchange) {
        return this.client.spop(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="SRANDMEMBER")
    public Object invokeSrandmember(Exchange exchange) {
        return this.client.srandmember(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="SREM")
    public Long invokeSrem(Exchange exchange) {
        return this.client.srem(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="SUNION")
    public Set<Object> invokeSunion(Exchange exchange) {
        return this.client.sunion(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getKeys(exchange));
    }

    @InvokeOnHeader(value="SUNIONSTORE")
    public void invokeSunionstore(Exchange exchange) {
        this.client.sunionstore(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getKeys(exchange), this.exchangeConverter.getDestination(exchange));
    }

    @InvokeOnHeader(value="ZADD")
    public Boolean invokeZadd(Exchange exchange) {
        return this.client.zadd(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange), this.exchangeConverter.getScore(exchange));
    }

    @InvokeOnHeader(value="ZCARD")
    public Long invokeZcard(Exchange exchange) {
        return this.client.zcard(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="ZCOUNT")
    public Long invokeZcount(Exchange exchange) {
        return this.client.zcount(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getMin(exchange), this.exchangeConverter.getMax(exchange));
    }

    @InvokeOnHeader(value="ZINCRBY")
    public Double invokeZincrby(Exchange exchange) {
        return this.client.zincrby(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange), this.exchangeConverter.getIncrement(exchange));
    }

    @InvokeOnHeader(value="ZINTERSTORE")
    public void invokeZinterstore(Exchange exchange) {
        this.client.zinterstore(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getKeys(exchange), this.exchangeConverter.getDestination(exchange));
    }

    @InvokeOnHeader(value="ZRANGE")
    public Object invokeZrange(Exchange exchange) {
        return this.client.zrange(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getStart(exchange), this.exchangeConverter.getEnd(exchange), this.exchangeConverter.getWithScore(exchange));
    }

    @InvokeOnHeader(value="ZRANGEBYSCORE")
    public Set<Object> invokeZrangebyscore(Exchange exchange) {
        return this.client.zrangebyscore(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getMin(exchange), this.exchangeConverter.getMax(exchange));
    }

    @InvokeOnHeader(value="ZRANK")
    public Long invokeZrank(Exchange exchange) {
        return this.client.zrank(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="ZREM")
    public Long invokeZrem(Exchange exchange) {
        return this.client.zrem(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="ZREMRANGEBYRANK")
    public void invokeZremrangebyrank(Exchange exchange) {
        this.client.zremrangebyrank(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getStart(exchange), this.exchangeConverter.getEnd(exchange));
    }

    @InvokeOnHeader(value="ZREMRANGEBYSCORE")
    public void invokeZremrangebyscore(Exchange exchange) {
        this.client.zremrangebyscore(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getStart(exchange), this.exchangeConverter.getEnd(exchange));
    }

    @InvokeOnHeader(value="ZREVRANGE")
    public Object invokeZrevrange(Exchange exchange) {
        return this.client.zrevrange(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getStart(exchange), this.exchangeConverter.getEnd(exchange), this.exchangeConverter.getWithScore(exchange));
    }

    @InvokeOnHeader(value="ZREVRANGEBYSCORE")
    public Set<Object> invokeZrevrangebyscore(Exchange exchange) {
        return this.client.zrevrangebyscore(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getMin(exchange), this.exchangeConverter.getMax(exchange));
    }

    @InvokeOnHeader(value="ZREVRANK")
    public Long invokeZrevrank(Exchange exchange) {
        return this.client.zrevrank(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="ZUNIONSTORE")
    public void invokeZunionstore(Exchange exchange) {
        this.client.zunionstore(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getKeys(exchange), this.exchangeConverter.getDestination(exchange));
    }

    @InvokeOnHeader(value="APPEND")
    public Integer invokeAppend(Exchange exchange) {
        return this.client.append(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getStringValue(exchange));
    }

    @InvokeOnHeader(value="DECR")
    public Long invokeDecr(Exchange exchange) {
        return this.client.decr(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="DECRBY")
    public Long invokeDecrby(Exchange exchange) {
        return this.client.decrby(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getLongValue(exchange));
    }

    @InvokeOnHeader(value="GET")
    public Object invokeGet(Exchange exchange) {
        return this.client.get(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="GETBIT")
    public Boolean invokeGetbit(Exchange exchange) {
        return this.client.getbit(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getOffset(exchange));
    }

    @InvokeOnHeader(value="GETRANGE")
    public String invokeGetrange(Exchange exchange) {
        return this.client.getrange(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getStart(exchange), this.exchangeConverter.getEnd(exchange));
    }

    @InvokeOnHeader(value="SETRANGE")
    public void invokeSetrange(Exchange exchange) {
        this.client.setex(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange), this.exchangeConverter.getOffset(exchange));
    }

    @InvokeOnHeader(value="GETSET")
    public Object invokeGetset(Exchange exchange) {
        return this.client.getset(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="INCR")
    public Long invokeIncr(Exchange exchange) {
        return this.client.incr(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="INCRBY")
    public Long invokeIncrby(Exchange exchange) {
        return this.client.incrby(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getLongValue(exchange));
    }

    @InvokeOnHeader(value="MGET")
    public List<Object> invokeMget(Exchange exchange) {
        return this.client.mget(this.exchangeConverter.getFields(exchange));
    }

    @InvokeOnHeader(value="MSET")
    public void invokeMset(Exchange exchange) {
        this.client.mset(this.exchangeConverter.getValuesAsMap(exchange));
    }

    @InvokeOnHeader(value="MSETNX")
    public void invokeMsetnx(Exchange exchange) {
        this.client.msetnx(this.exchangeConverter.getValuesAsMap(exchange));
    }

    @InvokeOnHeader(value="SET")
    public void invokeSet(Exchange exchange) {
        this.client.set(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="SETBIT")
    public void invokeSetbit(Exchange exchange) {
        this.client.setbit(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getOffset(exchange), this.exchangeConverter.getBooleanValue(exchange));
    }

    @InvokeOnHeader(value="SETEX")
    public void invokeSetex(Exchange exchange) {
        this.client.setex(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange), this.exchangeConverter.getTimeout(exchange), TimeUnit.SECONDS);
    }

    @InvokeOnHeader(value="SETNX")
    public Boolean invokeSetnx(Exchange exchange) {
        return this.client.setnx(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="STRLEN")
    public Long invokeStrlen(Exchange exchange) {
        return this.client.strlen(this.exchangeConverter.getKey(exchange));
    }

    @InvokeOnHeader(value="DISCARD")
    public void invokeDiscard(Exchange exchange) {
        this.client.discard();
    }

    @InvokeOnHeader(value="EXEC")
    public void invokeExec(Exchange exchange) {
        this.client.exec();
    }

    @InvokeOnHeader(value="MULTI")
    public void invokeMulti(Exchange exchange) {
        this.client.multi();
    }

    @InvokeOnHeader(value="WATCH")
    public void invokeWatch(Exchange exchange) {
        this.client.watch(this.exchangeConverter.getKeys(exchange));
    }

    @InvokeOnHeader(value="UNWATCH")
    public void invokeUnwatch(Exchange exchange) {
        this.client.unwatch();
    }

    @InvokeOnHeader(value="GEOADD")
    public Long invokeGeoadd(Exchange exchange) {
        return this.client.geoadd(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getLongitude(exchange), this.exchangeConverter.getLatitude(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="GEODIST")
    public Distance invokeGeodist(Exchange exchange) {
        return this.client.geodist(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValuesAsCollection(exchange).toArray()[0], this.exchangeConverter.getValuesAsCollection(exchange).toArray()[1]);
    }

    @InvokeOnHeader(value="GEOHASH")
    public List<String> invokeGeohash(Exchange exchange) {
        return this.client.geohash(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="GEOPOS")
    public List<Point> invokeGeopos(Exchange exchange) {
        return this.client.geopos(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange));
    }

    @InvokeOnHeader(value="GEORADIUS")
    public GeoResults<RedisGeoCommands.GeoLocation<Object>> invokeGeoradius(Exchange exchange) {
        return this.client.georadius(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getLongitude(exchange), this.exchangeConverter.getLatitude(exchange), this.exchangeConverter.getRadius(exchange), this.exchangeConverter.getCount(exchange));
    }

    @InvokeOnHeader(value="GEORADIUSBYMEMBER")
    public GeoResults<RedisGeoCommands.GeoLocation<Object>> invokeGeoradiusbymember(Exchange exchange) {
        return this.client.georadius(this.exchangeConverter.getKey(exchange), this.exchangeConverter.getValue(exchange), this.exchangeConverter.getRadius(exchange), this.exchangeConverter.getCount(exchange));
    }
}

