/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import org.apache.camel.CamelContext;
import org.apache.camel.spring.boot.health.HealthCheckVerboseConfiguration;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class CamelHealthIndicator
extends AbstractHealthIndicator {
    private final CamelContext camelContext;
    private final HealthCheckVerboseConfiguration properties;

    public CamelHealthIndicator(CamelContext camelContext, HealthCheckVerboseConfiguration properties) {
        this.camelContext = camelContext;
        this.properties = properties;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        if (this.camelContext == null) {
            builder.unknown();
        } else {
            if (this.properties.isVerbose()) {
                builder.withDetail("name", (Object)this.camelContext.getName());
                builder.withDetail("version", (Object)this.camelContext.getVersion());
            }
            if (this.camelContext.getUptime() != null) {
                builder.withDetail("uptime", (Object)this.camelContext.getUptime());
                builder.withDetail("uptimeMillis", (Object)this.camelContext.getUptimeMillis());
            }
            builder.withDetail("status", (Object)this.camelContext.getStatus().name());
            if (this.camelContext.getStatus().isStarted()) {
                builder.up();
            } else if (this.camelContext.getStatus().isStopped()) {
                builder.down();
            } else {
                builder.unknown();
            }
        }
    }
}

