/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.health;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.camel.converter.TimePatternConverter;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckService;
import org.apache.camel.impl.health.DefaultHealthCheckService;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.health.HealthCheckServiceConfiguration;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={Condition.class})
@EnableConfigurationProperties(value={HealthCheckServiceConfiguration.class})
public class HealthCheckServiceAutoConfiguration {
    @Bean
    @Scope(value="singleton")
    @ConditionalOnBean(value={HealthCheckRegistry.class})
    @ConditionalOnMissingBean
    public HealthCheckService healthCheckService(HealthCheckServiceConfiguration configuration) {
        DefaultHealthCheckService service = new DefaultHealthCheckService();
        Optional.ofNullable(configuration.getCheckInterval()).map(TimePatternConverter::toMilliSeconds).ifPresent(interval -> service.setCheckInterval(interval.longValue(), TimeUnit.MILLISECONDS));
        configuration.getChecks().entrySet().stream().filter(entry -> Objects.nonNull(((HealthCheckServiceConfiguration.Check)entry.getValue()).getOptions())).forEach(entry -> service.setHealthCheckOptions((String)entry.getKey(), ((HealthCheckServiceConfiguration.Check)entry.getValue()).getOptions()));
        return service;
    }

    public static class Condition
    extends GroupCondition {
        public Condition() {
            super("camel.health", "camel.health.check.service");
        }
    }
}

