/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.endpoint;

import org.apache.camel.CamelContext;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.actuate.endpoint.CamelHealthCheckEndpoint;
import org.apache.camel.spring.boot.actuate.endpoint.CamelHealthCheckMvcEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={CamelHealthCheckEndpoint.class})
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class CamelHealthCheckEndpointAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={CamelContext.class})
    @ConditionalOnMissingBean
    public CamelHealthCheckEndpoint healthChecksEndpoint(CamelContext camelContext) {
        return new CamelHealthCheckEndpoint(camelContext);
    }

    @Bean
    @ConditionalOnBean(value={CamelContext.class})
    @ConditionalOnMissingBean
    @ConditionalOnWebApplication
    public CamelHealthCheckMvcEndpoint healthChecksMvcEndpoint(CamelHealthCheckEndpoint delegate) {
        return new CamelHealthCheckMvcEndpoint(delegate);
    }
}

