/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelSpringBootApplicationController;
import org.apache.camel.spring.boot.FatJarPackageScanClassResolver;
import org.apache.camel.spring.boot.RoutesCollector;
import org.apache.camel.spring.boot.SpringPropertiesParser;
import org.apache.camel.spring.boot.TypeConversionConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={CamelConfigurationProperties.class})
@Import(value={TypeConversionConfiguration.class})
public class CamelAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CamelContext.class})
    CamelContext camelContext(ApplicationContext applicationContext, CamelConfigurationProperties config) {
        SpringCamelContext camelContext = new SpringCamelContext(applicationContext);
        SpringCamelContext.setNoStart((boolean)true);
        if (!config.isJmxEnabled()) {
            camelContext.disableJMX();
        }
        if (config.getName() != null) {
            camelContext.setName(config.getName());
        }
        if (config.getLogDebugMaxChars() > 0) {
            camelContext.getProperties().put("CamelLogDebugBodyMaxChars", "" + config.getLogDebugMaxChars());
        }
        camelContext.setStreamCaching(Boolean.valueOf(config.isStreamCaching()));
        camelContext.setTracing(Boolean.valueOf(config.isTracing()));
        camelContext.setMessageHistory(Boolean.valueOf(config.isMessageHistory()));
        camelContext.setHandleFault(Boolean.valueOf(config.isHandleFault()));
        camelContext.setAutoStartup(Boolean.valueOf(config.isAutoStartup()));
        camelContext.setAllowUseOriginalMessage(Boolean.valueOf(config.isAllowUseOriginalMessage()));
        if (camelContext.getManagementStrategy().getManagementAgent() != null) {
            camelContext.getManagementStrategy().getManagementAgent().setEndpointRuntimeStatisticsEnabled(Boolean.valueOf(config.isEndpointRuntimeStatisticsEnabled()));
            camelContext.getManagementStrategy().getManagementAgent().setStatisticsLevel(config.getJmxManagementStatisticsLevel());
            camelContext.getManagementStrategy().getManagementAgent().setManagementNamePattern(config.getJmxManagementNamePattern());
            camelContext.getManagementStrategy().getManagementAgent().setCreateConnector(Boolean.valueOf(config.isJmxCreateConnector()));
        }
        camelContext.setPackageScanClassResolver((PackageScanClassResolver)new FatJarPackageScanClassResolver());
        return camelContext;
    }

    @Bean
    CamelSpringBootApplicationController applicationController(ApplicationContext applicationContext, CamelContext camelContext) {
        return new CamelSpringBootApplicationController(applicationContext, camelContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={RoutesCollector.class})
    RoutesCollector routesCollector(ApplicationContext applicationContext, CamelConfigurationProperties config) {
        Collection configurations = applicationContext.getBeansOfType(CamelContextConfiguration.class).values();
        return new RoutesCollector(applicationContext, new ArrayList<CamelContextConfiguration>(configurations), config);
    }

    @Bean(initMethod="", destroyMethod="")
    @ConditionalOnMissingBean(value={ProducerTemplate.class})
    ProducerTemplate producerTemplate(CamelContext camelContext, CamelConfigurationProperties config) {
        return camelContext.createProducerTemplate(config.getProducerTemplateCacheSize());
    }

    @Bean(initMethod="", destroyMethod="")
    @ConditionalOnMissingBean(value={ConsumerTemplate.class})
    ConsumerTemplate consumerTemplate(CamelContext camelContext, CamelConfigurationProperties config) {
        return camelContext.createConsumerTemplate(config.getConsumerTemplateCacheSize());
    }

    @Bean
    PropertiesParser propertiesParser() {
        return new SpringPropertiesParser();
    }

    @Bean(initMethod="", destroyMethod="")
    PropertiesComponent properties(CamelContext camelContext, PropertiesParser parser) {
        if (camelContext.hasComponent("properties") != null) {
            return (PropertiesComponent)camelContext.getComponent("properties", PropertiesComponent.class);
        }
        PropertiesComponent pc = new PropertiesComponent();
        pc.setPropertiesParser(parser);
        return pc;
    }

    @Bean
    CamelBeanPostProcessor camelBeanPostProcessor(ApplicationContext applicationContext) {
        CamelBeanPostProcessor processor = new CamelBeanPostProcessor();
        processor.setApplicationContext(applicationContext);
        return processor;
    }
}

