/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunk;

import com.splunk.Service;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.splunk.ConsumerType;
import org.apache.camel.component.splunk.ProducerType;
import org.apache.camel.component.splunk.SplunkComponent;
import org.apache.camel.component.splunk.SplunkConfiguration;
import org.apache.camel.component.splunk.SplunkConsumer;
import org.apache.camel.component.splunk.SplunkProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.13.0", scheme="splunk", title="Splunk", syntax="splunk:name", category={Category.IOT, Category.MONITORING})
public class SplunkEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    private static final Logger LOG = LoggerFactory.getLogger(SplunkEndpoint.class);
    private static final Pattern SPLUNK_SCHEMA_PATTERN = Pattern.compile("splunk:(//)*");
    private static final Pattern SPLUNK_OPTIONS_PATTER = Pattern.compile("\\?.*");
    private Service service;
    @UriParam
    private SplunkConfiguration configuration;

    public SplunkEndpoint() {
    }

    public SplunkEndpoint(String uri, SplunkComponent component, SplunkConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public String getServiceUrl() {
        return this.configuration.getHost() + ":" + this.configuration.getPort();
    }

    public String getServiceProtocol() {
        return "splunk";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getUsername() != null) {
            return Map.of("username", this.configuration.getUsername());
        }
        return null;
    }

    public Producer createProducer() throws Exception {
        String[] uriSplit = SplunkEndpoint.splitUri(this.getEndpointUri());
        if (uriSplit.length > 0) {
            ProducerType producerType = ProducerType.fromUri(uriSplit[0]);
            return new SplunkProducer(this, producerType);
        }
        throw new IllegalArgumentException("Cannot create any producer with uri " + this.getEndpointUri() + ". A producer type was not provided (or an incorrect pairing was used).");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.configuration.getInitEarliestTime() == null) {
            throw new IllegalArgumentException("Required initialEarliestTime option could not be found");
        }
        String[] uriSplit = SplunkEndpoint.splitUri(this.getEndpointUri());
        if (uriSplit.length > 0) {
            ConsumerType consumerType = ConsumerType.fromUri(uriSplit[0]);
            SplunkConsumer consumer = new SplunkConsumer(this, processor, consumerType);
            this.configureConsumer((Consumer)consumer);
            return consumer;
        }
        throw new IllegalArgumentException("Cannot create any consumer with uri " + this.getEndpointUri() + ". A consumer type was not provided (or an incorrect pairing was used).");
    }

    protected void doStop() throws Exception {
        this.service = null;
        super.doStop();
    }

    public Service getService() {
        if (this.service == null) {
            this.service = this.configuration.getConnectionFactory().createService(this.getCamelContext());
        }
        return this.service;
    }

    private static String[] splitUri(String uri) {
        uri = SPLUNK_SCHEMA_PATTERN.matcher(uri).replaceAll("");
        uri = SPLUNK_OPTIONS_PATTER.matcher(uri).replaceAll("");
        return uri.split("/");
    }

    public SplunkConfiguration getConfiguration() {
        return this.configuration;
    }

    public synchronized boolean reset(Exception e) {
        boolean answer = false;
        if (e instanceof RuntimeException && e.getCause() instanceof ConnectException || e instanceof SocketException || e instanceof SSLException) {
            LOG.warn("Got exception from Splunk. Service will be reset.");
            this.service = null;
            answer = true;
        }
        return answer;
    }
}

