/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.camel.component.solr.SolrEndpoint;
import org.apache.camel.component.solr.SolrOperation;
import org.apache.camel.component.solr.SolrUtils;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClientBase;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.SolrPing;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SolrProducer.class);
    protected final SolrConfiguration configuration;

    public SolrProducer(SolrEndpoint endpoint, SolrConfiguration config) {
        super((Endpoint)endpoint);
        this.configuration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean doneSync;
        boolean hasSolrParams;
        Message message = exchange.getMessage();
        SolrClient solrClient = this.getSolrClient();
        String collection = Optional.ofNullable((String)message.getHeader("CamelSolrCollection", String.class)).orElse(this.configuration.getCollection());
        String requestHandler = message.getHeaders().containsKey("CamelSolrRequestHandler") ? (String)message.getHeader("CamelSolrRequestHandler", String.class) : this.configuration.getRequestHandler();
        ModifiableSolrParams modifiableSolrParams = SolrProducer.getAndGroupedSolrParams(message);
        boolean bl = hasSolrParams = modifiableSolrParams.size() > 0;
        if (this.configuration.isAutoCommit()) {
            SolrUtils.addHeadersForCommit(modifiableSolrParams);
        }
        if (message.getBody() == null) {
            message.setBody(new Object());
        }
        SolrOperation operation = this.resolveSolrOperation(exchange, hasSolrParams);
        ActionContext ctx = new ActionContext(this.configuration, exchange, callback, solrClient, operation, collection, requestHandler, modifiableSolrParams);
        exchange.setProperty("SolrActionContext", (Object)ctx);
        try {
            SolrRequest solrRequest = operation == null ? (SolrRequest)exchange.getMessage().getMandatoryBody(SolrRequest.class) : operation.getSolrRequest(ctx);
            doneSync = SolrEndpoint.isProcessAsync(ctx.solrClient(), ctx.configuration()) ? this.processSolrActionAsync(ctx, solrRequest) : this.processSolrAction(ctx, solrRequest);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            ctx.callback.done(true);
            boolean bl2 = true;
            return bl2;
        }
        finally {
            exchange.removeProperty("SolrActionContext");
        }
        return doneSync;
    }

    private boolean processSolrActionAsync(ActionContext ctx, SolrRequest<?> solrRequest) {
        this.onComplete(ctx.getAsyncSolrClient().requestAsync(solrRequest, ctx.collection()), ctx);
        return false;
    }

    private boolean processSolrAction(ActionContext ctx, SolrRequest<?> solrRequest) throws SolrServerException, IOException {
        ctx.exchange().getMessage().setBody((Object)ctx.solrClient().request(solrRequest, ctx.collection()));
        ctx.callback.done(true);
        return true;
    }

    private static ModifiableSolrParams getAndGroupedSolrParams(Message message) {
        SolrParams solrParams = (SolrParams)message.getHeader("CamelSolrParams", SolrParams.class);
        ModifiableSolrParams modifiableSolrParams = solrParams instanceof ModifiableSolrParams ? (ModifiableSolrParams)solrParams : new ModifiableSolrParams(solrParams);
        message.getHeaders().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("SolrParam.")).forEach(entry -> {
            String paramName = ((String)entry.getKey()).substring("SolrParam.".length());
            Object value = entry.getValue();
            if (value instanceof Iterable) {
                Iterable iterable = (Iterable)value;
                for (Object val : iterable) {
                    modifiableSolrParams.add(paramName, new String[]{val.toString()});
                }
            } else {
                modifiableSolrParams.add(paramName, new String[]{entry.getValue().toString()});
            }
        });
        return modifiableSolrParams;
    }

    private <T> void onComplete(CompletableFuture<T> future, ActionContext ctx) {
        Exchange exchange = ctx.exchange();
        ((CompletableFuture)future.thenAccept(r -> exchange.getMessage().setBody(r))).whenComplete((r, e) -> {
            try {
                if (e != null) {
                    exchange.setException((Throwable)new CamelExchangeException("An error occurred while executing the action", exchange, e));
                }
            }
            finally {
                ctx.callback().done(false);
            }
        });
    }

    public SolrClient getSolrClient() {
        return ((SolrEndpoint)super.getEndpoint()).getSolrClient();
    }

    private SolrOperation resolveSolrOperation(Exchange exchange, boolean hasSolrParams) {
        Object body = exchange.getMessage().getBody();
        if (ObjectHelper.isNotEmpty((Object)body)) {
            LOG.debug("Operation request body: {}", body);
        }
        if (body instanceof SolrPing) {
            return SolrOperation.PING;
        }
        if (body instanceof SolrQuery || body instanceof QueryRequest || exchange.getMessage().getHeader("CamelSolrQueryString") != null) {
            return SolrOperation.SEARCH;
        }
        if (body instanceof Map || body instanceof WrappedFile || body instanceof File || body instanceof UpdateRequest) {
            return SolrOperation.INSERT;
        }
        if (body instanceof SolrRequest) {
            return null;
        }
        if (body instanceof Collection) {
            Collection collection = (Collection)body;
            return SolrUtils.isCollectionOfType(collection, String.class) ? SolrOperation.DELETE : SolrOperation.INSERT;
        }
        String actionString = (String)exchange.getMessage().getHeader("CamelSolrOperation", String.class);
        if (ObjectHelper.isNotEmpty((String)actionString)) {
            SolrOperation operation = SolrOperation.getSolrOperationFrom(actionString);
            if (operation != null && !operation.name().equalsIgnoreCase(actionString)) {
                LOG.warn(operation.createFutureDeprecationMessage(actionString, operation.getActionParameter(actionString)));
            }
            LOG.debug("Operation obtained from header '{}': {}", (Object)"CamelSolrOperation", (Object)actionString);
            return operation;
        }
        if (this.configuration.getOperation() != null) {
            SolrOperation operation = this.configuration.getOperation();
            LOG.debug("Operation obtained from config: {}", (Object)operation);
            return operation;
        }
        if (hasSolrParams) {
            return SolrOperation.INSERT;
        }
        throw new IllegalArgumentException("CamelSolrOperation value is mandatory");
    }

    public record ActionContext(SolrConfiguration configuration, Exchange exchange, AsyncCallback callback, SolrClient solrClient, SolrOperation operation, String collection, String requestHandler, ModifiableSolrParams solrParams) {
        public ActionContext {
            ObjectHelper.notNull((Object)solrClient, (String)"SolrClient");
            ObjectHelper.notNull((Object)collection, (String)"CamelSolrCollection");
            ObjectHelper.notNull((Object)solrParams, (String)"CamelSolrParams");
        }

        public HttpSolrClientBase getAsyncSolrClient() {
            SolrClient solrClient = this.solrClient;
            if (solrClient instanceof HttpSolrClientBase) {
                HttpSolrClientBase httpSolrClientBase = (HttpSolrClientBase)solrClient;
                return httpSolrClientBase;
            }
            throw new UnsupportedOperationException(ActionContext.getAsyncProcessingErrorDetails(this.solrClient));
        }

        private static String getAsyncProcessingErrorDetails(SolrClient solrClient) {
            return String.format("Async processing requires a solr client instance of HttpSolrClientBase. This solr client is of type %s.", solrClient.getClass().getCanonicalName());
        }
    }
}

