/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap.name;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.camel.dataformat.soap.name.ElementNameStrategy;
import org.apache.camel.util.ObjectHelper;

public class XmlRootElementPreferringElementNameStrategy
implements ElementNameStrategy {
    private static final String DEFAULT_NS = "##default";

    @Override
    public QName findQNameForSoapActionOrType(String soapAction, Class<?> type) {
        XmlSchema xmlSchema;
        XmlType xmlType = type.getAnnotation(XmlType.class);
        if (xmlType == null || xmlType.name() == null) {
            throw new RuntimeException("The type " + type.getName() + " needs to have an XmlType annotation with name");
        }
        String localName = null;
        String nameSpace = null;
        XmlRootElement root = type.getAnnotation(XmlRootElement.class);
        if (root != null) {
            localName = ObjectHelper.isEmpty(localName) ? root.name() : localName;
            String string = nameSpace = this.isInValidNamespace(nameSpace) ? root.namespace() : nameSpace;
        }
        if (ObjectHelper.isEmpty(localName)) {
            localName = xmlType.name();
        }
        if (this.isInValidNamespace(nameSpace) && (xmlSchema = type.getPackage().getAnnotation(XmlSchema.class)) != null) {
            nameSpace = xmlSchema.namespace();
        }
        if (this.isInValidNamespace(nameSpace)) {
            nameSpace = xmlType.namespace();
        }
        if (ObjectHelper.isEmpty((String)localName) || this.isInValidNamespace(nameSpace)) {
            throw new IllegalStateException("Unable to determine localName or namespace for type <" + type.getName() + ">");
        }
        return new QName(nameSpace, localName);
    }

    private boolean isInValidNamespace(String namespace) {
        return ObjectHelper.isEmpty((String)namespace) || DEFAULT_NS.equalsIgnoreCase(namespace);
    }

    @Override
    public Class<? extends Exception> findExceptionForFaultName(QName faultName) {
        throw new UnsupportedOperationException("Exception lookup is not supported");
    }

    @Override
    public Class<? extends Exception> findExceptionForSoapActionAndFaultName(String soapAction, QName faultName) {
        throw new UnsupportedOperationException("Exception lookup is not supported");
    }
}

