/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snakeyaml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.component.snakeyaml.CustomClassLoaderConstructor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.inspector.TagInspector;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

@Dataformat(value="snakeYaml")
public final class SnakeYAMLDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private CamelContext camelContext;
    private final ThreadLocal<WeakReference<Yaml>> yamlCache = new ThreadLocal();
    private BaseConstructor constructor;
    private Representer representer;
    private DumperOptions dumperOptions;
    private Resolver resolver;
    private ClassLoader classLoader;
    private String unmarshalTypeName;
    private Class<?> unmarshalType;
    private boolean useApplicationContextClassLoader = true;
    private boolean prettyFlow;
    private boolean allowAnyType;
    private String typeFilters;
    private int maxAliasesForCollections = 50;
    private boolean allowRecursiveKeys;

    public SnakeYAMLDataFormat() {
        this(null);
    }

    public SnakeYAMLDataFormat(Class<?> type) {
        this.unmarshalType = type;
    }

    public String getDataFormatName() {
        return "snakeYaml";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        try (OutputStreamWriter osw = new OutputStreamWriter(stream, ExchangeHelper.getCharsetName((Exchange)exchange));){
            this.getYaml().dump(graph, (Writer)osw);
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.unmarshal(exchange, (Object)stream);
    }

    public Object unmarshal(Exchange exchange, Object body) throws Exception {
        Class unmarshalObjectType;
        Class clazz = unmarshalObjectType = this.unmarshalType != null ? this.unmarshalType : Object.class;
        if (body instanceof String) {
            String s = (String)body;
            return this.getYaml().loadAs(s, unmarshalObjectType);
        }
        if (body instanceof Reader) {
            Reader r = (Reader)body;
            return this.getYaml().loadAs(r, unmarshalObjectType);
        }
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, body);
        InputStreamReader r = new InputStreamReader(is, ExchangeHelper.getCharsetName((Exchange)exchange));
        return this.getYaml().loadAs((Reader)r, unmarshalObjectType);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.unmarshalTypeName != null && this.unmarshalType == null) {
            this.setUnmarshalType(this.camelContext.getClassResolver().resolveClass(this.unmarshalTypeName));
        }
        if (this.unmarshalType != null) {
            this.typeFilters = this.typeFilters == null ? this.unmarshalType.getName() : this.typeFilters + "," + this.unmarshalType.getName();
        }
        if (this.allowAnyType) {
            this.typeFilters = "*";
        }
        if (this.constructor == null) {
            this.constructor = this.defaultConstructor(this.camelContext);
        }
        if (this.representer == null) {
            this.representer = this.defaultRepresenter();
        }
        if (this.dumperOptions == null) {
            this.dumperOptions = this.defaultDumperOptions();
        }
        if (this.resolver == null) {
            this.resolver = this.defaultResolver();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.yamlCache.remove();
    }

    private Yaml getYaml() {
        Yaml yaml = null;
        WeakReference<Yaml> ref = this.yamlCache.get();
        if (ref != null) {
            yaml = (Yaml)ref.get();
        }
        if (yaml == null) {
            LoaderOptions options = new LoaderOptions();
            options.setTagInspector((TagInspector)new TrustedTagInspector());
            options.setAllowRecursiveKeys(this.allowRecursiveKeys);
            options.setMaxAliasesForCollections(this.maxAliasesForCollections);
            yaml = new Yaml(this.constructor, this.representer, this.dumperOptions, options, this.resolver);
            this.yamlCache.set(new WeakReference<Yaml>(yaml));
        }
        return yaml;
    }

    public BaseConstructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(BaseConstructor constructor) {
        this.constructor = constructor;
    }

    public Representer getRepresenter() {
        return this.representer;
    }

    public void setRepresenter(Representer representer) {
        this.representer = representer;
    }

    public DumperOptions getDumperOptions() {
        return this.dumperOptions;
    }

    public void setDumperOptions(DumperOptions dumperOptions) {
        this.dumperOptions = dumperOptions;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public void setTypeFilters(String typeFilters) {
        this.typeFilters = typeFilters;
    }

    public void setTypeFilters(Class<?> typeFilters) {
        this.typeFilters = typeFilters.getName();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public boolean isUseApplicationContextClassLoader() {
        return this.useApplicationContextClassLoader;
    }

    public void setUseApplicationContextClassLoader(boolean useApplicationContextClassLoader) {
        this.useApplicationContextClassLoader = useApplicationContextClassLoader;
    }

    public boolean isPrettyFlow() {
        return this.prettyFlow;
    }

    public void setPrettyFlow(boolean prettyFlow) {
        this.prettyFlow = prettyFlow;
    }

    public boolean isAllowAnyType() {
        return this.allowAnyType;
    }

    public void setAllowAnyType(boolean allowAnyType) {
        this.allowAnyType = allowAnyType;
    }

    public int getMaxAliasesForCollections() {
        return this.maxAliasesForCollections;
    }

    public void setMaxAliasesForCollections(int maxAliasesForCollections) {
        this.maxAliasesForCollections = maxAliasesForCollections;
    }

    public boolean isAllowRecursiveKeys() {
        return this.allowRecursiveKeys;
    }

    public void setAllowRecursiveKeys(boolean allowRecursiveKeys) {
        this.allowRecursiveKeys = allowRecursiveKeys;
    }

    private BaseConstructor defaultConstructor(CamelContext context) {
        SafeConstructor yamlConstructor;
        LoaderOptions options = new LoaderOptions();
        options.setTagInspector((TagInspector)new TrustedTagInspector());
        options.setAllowRecursiveKeys(this.allowRecursiveKeys);
        options.setMaxAliasesForCollections(this.maxAliasesForCollections);
        if (this.typeFilters != null) {
            ClassLoader yamlClassLoader = this.classLoader;
            if (yamlClassLoader == null && this.useApplicationContextClassLoader) {
                yamlClassLoader = context.getApplicationContextClassLoader();
            }
            yamlConstructor = yamlClassLoader != null ? this.typeFilterConstructor(yamlClassLoader, options) : this.typeFilterConstructor(options);
        } else {
            yamlConstructor = new SafeConstructor(options);
        }
        return yamlConstructor;
    }

    private Representer defaultRepresenter() {
        return new Representer(new DumperOptions());
    }

    private DumperOptions defaultDumperOptions() {
        DumperOptions yamlDumperOptions = new DumperOptions();
        yamlDumperOptions.setPrettyFlow(this.prettyFlow);
        return yamlDumperOptions;
    }

    private Resolver defaultResolver() {
        return new Resolver();
    }

    private boolean allowTypeFilter(String className) {
        if (this.typeFilters == null) {
            return true;
        }
        return PatternHelper.matchPatterns((String)className, (String[])this.typeFilters.split(","));
    }

    private Constructor typeFilterConstructor(LoaderOptions options) {
        return new Constructor(options){

            protected Class<?> getClassForName(String name) throws ClassNotFoundException {
                if (!SnakeYAMLDataFormat.this.allowTypeFilter(name)) {
                    throw new IllegalArgumentException("Type " + name + " is not allowed");
                }
                return super.getClassForName(name);
            }
        };
    }

    private Constructor typeFilterConstructor(ClassLoader classLoader, LoaderOptions options) {
        return new CustomClassLoaderConstructor(classLoader, options){

            @Override
            protected Class<?> getClassForName(String name) throws ClassNotFoundException {
                if (!SnakeYAMLDataFormat.this.allowTypeFilter(name)) {
                    throw new IllegalArgumentException("Type " + name + " is not allowed");
                }
                return super.getClassForName(name);
            }
        };
    }

    final class TrustedTagInspector
    implements TagInspector {
        TrustedTagInspector() {
        }

        public boolean isGlobalTagAllowed(Tag tag) {
            return true;
        }
    }
}

